
#include <stdio.h>
#include <dos.h>


int testport,testintflag,testvect,testand,testor;
void interrupt (*comxold)();

main() {
	int port,bits,i,j;
	puts("PROGRAM TO TEST UART TYPE ver 3.0  9-27-99 JFK");
	port=0x3f8;
	printf("\nTESTING COM1 - SERIAL PORT AT %3X\n",port);
	i=testit(port);
	if(i) {
	   testintflag=0; /* zero the test flag */
	   initcomx(port,0x0c,0xef,0x10); /* initialize the com port for int */
	   sleep(2);  /* wait for 2 sec */
	   resetcomx();  /* put the com vectors back */
	   if(testintflag==1)
	      printf("    UART AT %3X RECEIVED TX INT ON IRQ %d\n",testport,testvect-8);
	   else
	      printf("    ****  UART AT %3X FAILED TX INT ON IRQ %d  ****\n",testport,testvect-8);
	}
	port=0x2f8;
	printf("\nTESTING COM2 - SERIAL PORT AT %3X\n",port);
	i=testit(port);
	if(i) {
	   testintflag=0; /* zero the test flag */
	   initcomx(port,0x0b,0xf7,0x08); /* initialize the com port for int */
	   sleep(2);  /* wait for 2 sec */
	   resetcomx();  /* put the com vectors back */
	   if(testintflag==1)
	      printf("    UART AT %3X RECEIVED TX INT ON IRQ %d\n",testport,testvect-8);
	   else
	      printf("    ****  UART AT %3X FAILED TX INT ON IRQ %d  ****\n",testport,testvect-8);
	}
	port=0x3e8;
	printf("\nTESTING COM3 - SERIAL PORT AT %3X\n",port);
	i=testit(port);
	if(i) {
	   testintflag=0; /* zero the test flag */
	   initcomx(port,0x0c,0xef,0x10); /* initialize the com port for int */
	   sleep(2);  /* wait for 2 sec */
	   resetcomx();  /* put the com vectors back */
	   if(testintflag==1)
	      printf("    UART AT %3X RECEIVED TX INT ON IRQ %d\n",testport,testvect-8);
	   else
	      printf("    ****  UART AT %3X FAILED TX INT ON IRQ %d  ****\n",testport,testvect-8);
	}
	port=0x2e8;
	printf("\nTESTING COM4 - SERIAL PORT AT %3X\n",port);
	i=testit(port);
	if(i) {
	   testintflag=0; /* zero the test flag */
	   initcomx(port,0x0b,0xf7,0x08); /* initialize the com port for int */
	   sleep(2);  /* wait for 2 sec */
	   resetcomx();  /* put the com vectors back */
	   if(testintflag==1)
	      printf("    UART AT %3X RECEIVED TX INT ON IRQ %d\n",testport,testvect-8);
	   else
	      printf("    ****  UART AT %3X FAILED TX INT ON IRQ %d  ****\n",testport,testvect-8);
	}
}

testit(int port) {
	int i,j,status,ier,divhi,divlo;
/*
	TEST IER REGISTER FOR LOWER 4 BITS ACTIVE
*/
	status=inportb(port+3); /* save uart status */
	outportb(port+3,status & 0x7F); /* normal operation */
	ier=inportb(port+1);  /* save IER reg */
	outportb(port+1,0xff);  /* write ff's to IER */
	i=inportb(port+1);  /* read back IER reg bits */
	outportb(port+1,ier);  /* restore IER reg */
	outportb(port+3,status);  /* restore status */
	if(i!=0x0f) {  /* if IER didn't got to 0x0f, no uart */
	   printf("    NO UART FOUND AT %3X ADDRESS (IER TEST)\n",port);
	   return(0);
	}
/*
	TEST BAUD DIVISOR REGISTER ( 2 ACTIVE 8 BIT REG )
*/
	outportb(port+3,0x80 | status); /* access baud rate divisor reg */
	divlo=inportb(port);divhi=inportb(port+1); /* save old div values */
	outportb(port,0x55);outportb(port+1,0xaa); /* try to change them */
	i=inportb(port);j=inportb(port+1);  /* read the new values */
	outportb(port,divlo);outportb(port+1,divhi); /* restore old values */
	outportb(port+3,status); /* restore status */
	if( (i!=0x55) || (j!=0xAA) ) {
	   printf("    NO UART FOUND AT %3X ADDRESS (BAUD RATE REG TEST)\n",port);
	   return(0);
	}
	outportb(port+2,0x07);  /* enable FIFO reg */
	if(inportb(port+2) & 0xc0) { /* FIFO enabled */
	   if((inportb(port+2) & 0xc0) == 0xc0) {
	      puts("    THIS UART IS A 16550A PART WITH A GOOD FIFO");
	      return(4);
	   }
	   puts("    THIS UART IS A 16550 PART WITH A BAD FIFO");
	   outportb(port+2,0x00);  /* disable FIFO reg */
	   return(3);
	}
	outportb(port+7,0x55);  /* write to scratch reg */
	if(inportb(port+7) == 0x55) { /* scratchpad reg present */
	   puts("    THIS UART IS A 16450 PART");
	   return(2);
	}
	puts("    THIS UART IS AN 8250 PART");
	return(1);
}

void interrupt comxnew() {  /* com tx int comes here */
	int i;

	while(1) {
	  i=input(testport+2);
	  if(i & 1) break;
	  i=((i>>1) & 3);
	  if(i==3) {  /* process line status int */
	    i = inportb(testport+5);  /* read uart error status bits */
	    continue;
	  }
	  if(i==0) { /* process modem status reg int */
	    i = inportb(testport+6);  /* read line change status  */
	    continue;
	  }
	  if(i==2) {  /* process rx data interrupt */
	    i = inportb(testport);
	    continue;
	  }
	  if(i == 1) {  /* process tx holding reg empty interrupt  */
	    testintflag=1; /* got an int, flag it */
	   /* nothing to send, turn off int */
	    i=inportb(testport+1);goto t1;
t1:	    outportb(testport+1,i & 0xfd); /* disable tx mask bit */
	    continue;
	  }
	  break; /* none of the above int, done with 8250 */
	}
	outportb(0x20,0x20);  /* send EOI to 8259  */
	return;
}

resetcomx() {  /* restore old comx vector, clear mask bits */
	disable();
	setvect(testvect,comxold);  /* go back to old vector */
	output(0x21,input(0x21) | testor); /* disable mask bit on 8259 */
	output(testport+1,0);  /* disable mask bits on 8250 */
	enable();
}

initcomx(int port,int vect, int maskand, int maskor) {  /* initialize the com port for int */
	int i;
	testport=port;testvect=vect;testand=maskand;testor=maskor;
	disable();
/*	SET THE BAUD RATE FOR THE 8250 UART  */
	output(testport+3,0x80);output(testport,0x01);output(testport+1,0x00);
/*	SET THE DATA WORD PARAMETERS: PARITY, DATA BITS, STOP BITS  */
	output(testport+3,0x03);
/*	SWAP INTERRUPT ENTRY POINTS, ENABLE RX INT, MASK 8259   */
	comxold=getvect(testvect);  /* hardware COMX int vector */
	setvect(testvect,comxnew);
	output(testport+1,input(testport+1) | 0x0d);  /* int enable RX, modem, errors on 8250 */
	output(testport+4,input(testport+4) | 0x0b); /* DTR(D0), RTS(D1), EN int(D3) */
	i=input(testport+1);
	if((i & 2) == 0) output(testport+1,i | 2); /* enable tx reg empty int */
	output(0x21,input(0x21) & testand); /* enable mask bit on 8259 */
	enable();
}
