/*
	  MOTRTCM.C - PROGRAM TO CONVERT MOTOROLA VP @@Ce
	  MESSAGES INTO RTCM SC-104 TYPE 1 DGPS CORRECTIONS
*/
/*
  Copyright (c) 1999, Jim Korenz.  All rights reserved.  This program
  may be used only for non-commercial purposes, and carries no warranty
  of any kind, including any implied warranty of fitness for any particular
  purpose.
*/
#include	<stdlib.h>
#include	<stdio.h>
#include	<dos.h>
#include	<bios.h>
#include	<alloc.h>
#include	<fcntl.h>
#include	<io.h>
#define		COM1
#include	"cx.h"
#define		COM2
#include	"cx.h"

/*   routine to transfer binary files  */

	union REGS regs;
	char tbufr[8192];
	char bufr[80];
	char rtcbufr[6];

#define SATMAX 12

	char msgstart[4]={'@','@','C','e'};  /* message header bytes */
	int msglen=50;  /* total length of message */
	unsigned char msgbufr[80];
	unsigned char *msgptr;
	int msgcnt;
	int mot8flag;
	int msg1stflag;
	int debugflag;
	int inputstream;
	int outputstream;
	int msgsatcnt;
	int state;
	int msgsatid[SATMAX];
	long msgprc[SATMAX];
	long msgprrc[SATMAX];
	int msgiode[SATMAX];
	long rtcmzcount;
	long oldmottime;
	long rtcmmsgcount;
	long motmsgcount;
	long nwordsout;
	int rtcmseq;
	unsigned long rtcword;
	int rtcbits;
	int parity29,parity30;
	FILE *fp,*f2;

char flip[64]={
	0,32,16,48,8,40,24,56,4,36,20,52,12,44,28,60,
	2,34,18,50,10,42,26,58,6,38,22,54,14,46,30,62,
	1,33,17,49,9,41,25,57,5,37,21,53,13,45,29,61,
	3,35,19,51,11,43,27,59,7,39,23,55,15,47,31,63
};

int stuffbits( int, unsigned long);

main(argc,argv)
	int argc;char *argv[];
{
	int i,j,k,bits,stopbits;
	long ncharin,baud,bintime;
	char parity;

	puts("\nMOTRTCM - CONVERT MOTOROLA BINARY INTO RTCM SC-104 TYPE 1  ver 1.6  N8PXW");
	baud=9600;bits=8;stopbits=1;parity='n';
	if(argc<2) {
	   puts("MOTRTCM - correct useage > MOTRTCM  infile outfile");
	   puts("MOTRTCM - correct useage > MOTRTCM  COM1baudrate COM2baudrate (i.e. 9600,N,8,1)");
	   puts("  If the COM2 baud rate is specified, the RTCM messages will be sent to COM2");
	   puts("NOTE: COM1 is assumed to be I/O add 0x3f8 IRQ 4, COM2 0x2f8 IRQ 3");
	   puts("The optional parm -Dx ,debug level, may be specified.(default value 2). Range 0-5.");
	   exit(0);
	}
/*
     ALLOW INPUT FROM COM1 OR A FILE
*/
	inputstream=0;
	outputstream=0;
	i=sscanf(argv[1],"%ld,%c,%d,%d",
	   &baud,&parity,&bits,&stopbits);
	if(i==4) {
	   inputstream=1;  /*  1 is com1 for input  */
	   printf("SETTING COM1 BAUD RATE OF %ld, PARITY = %c, BITS %d, STOP %d\n",
	      baud,parity,bits,stopbits);
	   com1_init(baud,parity,bits,stopbits,4096,4000,100);
	   puts("EXPECTING MOTOROLA ONCORE VP MESSAGES ON COM1 INPUT");
	} else {
	   inputstream=2;  /*  2 is file for input  */
	   fp=fopen(argv[1],"rb");
	   if(fp==NULL) {printf("ERROR OPENING INPUT FILE %s",argv[1]);exit(1);}
	   else printf("READING MOTOROLA ONCORE VP MESSAGES FROM FILE %s\n",argv[1]);
	}
	if(argc>=3 & *argv[2]!='-') {
	   i=sscanf(argv[2],"%ld,%c,%d,%d",&baud,&parity,&bits,&stopbits);
	   if(i==4) {  /* if we have the right no. of args, use COM2 */
	      if(inputstream!=1) {  /* output to COM1  */
	         outputstream=1;  /*  1 is com1 for output  */
	         printf("SETTING COM1 BAUD RATE OF %ld, PARITY = %c, BITS %d, STOP %d\n",
	            baud,parity,bits,stopbits);
	         com1_init(baud,parity,bits,stopbits,4096,4000,100);
	         puts("SENDING RTCM SC-104 MESSAGES TO COM1 OUTPUT");
	      } else {
	         outputstream=2;  /*  2 is com2 for output  */
	         printf("SETTING COM2 BAUD RATE OF %ld, PARITY = %c, BITS %d, STOP %d\n",
	            baud,parity,bits,stopbits);
	         com2_init(baud,parity,bits,stopbits,4096,4000,100);
	         puts("SENDING RTCM SC-104 MESSAGES TO COM2 OUTPUT");
	      }
	   } else {  /*  see if can open a file  */
	      f2=fopen(argv[2],"wb");
	      if(f2==NULL) {puts("ERROR OPENING OUTPUT FILE");exit(1);}
	      else printf("WRITING RTCM SC-104 MESSAGES TO FILE %s\n",argv[2]);
	      outputstream=3;  /*  3 is file for output  */
	   }
	}
	if(outputstream==0 && inputstream==1) {  /* make com1 output also */
	   puts("SENDING RTCM SC-104 MESSAGES TO COM1 OUTPUT");
	   outputstream=1;  /*  1 is Com1 for output  */
	} 
	if(inputstream==2 && outputstream==0) {  /*  if 1st parm is a file, then we need output file name */
	   puts("MISSING OUTPUT FILE NAME");
	   exit(1);
	}
	if(inputstream==0) {  /*  no input specified  */
	   puts("NO INPUT SPECIFIED");
	   exit(1);
	}
/*
	look for debug flag -D in command line
*/
	mot8flag=0;debugflag=2;
	for(i=1;i<argc;++i) {
	   j=sscanf(argv[i],"-D%d",&k);
	   if(j==1) {
	      debugflag=k;
	      break;
	   }
	}
	ncharin=0;nwordsout=0;
	printf("SETTING DEBUG LEVEL TO %d\n",debugflag);
	puts("TYPE <ESC> TO EXIT PROGRAM");
	rtcmmsgcount=0;motmsgcount=0;
	state=0;msgptr=msgbufr;msgcnt=0;
	rtcmseq=0;
	parity30=0;
	parity29=0;
	oldmottime=0;
/*
	The main program loop starts here
*/
	while(1){
	   signed char a;
	   long b;
	   unsigned c;
	   int sf;
	   while(1) {
/*	   get the next char from the input  */
	      if(inputstream==2 && (i=fgetc(fp))==EOF) break;
	      if(inputstream==1 && (i=com1_get())==-1) break;
	      ++ncharin;
	      switch(state) {  /* state machine to parse the Mot Ce mess */
	         case 0:  /* the first 4 states look for the msg header */
	            msgptr=msgbufr;msgcnt=0;
	            if(i==msgstart[0]) {*msgptr++=i;msgcnt++;state=1;break;}
	            break;
	         case 1:
	            if(i==msgstart[1]) {*msgptr++=i;msgcnt++;state=2;break;}
	            state=0;break;
	         case 2:
	            if(i==msgstart[2]) {*msgptr++=i;msgcnt++;state=3;break;}
	            state=0;break;
	         case 3:
	            if(i==msgstart[3]) {*msgptr++=i;msgcnt++;state=4;break;}
	            state=0;break;
	         case 4:  /* main data loop, hang here for msglen bytes */
	            *msgptr++=i;
	            msgcnt++;
	            if(msgcnt < msglen) break;
/*
	We have the entire @@Ce message from the Oncore here in msgbufr
*/
	            state=0;
	            motmsgcount++;  /* bump msg count */
	            if(debugflag >= 3) {
	               printf("We have received message %c%c%c%c - ",
	                  msgbufr[0],msgbufr[1],msgbufr[2],msgbufr[3]);
	               for(i=2,j=0;i<msglen;++i) j ^= msgbufr[i];
	               if(j==0) puts("parity OK");
	               else puts("BAD parity");
	            }
/*	            get the GPS time stamp  */
	            a = msgbufr[4];b = a;b <<= 8;
	            b |= msgbufr[5];b <<= 8;b |= msgbufr[6];
/*	            we got 2 messages with the same time, switch to 8 chan mode */
	            if(b==oldmottime && mot8flag==0) {  /* msg has same time, ignor it */
	               mot8flag=1;
	               if(debugflag >= 3) {
	                  puts("Duplicate Ce message");
	                  puts("Switching to 8 channel mode");
	               }
	               break;
	            }
/*	            if we were waiting for 2nd mess, and it didn't come, go back
	            to 6 channel mode (expect only 1 @@Ce message)  */
		    msg1stflag=0;
	            if(b != oldmottime) {
	               if(msgsatcnt && mot8flag) {
	                  mot8flag=0;
	                  if(debugflag >= 3)
	                     puts("Switching to 6 channel mode");
	               }
	               msgsatcnt=0;msg1stflag=1;
	            }
	            oldmottime=b;
	            bintime=b;
	            if(debugflag >= 1) printf("GPS TIME IS %ld.%d\n",
	               (long)(bintime/10),(int)(bintime%10));
/*	            OK, now parse the 6 sat data slots in this message */
		    for(i=0,msgptr=msgbufr+7;msgptr<msgbufr+msglen-1 && msgsatcnt<SATMAX;++i,msgptr+=7) { /* go thru all the sat data */
	               if(*msgptr==0) continue; /* ignor sat zero */
	               msgsatid[msgsatcnt]=msgptr[0];  /* save sat id */
	               if(msgsatid[msgsatcnt]==32) msgsatid[msgsatcnt]=0;
	               a=msgptr[1];b=a;b<<=8;c=msgptr[2];b|=c;
	               b <<= 8;c=msgptr[3];b|=c;
	               msgprc[msgsatcnt]=b;  /*  save the PRC  */
	               a=msgptr[4];b=a;b<<=8;c=msgptr[5];b|=c;
	               msgprrc[msgsatcnt]=b;  /*  save the PRRC  */
	               c=msgptr[6];msgiode[msgsatcnt]=c;  /*  save the IODE  */
	               if(debugflag >= 1) { /* if debug, print sat data  */
	                  printf("SAT %2d   IODE %3d    ",
	                     msgsatid[msgsatcnt],msgiode[msgsatcnt]);
	                  if(msgprc[msgsatcnt] > 0 || msgprc[msgsatcnt]/100)
	                     printf("PRC %6ld.%02d M   ",
	                        (long)(msgprc[msgsatcnt]/100),abs((int)(msgprc[msgsatcnt]%100)));
	                  else
	                     printf("PRC     -0.%02d M   ",
	                        abs((int)(msgprc[msgsatcnt]%100)));
	                  if(msgprrc[msgsatcnt] > 0 || msgprrc[msgsatcnt]/1000)
	                     printf("PRRC %4ld.%03d M/Sec\n",
	                        (long)(msgprrc[msgsatcnt]/1000),abs((int)(msgprrc[msgsatcnt]%1000)));
	                  else
	                     printf("PRRC   -0.%03d M/Sec\n",
	                        abs((int)(msgprrc[msgsatcnt]%1000)));
	               }
	               msgsatcnt++;  /* bump the valid sat count  */
	            }
/*	            NOTE: if we didn't get any correction data from the Mot Ce
	               message, we just ignor it. We won't send an RTCM message
	               with no data. (word count of zero).   */
	            if(msgsatcnt==0) break; /* no sat data, ignor msg  */
	    /* If we are in 8 chan mode, don't RTCM till we get next @@Ce msg */
	            if(msg1stflag && mot8flag) break;
/*
	we have all the data, now convert it to RTCM
*/
		    if(debugflag >= 4)
		        puts("NOW ENCODING RTCM DATA STREAM");
	            bintime %= 36000;
	            if(debugflag >= 2)
	               printf("Bintime is %ld  ",bintime);
	            bintime /= 6;
	            rtcmzcount = bintime;
	            if(debugflag >= 2) {
	               printf("Z-Count is %ld\n",rtcmzcount);
	               printf("Outputing Data for %d Satellites\n\n",msgsatcnt);
	            }
	            rtcbits=0;
	            rtcword=0;
	            stuffbits( 8, 0x66);  /* header id */
	            stuffbits( 6, 1); /* msg type 1 */
	            stuffbits(10, 71);  /* station id */
	            /*  1st word should be sent here */
	            stuffbits(13, rtcmzcount); /* z-count */
	            stuffbits( 3, rtcmseq++); /* seq no. */
		    rtcmseq &= 0x7;  /* trim seqno to 3 bits */
/*	now compute the word count  */
	            i=msgsatcnt*40;  /* no of bits to send */
	            j=i/24;  /* no of RTCM words to send */
	            if(i%24) ++j;  /* bump, if not a full word */
	            stuffbits( 5, j); /* word length */
	            stuffbits( 3, 0); /* health bits */
/*      2nd header word should be sent now  */
/*      Main Data Loop, once thru for each satellite  */
	            for(i=0;i<msgsatcnt;++i) {
	               if(debugflag >= 4)
printf("OUTPUTING SATELLITE %d DATA\n",msgsatid[i]);
/*      We have to calculate the scale factor, first.
           Mot PRC is 24 bits, scaled by 0.01 .
           RTCM PRC is 16 bits, scaled by 0.02, or 0.32 if sf==1 .
           Mot PRRC is 16 bits, scaled by 0.001 .
           RTCM PRRC is 8 bits, scaled by 0.002, or 0.032 if sf==1 .
             1. divide PRC and PRRC by 2 to get base corrections  */
                       msgprc[i] /= 2; msgprrc[i] /= 2; sf=0;
/*           2. see if PRC > 16 bits, or PRRC > 8 bits, if so sf=1.  */
                       if(msgprc[i] > 32767 || msgprc[i] < -32768) sf=1; 
                       if(msgprrc[i] > 127 || msgprrc[i] < -128)  sf=1;
/*           3a. if sf==1, add 8 to both PRC and PRRC to round up */
/*           3b. if sf==1, then divide both PRC and PRRC by 16.  */
		       if(sf) {
		          msgprc[i] += 8; msgprrc[i] += 8;
		          msgprc[i] /= 16; msgprrc[i] /= 16;
		       }
	               stuffbits( 1, sf);  /* scale factor */
	               stuffbits( 2, 0);  /* UDRE */
	               stuffbits( 5, msgsatid[i]);  /* sat id no */
	               stuffbits( 8, msgprc[i]>>8);  /* prc hob */
/*     we split the prc into two 8-bit bytes, because an RTCM word
          boundary can occur here  */
	               stuffbits( 8, msgprc[i] & 0xff);  /* prc lob */
	               stuffbits( 8, msgprrc[i]);  /* prcc */
	               stuffbits( 8, msgiode[i]);  /* IODE */
	            }   /*  loop till all satellites done  */
	            /* if we have some bits left, flush word */
	            if(rtcbits)
	               for(i=(24-rtcbits)/8;i>0;--i)
	                  stuffbits( 8, 0xAA);  /* pad unused bits with 0xAA */
	            rtcmmsgcount++;  /* bump no. of RTCM type 1 msg sent */
	            if(outputstream==1) {com1_put(0x0d);com1_put(0x0a);}
	            if(outputstream==2) {com2_put(0x0d);com2_put(0x0a);}
	            if(outputstream==3) {fputc(0x0d,f2);fputc(0x0a,f2);}
	            msgsatcnt=0;  /* zero out no. of sat. to send  */
	      }  /* end of case, state machine */
/*	      check for <ESC> key hit from console  */
	      if(chkkey()) if(getkey()==0x1b) goto done;
	   }
	   if(chkkey()) {
	      i=getkey();
	      if(i==0x1b) break;
	   }
	   if(inputstream==2) break;
	}
done:	if(inputstream==2) fclose(fp);
	if(outputstream==3) fclose(f2);

	printf("\n******  %ld BYTES READ FROM MOTOROLA  *****",ncharin);
	printf("\n******  %ld MOTOROLA @@Ce MESSAGES RECEIVED  *****",motmsgcount);
	printf("\n******  %ld RTCM WORDS WRITTEN  *****",nwordsout);
	printf("\n******  %ld RTCM TYPE 1 MESSAGES WRITTEN  *****",rtcmmsgcount);
	if(inputstream==1)
	   printf("\n******  %ld  COMM ERRORS RECORDED *****",com1_rx_errcnt);

	return(0);
}

getkey()
{		/* direct keyboard input */
	int i;

	regs.h.ah=0;
	int86(0x16,&regs,&regs);
	regs.h.ah=0;
	i=regs.x.ax;
	return (i);
}

chkkey()
{		/* check for keyboard input */
	int i;
	union REGS regs;

	regs.h.ah=1;
	int86(0x16,&regs,&regs);
	if(regs.x.flags & 0x40) i=0; else i=1;
	return (i);
}

int stuffbits( int bits, unsigned long work) {
	int i,j,k;

	if(debugflag >=4)
	   printf("stuffbits - nbits = %2d  ,value = %04X\n",bits,(unsigned)work);
	work <<= 32-bits;  /* put bits at high end of word */
	for(k=0;k<bits;++k) {
	   rtcword  <<= 1;
	   if(work & 0x80000000L) rtcword |= 1;  /* put bit into lob  */
	   work <<= 1;
	   rtcbits++;  /* bump the output word bit count */
	}  /* done stuffing bits, see if need parity, send word */
	if(rtcbits < 24) return(0);  /* no, exit */
	if(debugflag >= 4)
	   puts("stuffbits - we have 24 bits to send");
	rtcword <<= 6;  /* move data into lower 30 bits of 32 bit word */
	if(debugflag >= 4)
	   printf("stuffbits (before parity) - %08lX\n",rtcword);
	i=doparity(rtcword);
	rtcword |= i;  /* put parity into lower 6 bits of 32 bit word */
	if(parity30) rtcword ^= 0x3fffffc0L;  /* invert bits, if needed */
	parity30 = rtcword & 1;  /* copy parity bits  */
	parity29 = 0;if(rtcword & 2) parity29 = 1;
	if(debugflag >= 4)
	   printf("stuffbits  (after parity) - %08lX\n",rtcword);
/*
	OK, at this point, we have the data bits, and the parity encoded
	and in the bottom 30 bits of the 32 bit RTCM word.
*/
	for(i=4;i>=0;--i) {
	   rtcbufr[i]=rtcword & 0x3f;  /* extract bottom 6 bits */
	if(debugflag >= 4)
	   printf(" stuffbits - EXTRACTING 6 BITs  %02X ",rtcbufr[i]);
	   rtcword >>= 6;  /* shift word by 6 bits */
	   rtcbufr[i]=flip[rtcbufr[i]];  /* flip the bit order */
	if(debugflag >= 4)
	   printf("  FLIPPED BITS  %02X ",rtcbufr[i]);
	   rtcbufr[i] |= 0x40;  /* or in "01" into the upper bits */
	if(debugflag >= 4)
	   printf("  ASCII'fied  %02X\n",rtcbufr[i]);
	}
	/*  we now the rtcm data complete in rtcbufr 0-4, send it  */
	nwordsout++;  /*  bump the RTCM word count  */
	if(debugflag >= 4) {
	   fputs("The RTCM output buffer is : ",stdout);
	   for(i=0;i<5;++i) fprintf(stdout,"%02X ",rtcbufr[i]);
	   fputs("    ",stdout);
	   for(i=0;i<5;++i) fprintf(stdout,"%c",rtcbufr[i]);
	   fputs("\n",stdout);
	}
	if(outputstream==1)  /*  do COM1 output  */
	      for(i=0;i<5;++i) com1_put(rtcbufr[i]);
	if(outputstream==2)  /*  do COM2 output  */
	      for(i=0;i<5;++i)  com2_put(rtcbufr[i]);
	if(outputstream==3)  /*  do file output here  */
	   for(i=0;i<5;++i) fputc(rtcbufr[i],f2);
	rtcword=0;rtcbits=0;
	return(1);
}

int doparity(unsigned long word) {
	int d25,d26,d27,d28,d29,d30;
	int parity;

	d25=d26=d27=d28=d29=d30=0;
	d25= parity29 ^ getbit(word,0) ^ getbit(word,1) ^ getbit(word,2) ^
	     getbit(word,4) ^ getbit(word,5) ^ getbit(word,9) ^ getbit(word,10) ^
	     getbit(word,11) ^ getbit(word,12) ^ getbit(word,13) ^ getbit(word,16) ^
	     getbit(word,17) ^ getbit(word,19) ^ getbit(word,22);
	d26= parity30 ^ getbit(word,1) ^ getbit(word,2) ^ getbit(word,3) ^
	     getbit(word,5) ^ getbit(word,6) ^ getbit(word,10) ^ getbit(word,11) ^
	     getbit(word,12) ^ getbit(word,13) ^ getbit(word,14) ^ getbit(word,17) ^
	     getbit(word,18) ^ getbit(word,20) ^ getbit(word,23);
	d27= parity29 ^ getbit(word,0) ^ getbit(word,2) ^ getbit(word,3) ^
	     getbit(word,4) ^ getbit(word,6) ^ getbit(word,7) ^ getbit(word,11) ^
	     getbit(word,12) ^ getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^
	     getbit(word,18) ^ getbit(word,19) ^ getbit(word,21);
	d28= parity30 ^ getbit(word,1) ^ getbit(word,3) ^ getbit(word,4) ^
	     getbit(word,5) ^ getbit(word,7) ^ getbit(word,8) ^ getbit(word,12) ^
	     getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^ getbit(word,16) ^
	     getbit(word,19) ^ getbit(word,20) ^ getbit(word,22);
	d29= parity30 ^ getbit(word,0) ^ getbit(word,2) ^ getbit(word,4) ^
	     getbit(word,5) ^ getbit(word,6) ^ getbit(word,8) ^ getbit(word,9) ^
	     getbit(word,13) ^ getbit(word,14) ^ getbit(word,15) ^ getbit(word,16) ^
	     getbit(word,17) ^ getbit(word,20) ^ getbit(word,21) ^ getbit(word,23);
	d30= parity29 ^ getbit(word,2) ^ getbit(word,4) ^ getbit(word,5) ^
	     getbit(word,7) ^ getbit(word,8) ^ getbit(word,9) ^ getbit(word,10) ^
	     getbit(word,12) ^ getbit(word,14) ^ getbit(word,18) ^ getbit(word,21) ^
	     getbit(word,22) ^ getbit(word,23);
	parity=(((((((((d25<<1)+d26)<<1)+d27)<<1)+d28)<<1)+d29)<<1)+d30;
	if(debugflag >= 5)
	   printf("doparity - CALC PARITY IS %02X\n",parity);
	return(parity);
}

getbit(unsigned long word,int bit) {
	int i;
	i = (word>>(29-bit)) & 1;
	return(i);
}
