/*
	SERIALX.H - header file for COMX (GENERIC COM ADAPTER)
	buffered input routines.(interrupt driven)
	ver 2.0 10-18-95  allow init more than once
	ver 2.1 05-01-96  allow exit more than once
	ver 2.2 10-02-96  allows bad chars to be received
	ver 2.3  9-13-99  added TX status call that returns free bufr size.
	ver 2.4  9-15-99  mod RX bufr overflow to keep last char, BEEP en/dis
	ver 2.5  9-16-99  enabled FIFO operation of 16550
	ver 2.6  9-27-99  verified presence of UART during intialization.
*/
/*
   define BEEP, if you want the routine to beep on RX bufr overflow
*/
/*
#define BEEP
*/
#include <dos.h>
#include <stdlib.h>
#include <string.h>

#ifdef output
#undef output
#undef input
#endif

#define output(x,y) outportb((x),(y))
#define input(x)    inportb((x))

#ifdef BASE
#undef COMX
#undef BASE
#undef VECT
#undef MASKOR
#undef MASKAND
#endif

#ifdef  COM1
#define COMX(i) com1_##i
#define BASE 0x3f8
#define VECT 0x0C
#define MASKOR 0x10
#define MASKAND 0xEF
#undef  COM1
#endif

#ifdef  COM2
#define COMX(i) com2_##i
#define BASE 0x2f8
#define VECT 0x0B
#define MASKOR 0x08
#define MASKAND 0xF7
#undef  COM2
#endif

#ifdef  COM3
#define COMX(i) com3_##i
#define BASE 0x3E8
#define VECT 0x0C
#define MASKOR 0x10
#define MASKAND 0xEF
#undef  COM3
#endif

#ifdef  COM4
#define COMX(i) com4_##i
#define BASE 0x2E8
#define VECT 0x0B
#define MASKOR 0x08
#define MASKAND 0xF7
#undef  COM4
#endif

#ifndef BASE
#error THE COM PORT MUST BE DEFINED AS "#define COM1" BEFORE #include "cx.h" STATEMENT.
#endif

int COMX(rxtx_buf_len),COMX(rx_hi_water),COMX(rx_lo_water),COMX(rx_flg);
long COMX(rx_errcnt);
#ifdef CPLUS
void interrupt (*COMX(old))(...);
#else
void interrupt (*COMX(old))();
#endif
unsigned char *COMX(rx_buf),*COMX(rx_in_ptr),*COMX(rx_out_ptr),*COMX(rx_buf_end);
unsigned char *COMX(tx_buf),*COMX(tx_in_ptr),*COMX(tx_out_ptr),*COMX(tx_buf_end);

#ifndef COMBREAK
int c_break(void) {
	exit(1);
	return(0);
}
#define COMBREAK 1
#endif

#ifdef CPLUS
void interrupt COMX(new)(...) {
#else
void interrupt COMX(new)() {
#endif
	unsigned char *ptr;
	int i;
	while(1) {
	  i=input(BASE+2);
	  if(i & 1) break;
	  i=((i>>1) & 3);
	  if(i==3) {  /* process line status int */
	    i=inportb(BASE+5);  /* read uart error status bits */
#ifdef FLAGERRS
	    COMX(rx_flg)=(i & 0x1e);  /* set error flag */
#endif
	    COMX(rx_errcnt)++;  /* bump no. of com errors */
	    continue;
	  }
	  if(i==0) { /* process modem status reg int */
	    i=inportb(BASE+6);  /* read line change status  */
	    continue;
	  }
	  if(i==2) {  /* process rx data interrupt */
	    ptr=COMX(rx_in_ptr);
	    *ptr++ = inportb(BASE);
	    if(ptr >= COMX(rx_buf_end)) ptr=COMX(rx_buf);
	    if(ptr == COMX(rx_out_ptr)) {      /* bufr overflow */
	      COMX(rx_out_ptr)++;COMX(rx_in_ptr)++; /* advance both pntrs */
	      if(COMX(rx_out_ptr) >= COMX(rx_buf_end)) /* this "eats" oldest */
	        COMX(rx_out_ptr)=COMX(rx_buf); /* char in the input buffer */
	      if(COMX(rx_in_ptr) >= COMX(rx_buf_end)) /* but we have to check */
	        COMX(rx_in_ptr)=COMX(rx_buf); /* both ptrs for foldover */
#ifdef BEEP
	      i=inportb(0x61);
	      if((i & 3) == 3) continue;      /* if beeper on, exit */
	      outportb(0x43,0xb6);goto b1;
b1:	      outportb(0x42,0x33);goto b2;  /* buffer overflow, turn on the beeper */
b2:	      outportb(0x42,0x05);goto b3;
b3:	      outportb(0x61,i | 3);
#endif
	      continue;
	    }
	    COMX(rx_in_ptr)=ptr;
	    if(COMX(rx_in_ptr) < COMX(rx_out_ptr))
	      i=(COMX(rx_in_ptr)+COMX(rxtx_buf_len))-COMX(rx_out_ptr);
	    else
	      i=COMX(rx_in_ptr)-COMX(rx_out_ptr);
	    if(i >= COMX(rx_hi_water)) {
	      i=inportb(BASE+4);goto p2;    /* within 20 bytes of buf size */
p2:	      outportb(BASE+4,i & 0xfe);  /* turn off DTR to sending device */
	    }
	    continue;
	  }
	  if(i == 1) {  /* process tx holding reg empty interrupt  */
	    ptr=COMX(tx_in_ptr);
	    if(COMX(tx_out_ptr)==ptr) { /* nothing to send, turn off int */
	      i=inportb(BASE+1);goto t1;
t1:	      outportb(BASE+1,i & 0xfd); /* disable tx mask bit */
	      continue;
	    }
	    i=*COMX(tx_out_ptr)++;
	    if(COMX(tx_out_ptr) >= COMX(tx_buf_end)) COMX(tx_out_ptr)=COMX(tx_buf);
	    outportb(BASE,i);  /* send the char out to the serial port */
	    continue;
	  }
	  break; /* none of the above int, done with 8250 */
	}
/*	(COMX(old))(); */  /* call old int routine */
	outportb(0x20,0x20);  /* send EOI to 8259  */
	return;
}

atexit_t COMX(exit)(void) {
	input(BASE);input(BASE);input(BASE); /* dummy reads */
	if(COMX(old) != NULL) {
	   disable();
	   setvect(VECT,COMX(old));  /* go back to old vector */
	   output(0x21,input(0x21) | MASKOR); /* disable mask bit on 8259 */
	   output(BASE+1,0);  /* disable mask bits on 8250 */
	   output(0x61,input(0x61) & 0xfc); /* turn off beeper */
	   free(COMX(rx_buf));
	   free(COMX(tx_buf));
	   COMX(old)=NULL;
	}
	enable();
	return 0;
}

void COMX(init)(long baud,int parity,int bits,int stop,int buflen,int high,int low) {
	int div,i,j;
	static int first=1;  /* keeps track of 1st call */

/*	VERIFY THAT WE HAVE A UART AT THIS ADDRESS  */
	div=input(BASE+3);  /* test the lower 4 bits of the IER reg */
	output(BASE+3,div & 0x7F);  /* normal operation */
	output(BASE+1,0xff); /* set bits in IER */
	i=input(BASE+1); /* get the new IER */
	if(i!=0x0F) {  /* check the bottom 4 bits */
	   printf("\nCOMXINIT: NO UART FOUND AT ADDRESS %3X (IER TEST)\n",BASE);
	   exit(1);
	}
	output(BASE+3,div | 0x80);  /* access the baud rate register */
	output(BASE,0x55);output(BASE+1,0xAA);  /* write 2 bytes */
	i=input(BASE);j=input(BASE+1); /* try to read them back */
	output(BASE+3,div & 0x7F);  /* normal operation */
	if((i!=0x55) || (j!=0xAA)) {  /* check both bytes */
	   printf("\nCOMXINIT: NO UART FOUND AT ADDRESS %3X (BAUD RATE REG TEST)\n",BASE);
	   exit(1);
	}

/*	SET THE BAUD RATE FOR THE 8250 UART  */
	div=115200L/baud;
	if(first)
	   if(115200L/div-baud > baud/100)
	     printf("\nCOMXINIT: warning - requested baud rate = %ld  actual baud rate = %ld\n",
	       baud,115200L/div);
	output(BASE+3,0x80);output(BASE,div & 0xff);output(BASE+1,div >> 8);

/*	SET THE DATA WORD PARAMETERS: PARITY, DATA BITS, STOP BITS  */
	i=0;
	if(parity=='O' || parity=='o') i |= 0x08;
	else if(parity=='E' || parity=='e') i |= 0x18;
	else if(parity!='N' && parity!='n')
	   puts("\nCOMXINIT: warning - parity set to 'N'");

	switch(bits) {
	  case 5:  break;
	  case 6:  i |= 0x01;break;
	  case 7:  i |= 0x02;break;
	  case 8:  i |= 0x03;break;
	  default: i |= 0x03;puts("\nCOMXINIT: warning - bits set to 8");break;
	}
	if(stop == 2) i |= 0x04;
	else if(stop != 1) puts("\nCOMXINIT: warning - stop bits set to 1");
	output(BASE+3,i);

/*	SETUP THE COM BUFFERS: SIZE, LOW AND HIGH INDICATORS  */
	if(first) {  /* can't change buffer size after first call */
	   if(buflen > 16384) buflen=16384;
	   if(buflen < 64) buflen=64;
	   COMX(rxtx_buf_len)=buflen;
	}
	if(high <= 0 || high >= COMX(rxtx_buf_len)) high = COMX(rxtx_buf_len)*8/10;
	if(low <= 0 || low >= high) low=COMX(rxtx_buf_len)*2/10;

/*	RECEIVE COM BUFFER SETUP FIRST  */
	COMX(rx_lo_water)=low;
	COMX(rx_hi_water)=high;
	if(first) {
	   COMX(rx_buf) = (unsigned char *)malloc(COMX(rxtx_buf_len));
	   if(COMX(rx_buf)==NULL) {
	     fputs("\nCOMXINIT: RX BUFR MEM ALLOC ERROR",stdout);exit(1);}
	}
	COMX(rx_buf_end)=COMX(rx_buf)+COMX(rxtx_buf_len);
	COMX(rx_out_ptr)=COMX(rx_in_ptr)=COMX(rx_buf);
	COMX(rx_flg)=0;

/*	TRANSMIT COM BUFFER SETUP NEXT  */
	if(first) {
	   COMX(tx_buf) = (unsigned char *)malloc(COMX(rxtx_buf_len));
	   if(COMX(tx_buf)==NULL) {
	     fputs("\nCOMXINIT: TX BUFR MEM ALLOC ERROR",stdout);exit(1);}
	}
	COMX(tx_buf_end)=COMX(tx_buf)+COMX(rxtx_buf_len);
	COMX(tx_out_ptr)=COMX(tx_in_ptr)=COMX(tx_buf);

/*	SWAP INTERRUPT ENTRY POINTS, ENABLE RX INT, MASK 8259   */
	if(first) {
	   COMX(old)=getvect(VECT);  /* hardware COMX int vector */
	   setvect(VECT,COMX(new));
	}  else {
	   if(getvect(VECT) != COMX(new))    /* get hardware int vector */
	      setvect(VECT,COMX(new));       /* if not ours, replace it */
	}
	input(BASE);input(BASE);input(BASE); /* dummy reads */
	output(BASE+1,input(BASE+1) | 0x0d);  /* int enable RX, modem, errors on 8250 */
	output(BASE+4,input(BASE+4) | 0x0b); /* DTR(D0), RTS(D1), EN int(D3) */
	output(0x21,input(0x21) & MASKAND); /* enable mask bit on 8259 */
	if(first) {
	   if(atexit((atexit_t)COMX(exit))) {
	     fputs("\nCOMXINIT: atexit FAILED",stdout);
	     COMX(exit)();exit(1);
	   }
	   output(BASE+2,0x07);  /* try to enable 16550 FIFO */
	   if(input(BASE+2) & 0xc0) {  /* we have a FIFO */
	     if((input(BASE+2) & 0xc0) == 0xc0) {
	       printf("COMXINIT: 16550 UART FIFO ENABLED AT ADDRESS %3X\n",BASE);
	     } else output(BASE+2,0); /* disable bad FIFO part */
	   }
	}
	first=0;
	return;
}

void COMX(flush_rx)(void) {
	disable();
	COMX(rx_in_ptr)=COMX(rx_out_ptr)=COMX(rx_buf);
	enable();
	return;
}

void COMX(flush_tx)(void) {
	int i;
	disable();
	COMX(tx_in_ptr)=COMX(tx_out_ptr)=COMX(tx_buf);
	i=inportb(BASE+1);
	outportb(BASE+1,i & 0xfd); /* disable tx mask bit */
	enable();
	return;
}

int COMX(get)() {
	unsigned i;char *in_ptr;
	in_ptr=COMX(rx_in_ptr);
	if(in_ptr == COMX(rx_out_ptr)) return(-1); /* no char avail */
	if(COMX(rx_flg)) {COMX(rx_flg)=0;return(-2);} /* flag recv data error */
	output(0x61,input(0x61) & 0xfc); /* turn off beeper */
	if((input(BASE+4) & 1) == 0) {  /* see if we have to turn on DTR  */
	  if(in_ptr < COMX(rx_out_ptr))
	    i=(in_ptr+COMX(rxtx_buf_len))-COMX(rx_out_ptr);
	  else
	    i=in_ptr-COMX(rx_out_ptr);
	  if(i <= COMX(rx_lo_water))
	    output(BASE+4,input(BASE+4) | 1);  /* turn on DTR to sending device */
	}
	i=*COMX(rx_out_ptr)++;
	if(COMX(rx_out_ptr) >= COMX(rx_buf_end)) COMX(rx_out_ptr)=COMX(rx_buf);
	return(i);
}

int COMX(put)(int a) {
	unsigned i;char *ptr;
	ptr=COMX(tx_in_ptr)+1;
	if(ptr >= COMX(tx_buf_end)) ptr=COMX(tx_buf);
	if(ptr == COMX(tx_out_ptr)) return(-1); /* if no space in buf, ret -1 */
	*COMX(tx_in_ptr) = a;  /* put char into buf */
	COMX(tx_in_ptr)=ptr; /* update buf ptr */
	i=input(BASE+1);
	if((i & 2) == 0) output(BASE+1,i | 2); /* enable tx reg empty int */
	return(0);
}

int COMX(getbufr)(char *ptr) {
	unsigned i,j;char *in_ptr;
	in_ptr=COMX(rx_in_ptr);  /* make local static copy of input ptr */
	if(in_ptr == COMX(rx_out_ptr)) return(0); /* no char avail */
	if(in_ptr > COMX(rx_out_ptr)) {
	  i=in_ptr-COMX(rx_out_ptr); /* get no. of bytes in buf */
	  if(ptr != NULL) memcpy(ptr,COMX(rx_out_ptr),i); /* move buf to user area */
	} else {  /* more complex, wraps to buf end  */
	  i=COMX(rx_buf_end)-COMX(rx_out_ptr);
	  if(ptr != NULL) memcpy(ptr,COMX(rx_out_ptr),i);
	  ptr+=i;j=i;
	  i=in_ptr-COMX(rx_buf);
	  if(ptr != NULL) memcpy(ptr,COMX(rx_buf),i);
	  i+=j;
	}
	if((input(BASE+4) & 1) == 0) {  /* see if we have to turn on DTR  */
	  if(in_ptr < COMX(rx_out_ptr))
	    j=(in_ptr+COMX(rxtx_buf_len))-COMX(rx_out_ptr);
	  else
	    j=in_ptr-COMX(rx_out_ptr);
	  if(j <= COMX(rx_lo_water))
	    output(BASE+4,input(BASE+4) | 1);  /* turn on DTR to sending device */
	}
	output(0x61,input(0x61) & 0xfc); /* turn off beeper */
	if(ptr != NULL) COMX(rx_out_ptr)=in_ptr;  /* make out ptr == in ptr  */
	return(i);
}

int COMX(putbufr)(char *bptr,unsigned n) {
	unsigned i,j;char *outptr,*inptr;

	if(bptr==NULL) {  /* pntr == NULL, status call, return bufr free space */
	   disable();
	   outptr=COMX(tx_out_ptr);  /* make local static copy of output ptr */
	   inptr=COMX(tx_in_ptr);
	   if(inptr>=outptr) i=(COMX(tx_buf_end)-COMX(tx_buf))-(inptr-outptr);
	   else i=outptr-inptr;
	   if(i>2) i-=2; else i=0;  /* give a couple char overhead */
	   enable();
	   return(i);
	}

	if(n==0) {  /* buffer size == 0, status call, return no. of char still in bufr */
	   disable();
	   outptr=COMX(tx_out_ptr);  /* make local static copy of output ptr */
	   inptr=COMX(tx_in_ptr);
	   if(inptr<outptr) i=(inptr-outptr)+(COMX(tx_buf_end)-COMX(tx_buf));
	   else i=inptr-outptr;
	   if(i==0) { /* the bufr is empty, check the TX bufr reg in the UART */
	      j=input(BASE+1);  /* return zero only when last char sent */
	      if((j & 2) != 0) i=1;  /* this prevents program from exiting */
	   }       /* before all the char are physically sent by the UART */
	   enable();
	   return(i);
	}
/*
	for(i=0;i<n;++i,++bptr) {
	  j=COMX(put)(*bptr);
	  if(j==-1) break;
	}
	return(i);
*/
	outptr=COMX(tx_out_ptr);  /* make local static copy of output ptr */
	inptr=COMX(tx_in_ptr);
	if(inptr >= outptr) i=-(inptr-outptr)+(COMX(tx_buf_end)-COMX(tx_buf))-1;
	   else i=outptr-inptr-1;  /* i is space left in bufr */
	if(i==0) return(0); /* no space left */
	if(n > i) n=i;  /* if n is larger than space, make it equal */
	i=0;
	while(n) {  /* at this point, we know we have space for n char in TX bufr */
	  inptr=COMX(tx_in_ptr)+1;
	  if(inptr >= COMX(tx_buf_end)) inptr=COMX(tx_buf);
	  if(inptr == outptr) break; /* no space exit */
	  if(COMX(tx_in_ptr) > outptr)
	    j=COMX(tx_buf_end)-COMX(tx_in_ptr); /* get free space to buf end */
	  if(COMX(tx_in_ptr) < outptr)
	    j=outptr-COMX(tx_in_ptr);
	  if(COMX(tx_in_ptr) == outptr)
	    j=COMX(tx_buf_end)-COMX(tx_in_ptr); /* get free space to buf end */
	  if(j >= COMX(tx_buf_end) - COMX(tx_buf) ) j = COMX(tx_buf_end) - COMX(tx_buf) -1;
	  if(j > n) j=n;
	  if(j==0) break;
	  memcpy(COMX(tx_in_ptr),bptr,j); /* move buf to tx area */
	  COMX(tx_in_ptr) += j;  /* bump in ptr */
	  if(COMX(tx_in_ptr) >= COMX(tx_buf_end))
	    COMX(tx_in_ptr)=COMX(tx_buf);
	  n-=j;i+=j;bptr+=j;
	}
	j=input(BASE+1);
	if((j & 2) == 0) output(BASE+1,j | 2); /* enable tx reg empty int */
	return(i);
}
