DECLARE SUB sort (lx() AS LONG, maxrow AS INTEGER)
DECLARE FUNCTION dircos! (i&, j&)
DECLARE SUB setup (kmap%)
DECLARE SUB achain (lindx&(), datf AS STRING, nseg%, npts%)
DECLARE SUB fltest (good%)
DECLARE SUB fsel (path AS STRING, nf AS INTEGER)
DECLARE SUB utm (x#, y#, utmz!)
DECLARE SUB init (mapf AS STRING, datf AS STRING, path AS STRING, nf AS INTEGER)
DECLARE SUB fbook (finx%, F AS STRING, path AS STRING, bcolor%, suffix AS STRING)
DECLARE SUB Test (rcno&, rstop&, ratt&, ncoor%, nlatt%, testflg%, icolor%, lab AS STRING)
'Code to make APRS maps from USGS 100k:1 dlg CD optional data
' Version 4.0  31 Jan 99 - KB4XF - Improved chaining
' Written by originally by Jack Cavanagh, KB4XF in 1995
' Unlimited license granted to amateur radio operators
' Author waives all copyright and dedicates to the public domain.
' Author waives all responsibility too!
DEFSTR A-Z
COMMON SHARED lat0!, long0!, ymax!, xmax!, scfy!, scfx!, rds%, mradm!, rcln%
COMMON SHARED lfac!, ppdy!, mpernm!, latmax!, longmin!, Hfac!, drady!, dradx!
COMMON SHARED ymin!, xmin!, yy0#, xx0#, utmz!, sr!, cr!, dir() AS STRING * 35
COMMON SHARED xlat!(), xlon!(), ftag() AS STRING * 2, nmaps%, mapf, mapfb
COMMON SHARED datf, datfb, sfac!, tlv%, tfl, dtl$
DIM u#(3), v#(3), lindx&(8192)
DIM xs(1200) AS INTEGER, ys(1200) AS INTEGER
' $DYNAMIC
DIM SHARED tindx&(8192), hd(8192, 2) AS INTEGER, tl(8192, 2) AS INTEGER
ON ERROR GOTO punt
CLEAR , , 2000    'Too many nested routines error msg otherwise
CONST limit% = 3000 'APRS map size limit
CONST pi! = 3.14159
fmt = "\          \   ###   ###.####  ####.#### ######/##### ####/####"
ON KEY(10) GOSUB punt:
KEY(10) ON
REDIM ftag(676) AS STRING * 2   'v3
DATA "nw","nn","ne","ww","cc","ee","sw","ss","se"
FOR i% = 1 TO 9: READ ftag(i%): NEXT
IF COMMAND$ = "" THEN
   tfl = "tmap.raw"
ELSE
   spcptr% = INSTR(COMMAND$, " ")
   IF spcptr% = 0 THEN
      dltr = COMMAND$
   ELSE
      dltr = LEFT$(COMMAND$, spcptr% - 1)
   END IF
   tfl = dltr + "tmap.raw"
END IF
'Define radom access file records using field statements
'Copy to clipboard as required
'General text record types 1,2,3
'field 1, 80 as banner
'Type 4 record
'field1,6 as dlg,6 as code,6 as gprs,6 as gprc,18 as res,6 as ntrfp,6 as nacr,
'6 as ncp,6 as ncat,6 as fill1
'Type 5-9 record
'field1, 24 as p1,24 as p2,24 as p3,8 as fill2
'Control point records - ncp
'field 1,6 as quad,12 as rflat,12 as rflong,18 as refx,12 as refy,20 as fill3
'Category id records- ncat
'field 1, 24 as cname,6 as rnodes,6 as nnodes,2 as linkf,2 as naf,6 as rarea,6 as narea,
'4 as mflg,6 as rlines,6 as nlines,12 as fill4
'Node and area id records
'field 1,1 as rtype,5 as idnum,12 as ptxc,12 as ptcy,t as nlist,, 6 as nlines,6 as npairs,
'6 as nattc,6 as ntxtc,6 as nisld,14 as fill5
'Line id records
'field 1,1 as ltype,5 as lnum,6 as stnode,6 as ednode,6 as larea,6 as rarea,
'18 as ncoor,6 as nlatt,26 as fill6
'Line data records- ncoor/3
'Field 1, 12 as u1,12 as v1,12 as u2,12 as v2,12 as u3,12 as v3
'Attribute code records nlatt/6
'field 1, 6 as cmj1,6 as cmn1,6 as cmj2,6 as cmn2,6 as cmj3, 6 as cmn3
CALL init(mapf, datf, path, nf%)
t00! = TIMER  'Seconds since midnight
climit% = 0
big% = 0
kmap% = 1
DO WHILE kmap% <= nmaps% 'loop0 for multiple maps
CLS
CALL setup(kmap%)
npts% = 8
finx% = 1
nseg% = 0
oldx! = 99999
oldy! = 99999
tstart! = TIMER
DO WHILE finx% <= nf% 'loop1  over files
DO  'loop2
 F = LEFT$(dir(finx%), 12)
 OPEN path + "\" + F FOR RANDOM AS #1 LEN = rcln%
 CALL fltest(good%)
 IF NOT good% THEN
   finx% = finx% + 1
   CLOSE 1
 END IF
LOOP UNTIL good% OR finx% > nf% 'loop2  over good files
IF NOT good% THEN EXIT DO
FIELD 1, 24 AS cname, 6 AS rnodes, 6 AS nnodes, 2 AS linkf, 2 AS naf, 6 AS rarea, 6 AS narea, 4 AS mflg, 6 AS rlines, 6 AS nlines, 12 AS fill4
FIELD 1, 6 AS cmj1, 6 AS cmn1, 6 AS cmj2, 6 AS cmn2, 6 AS cmj3, 6 AS cmn3
FIELD 1, 1 AS ltype, 5 AS lnum, 6 AS stnode, 6 AS ednode, 6 AS larea, 6 AS rarea, 18 AS ncoor, 6 AS nlatt, 26 AS fill6
labnr% = 0
rcno& = 15
' Read header lines of CD. Extract number of area and line records.
' Estimate number of physical records and skip ahead.  Someday I may
' make use of this skipped info. Search one physical record at a time
' until an "L" found in first byte. Then test to see if this line
'segment is in region of interest. If so then extract data pairs. If
'not then skip to next logical line record.
GET 1, rcno&
rcno& = rcno& + 2 * (VAL(nnodes) + VAL(narea)) 'Approx skip of node and area info
rmax& = LOF(1) / rcln%  'QB does not recognize CD eof!  82 or 80 bytes per record
maxl% = VAL(nlines)
LOCATE 1, 1
PRINT "Searching file "; F; "map "; mapf;  'v3
DO WHILE NOT EOF(1) AND rcno& < rmax& 'loop3 over lines in file
DO 'loop4
GET 1, rcno&
rcno& = rcno& + 1
LOOP UNTIL ltype = "L" OR rcno& > rmax&  'loop4  finding start of line data
LOCATE 1, 42
PRINT ltype; lnum; maxl%; nseg%;   'v4
startflg% = -1
k% = 0
lnum% = VAL(lnum)
ncoor% = VAL(ncoor)
nlatt% = VAL(nlatt)
nphrec% = ncoor% \ 3
'IF lnum% > 350 AND LEFT$(F, 8) = "IR4RDF05" THEN STOP
IF (ncoor% MOD 3) <> 0 THEN nphrec% = nphrec% + 1
rstop& = rcno& + nphrec%
IF nlatt% = 0 THEN rstop& = rstop& - 1
IF nlatt% > 6 THEN rstop& = rstop& + 1
ratt& = rstop&  'Normally
FIELD 1, 12 AS u1, 12 AS v1, 12 AS u2, 12 AS v2, 12 AS u3, 12 AS v3
IF nlatt% <> 0 THEN 'Line with no attribute it is neat line or of no interest
  CALL Test(rcno&, rstop&, ratt&, ncoor%, nlatt%, testflg%, icolor%, lab)
ELSE
   testflg% = 0
END IF
rstop& = rcno& + nphrec% 'Redefine so attributes not examined as coordinates
IF testflg% THEN          'nf1  while have a good line
 xprev! = 999!'Catch point just off map
 DO WHILE rcno& < rstop&   'loop5   over line data points
 GET 1, rcno&
 u#(1) = VAL(u1)
 v#(1) = VAL(v1)
 u#(2) = VAL(u2)
 v#(2) = VAL(v2)
 u#(3) = VAL(u3)
 v#(3) = VAL(v3)
 FOR i% = 1 TO 3
 IF u#(i%) = 0 THEN EXIT FOR
 xt! = u#(i%) - xx0# 'meters
 yt! = v#(i%) - yy0# 'meters
 REM Rotate to align with lat/long
 x! = xt! * cr! + yt! * sr!
 y! = yt! * cr! - xt! * sr!
 REM Test to see if this point is on map
 ok% = 0
 IF (y! <= ymax!) AND (y! >= ymin!) THEN
   IF (x! <= xmax!) AND (x! >= xmin!) THEN
      ok% = -1
   END IF
 ELSE
   xprev! = x!
   yprev! = y!
 END IF
 IF ok% THEN           'nf2  while we have good point
      dx! = (x! - xmin!) 'meters
      xlng! = dx! * scfx! 'deg long
      xp! = INT(xlng! * ppdy! + .5)
      dy! = (ymax! - y!)
      ylat! = dy! * scfy! 'deg lat
      yp! = INT(ylat! * ppdy! + .5)
     IF startflg% THEN   'Set up a new line segment in map nf3
      IF xprev! <> 999! THEN
       xpt! = xp!
       ypt! = yp!
       x! = xprev!
       y! = yprev!
       dx! = (x! - xmin!) 'meters
       xlng! = dx! * scfx! 'deg long
       xp! = INT(xlng! * ppdy! + .5)
       dy! = (ymax! - y!)
       ylat! = dy! * scfy! 'deg lat
       yp! = INT(ylat! * ppdy! + .5)
      END IF
       PSET (xp! * Hfac! * sfac!, yp! * sfac!), icolor%
       'PRINT #2, "   0,   0"
       labnr% = labnr% + 1  'Use route nr if available else incr ctr.
       labs = RIGHT$(STR$(labnr%), 3)
       ll = LEFT$(lab, 2)
       tag = lab
       IF ll = "st" THEN tag = ll + labs
       IF ll = "rd" THEN tag = ll + labs
       k% = 1
       xs(k%) = xp!
       IF xs(k%) = 0 THEN xs(k%) = 1
       ys(k%) = yp!
       startflg% = 0
      IF xprev! <> 999! THEN
       LINE -(xpt! * Hfac! * sfac!, ypt! * sfac!), icolor%
       k% = k% + 1
       xs%(k%) = xpt!
       IF xs(k%) = 0 THEN xs(k%) = 1
       ys%(k%) = ypt!
       xprev! = 999!
      END IF
     ELSE  'Just plot next point
      LINE -(xp! * Hfac! * sfac!, yp! * sfac!), icolor%
      k% = k% + 1
      xs%(k%) = xp!
      IF xs(k%) = 0 THEN xs(k%) = 1
      ys%(k%) = yp!
    END IF 'plot point                                     nf3
  ELSE
    IF NOT startflg% THEN 'finish current line off edge of screen
      dx! = (x! - xmin!) 'meters
      xlng! = dx! * scfx! 'deg long
      xp! = INT(xlng! * ppdy! + .5)
      dy! = (ymax! - y!)
      ylat! = dy! * scfy! 'deg lat
      yp! = INT(ylat! * ppdy! + .5)
      LINE -(xp! * Hfac! * sfac!, yp! * sfac!), icolor%
      k% = k% + 1
      xs%(k%) = xp!
      IF xs(k%) = 0 THEN xs(k%) = 1
      ys%(k%) = yp!
      EXIT FOR
   END IF
    startflg% = -1
 END IF 'plot good point  on map                           nf2
 NEXT i%  'plot next point in record
 rcno& = rcno& + 1
 LOOP 'plot line loop5
  ' Now write to disk in ascending order by y-coordinate
  IF k% > 1 THEN  'Only lines with more than one point
  PRINT #2, "   0,   0"
  PRINT #2, USING "##_,\    \"; icolor%; tag
  npts% = npts% + 2
  nseg% = nseg% + 1
  lindx&(nseg%) = npts% - 1 'Save the ptr to this line for chaining later
  kstop% = k%
  IF ys%(1) < ys%(kstop%) THEN
   k1% = 1
   k2% = kstop%
   kstep% = 1
   IF ll = "st" THEN kstep% = 2
  ELSEIF (ys%(1) = ys%(kstop%)) AND xs%(1) < xs%(kstop%) THEN
   k1% = 1
   k2% = kstop%
   kstep% = 1
   IF ll = "st" THEN kstep% = 2
  ELSE
   k1% = kstop%
   k2% = 1
   kstep% = -1
   IF ll = "st" THEN kstep% = -2
 END IF
 FOR k% = k1% TO (k2% - SGN(kstep%)) STEP kstep%
 PRINT #2, USING "####_,####"; xs(k%); ys(k%)
 npts% = npts% + 1
 NEXT k%
 PRINT #2, USING "####_,####"; xs(k2%); ys(k2%)  'alway last pt
 npts% = npts% + 1
END IF
 startflg% = -1
ELSE
 rcno& = rstop& + 1
END IF 'plot good line                                   nf1
LOOP 'loop over all lines loop3
tstop! = TIMER
PRINT
LOCATE 2, 1
PRINT INT(tstop! - tstart! + .5); " sec"
finx% = finx% + 1
cmaxrec& = LOF(2) \ 11
lindx&(nseg% + 1) = npts% + 1 'Dummy pointing to end of data file
CLOSE 1
LOOP ' loop1 over all files
CLOSE 1
CLOSE 2
'Did we get anything
IF npts% = 8 THEN   'v3
 IF nmaps% = 1 THEN
  CLS
  PRINT " Oops! None of the files in "; path
  PRINT "contained any data points within "; mradm!; " nautical miles"
  PRINT "of your map center of "; lat0!; " N and "; long0!; " W"
  PRINT "Get the right files from CD or recenter the APRS map"
  PRINT
  PRINT "In the last file examined the four corners of the grid were:"
  OPEN path + "\" + F FOR RANDOM AS #1 LEN = rcln%
  FIELD 1, 80 AS banner
  FOR ptr% = 11 TO 14
  GET 1, ptr%
  PRINT banner
  NEXT ptr%
  PRINT
  CLOSE 1
  PRINT "Hit any key to continue"
  DO UNTIL INKEY$ <> "": LOOP
 ELSE
  et! = INT(tstop! - tstart! + .5)
  PRINT #4, datf; et!; lat0!; long0!; npts%; " NO DATA FOUND"; F'v3
 END IF
ELSE 'finish map v3
  mseg% = nseg%
  mpts% = npts%
  CALL achain(lindx&(), datf, mseg%, mpts%)
rpts% = mpts% - mseg% - 8
  PRINT
  IF nmaps% = 1 THEN
   PRINT "Reduction from "; npts%; " to "; rpts%; " points"
   PRINT "Reduction from "; nseg%; " to "; mseg%; " line segments"
   PRINT
   PRINT "Hit any key to continue"
   DO WHILE INKEY$ = "": LOOP
  ELSE
   et% = INT(tstop! - tstart! + .5)
   PRINT #4, USING fmt; datf; et%; lat0!; long0!; rpts%; npts%; nseg%; mseg%  'v4
  END IF
END IF        'v3
OPEN datf FOR APPEND AS #2
'Put end of map here
finish = "   0,  -1"
PRINT #2, finish
REM  Map extraction complete now test map for APRS 3000 pt limit
nrecm& = LOF(2) \ 11
CLOSE 2
IF rpts% > limit% THEN
   climit% = climit% + 1
ELSE
   NAME datf AS mapf
END IF
IF rpts% > big% THEN big% = rpts%
kmap% = kmap% + 1
LOOP     'loop0 over all nmaps% maps
IF nmaps% > 1 THEN
  PRINT #4, INT(TIMER - t00! + .5); "Total seconds map making for this session"
END IF
CLS
WIDTH 80, 25
IF climit% = 0 THEN
  PRINT "All maps are within the "; limit%; " point APRS limit."
  PRINT "All files named with extensions .map. Add to APRS maps files."
  PRINT "Be sure to update the maplist file as well"
  PRINT
  IF nmaps% > 1 THEN
   PRINT "Details will be found in the log file "; mapfb; ".txt"
  END IF
ELSE
  PRINT climit%; " of the "; nmaps%; " exceeded the "; limit%; "point APRS limit "
  PRINT "These maps will have to be reduced in size using MAPFIX."
  PRINT "Alternatively, you can start over using a different level of detail"
  PRINT "or a different map radius."
  PRINT "Number of points in the biggest map was"; big%
  PRINT "You chose a radius of "; mradm!
  PRINT "You chose a detail level of "; dtl$
  PRINT USING "Your latitude was ##_, ##.#"; INT(lat0!); 60 * (lat0! - INT(lat0!))
  PRINT USING "Your longitude was ###_, ##.#"; INT(ABS(long0!)); 60 * (ABS(long0!) - INT(ABS(long0!)))
  newrad! = mradm! * SQR(CSNG(limit%) / CSNG(big%))
  PRINT USING "Suggested new radius is ####.# nautical miles based on biggest map"; newrad!
  PRINT
  IF nmaps% > 1 THEN
   PRINT "The other "; nmaps% - climit%; " .dat files were renamed as .map "
   PRINT "and can be added to APRS maps files."
   PRINT "Be sure to update the maplist file as well"
   PRINT
   PRINT "Details will be found in the log file "; mapfb; ".txt"
  END IF
END IF
CLOSE 'v3
 PRINT
 PRINT "Hit any key to continue"
 DO WHILE INKEY$ = "": LOOP
CLOSE 'v3
STOP
punt:
CLS
WIDTH 80, 25
PRINT "Unrecoverable error "; ERR; " has occurred!"
PRINT "Input variables"
PRINT "Path- "; path
PRINT "lat0 -"; lat0!
PRINT "long0-"; long0!
PRINT "Radius-"; mradm!
PRINT "Status pointers"
PRINT "file- "; F
PRINT "Line segements extracted "; nseg%
PRINT "Points extracted "; npts%
PRINT "File record number "; rcno&
PRINT "Do a screen dump to printer so author can de-bug"
STOP
'Hit F4 to see error msg; print screen for help in de-bugging
END

REM $STATIC
SUB achain (lindx&(), datf, mseg%, mpts%)
REDIM tindx&(8192), hd(8192, 2) AS INTEGER, tl(8192, 2) AS INTEGER
OPEN datf FOR RANDOM AS #2 LEN = 11
OPEN tfl FOR RANDOM AS #3 LEN = 11
FIELD 2, 11 AS outstuff
FIELD 3, 4 AS xcoord, 1 AS cma, 4 AS ycoord, 2 AS crlf
FIELD 3, 11 AS instuff
LOCATE 1, 1
PRINT SPACE$(45);
LOCATE 1, 1
PRINT "Chaining segments ";
nseg% = mseg%
npts% = mpts%
'build table of line start and end points
'lindx&() built in main routine with pointer to "0,0" line starts
FOR i% = 1 TO nseg%
 i1& = lindx&(i%) + 2 'start
 GET 3, i1&
 hd(i%, 1) = VAL(xcoord)
 hd(i%, 2) = VAL(ycoord)
 i2& = lindx&(i% + 1) - 1'end
 tindx&(i%) = i2&
 GET 3, i2&
 tl(i%, 1) = VAL(xcoord)
 tl(i%, 2) = VAL(ycoord)
NEXT i%
 hd(nseg% + 1, 1) = &H8F
 hd(nseg% + 1, 2) = &H8F
 tl(nseg% + 1, 1) = &H8F
 tl(nseg% + 1, 2) = &H8F
CALL sort(lindx&(), nseg%)
'copy first 8 header items from tmap.raw to data file
FOR i% = 1 TO 8
GET 3, i%
LSET outstuff = instuff
PUT 2, i%
NEXT i%
maxr& = LOF(3) / 11
bstr = "   0,   0" + CHR$(&HD) + CHR$(&HA)
done% = &H7F
'copy first segment to data file
mpts% = 8   'Output counters # of saved pts
mseg% = 1   'Saved chained segments
sseg% = 0   'Nest segment to start a new line
j& = 9      'Output file pointer
i1& = 9     'Input file pointer to segment start
i& = 9      'Input file working pointer
GET 3, 10
oclr% = VAL(instuff)
clr% = oclr%
i2& = lindx&(2) - 1
sseg% = 0
DO   'The main loop over all segments l1
LOCATE 1, 19
PRINT sseg%; mseg%; mpts%;
'Find a segment that has not been processed
  DO
   sseg% = sseg% + 1
   tst% = hd(sseg%, 1)
  LOOP UNTIL tst% <> done%
cold! = -1
'write start segment to output file
i1& = lindx&(sseg%)
i2& = tindx&(sseg%)
i3& = i1& + 2
i& = i1&
DO    'loop over a line segment       l2
IF sseg% >= nseg% THEN EXIT DO
GET 3, i&
LSET outstuff = instuff
IF i& = i1& + 1 THEN oclr% = VAL(instuff)
PUT 2, j&
j& = j& + 1
mpts% = mpts% + 1
IF i& >= i3& THEN
 u% = VAL(xcoord) * Hfac!
 v% = VAL(ycoord)
 IF i& = i3& THEN
  PSET (u% * sfac!, v% * sfac!), 15
 ELSE
  LINE -(u% * sfac!, v% * sfac!)
 END IF
END IF
i& = i& + 1
LOOP UNTIL i& > i2&
mseg% = mseg% + 1
hd(sseg%, 1) = done%
tlx% = tl(sseg%, 1)
tly% = tl(sseg%, 2)
i& = tindx&(sseg%)
contflg% = 0
ccseg% = sseg% + 1
 DO         '{0} Double loop for continued continued segments
 cseg% = ccseg%
 cold! = -1
 nomore% = -1
  DO        '{1} loop thru to find segment that begins at end of last segment
  hdx% = hd(cseg%, 1)
  hdy% = hd(cseg%, 2)
   IF hdx% <> done% THEN   '{2} line has not been processed
    IF hdx% = tlx% AND hdy% = tly% THEN  '{3} coordinates match
     l& = lindx&(cseg%) + 1
     GET 3, l&
     clr% = VAL(instuff)
     IF clr% = oclr% THEN '{4} color match
      l& = l& - 1
      c! = dircos!(i&, l&)
         IF c! > cold! THEN '{5} save line with max direction cosine
          cold! = c!
          k1& = l& + 3'skip the repeated point
          k2& = tindx&(cseg%)'last point of segement
          kseg% = cseg%
          contflg% = -1 'indicates one line that continues from last line
          nomore% = 0
         END IF '{5}
       END IF '{4}
     END IF '{3}
   END IF '{2}
  cseg% = cseg% + 1
  LOOP UNTIL cseg% > nseg%  '{1}
  IF contflg% THEN  '{5}
   i& = k1&
   DO    'loop over a line segment
    GET 3, i&
    LSET outstuff = instuff
    PUT 2, j&
    j& = j& + 1
    mpts% = mpts% + 1
     u% = VAL(xcoord) * Hfac!
     v% = VAL(ycoord)
      LINE -(u% * sfac!, v% * sfac!)
     i& = i& + 1
   LOOP UNTIL i& > k2&
   contflg% = 0
   tlx% = tl(kseg%, 1)
   tly% = tl(kseg%, 2)
   i& = k2&
   hd(kseg%, 1) = done%  'Mark this segment as done
  END IF '{5}
 ccseg% = kseg% + 1
 LOOP UNTIL ccseg% >= nseg% OR nomore% '{0}
LOOP UNTIL sseg% >= nseg% 'l1
CLOSE 3
CLOSE 2
END SUB

FUNCTION dircos! (i&, j&)
FIELD 3, 4 AS xcoord, 1 AS cma, 4 AS ycoord, 2 AS crlf
GET 3, i& - 1
x1! = VAL(xcoord)
y1! = VAL(ycoord)
GET 3, i&
x2! = VAL(xcoord)
y2! = VAL(ycoord)
GET 3, j& + 2
u1! = VAL(xcoord)
v1! = VAL(ycoord)
GET 3, j& + 3
u2! = VAL(xcoord)
v2! = VAL(ycoord)
adotb! = (x2! - x1!) * (u2! - u1!) + (y2! - y1!) * (v2! - v1!)
mab! = SQR(((x2! - x1!) ^ 2 + (y2! - y1!) ^ 2) * ((u2! - u1!) ^ 2 + (v2! - v1!) ^ 2))
IF mab! <> 0 THEN
dircos! = adotb! / mab!
ELSE
dircos! = -1
END IF
END FUNCTION

SUB fltest (good%)
'This tests to see if whole file has good data points using corner references
good% = -1
FIELD 1, 6 AS quad, 12 AS rflat, 12 AS rflong, 18 AS refx, 12 AS refy, 20 AS fill3
rcno& = 13
GET 1, rcno& 'Get NE corner reference points
longz! = VAL(rflong) 'East meridian of section
newz! = 6 * FIX(longz! / 6) - 3 'Get utm zone center meridian
IF newz! <> utmz! THEN
   utmz! = newz!
   CALL utm(xx0#, yy0#, utmz!)
   lat0! = lat0! + .25'a short meridian line through origin of map
   CALL utm(x1#, y1#, utmz!)
   lat0! = lat0! - .25'restore
   dx! = x1# - xx0#
   dy! = y1# - yy0#
   phi! = -ATN(dx! / dy!)  'rotation angle between true north and grid north
   cr! = COS(phi!)
   sr! = SIN(phi!)
END IF
e! = VAL(refx) - xx0#
n! = VAL(refy) - yy0#
rcno& = rcno& - 2
GET 1, rcno&  'Get SW reference points
w! = VAL(refx) - xx0#
s! = VAL(refy) - yy0#
IF w! > xmax! THEN good% = 0
IF e! < xmin! THEN good% = 0
IF n! < ymin! THEN good% = 0
IF s! > ymax! THEN good% = 0
END SUB

SUB fsel (path, ND%)
 'DIRECTORY SELECT MENU
 DIM dir(100) AS STRING * 35
 DEF SEG = &HB800'THIS IS LOCATION OF VIDEO RAM SCREEN 0 TEXT MODE
 SCREEN 0, 0
 CLS
 FILES path + "\*.*"     'CHANGE TO SUIT APPLICATION
 KPT% = 1:
 IP% = 160
 Tflg% = 0
 DO
 FOR l% = 0 TO 3
 e$ = ""
 FOR j% = IP% + 36 * l% TO (IP% + 36 * l% + 34) STEP 2'CHAR. IN EVERY OTHER LOC.
 e$ = e$ + CHR$(PEEK(j%))
 NEXT j%
 IF INSTR(e$, "<DIR>") = 0 AND LEFT$(e$, 6) <> "      " THEN
   dir(KPT%) = e$
   KPT% = KPT% + 1
 END IF
 NEXT l%
 IF LEFT$(e$, 6) = "      " THEN Tflg% = -1
 IP% = IP% + 160
 LOOP UNTIL IP% > 23 * 160 OR Tflg%
 DEF SEG
 ND% = KPT% - 1

END SUB

SUB init (mapf, datf, path, nf%)
REM Initialization and user input routine
REM COMMON SHARED lat0!, long0!, ymax!, xmax!, scfy!, scfx!, rds%, mradm!, rcln%
REM COMMON SHARED lfac!, ppdy!, mpernm!, latmax!, longmin!, Hfac!, drady!, dradx!
REM COMMON SHARED ymin!, xmin!, yy0#, xx0#, utmz!, sr!, cr!, dir() AS STRING * 35
CLS
REDIM xlat!(676), xlon!(676)
PRINT "Making APRS maps from the 100000:1 CD DLG CD"
PRINT "is a two step process. If you got to this step,"
PRINT "you should have already unpacked and copied the"
PRINT "map files of interest from the CD to a working"
PRINT "directory on your hard disk following the "
PRINT "instructions found with the CD documentation. "
PRINT
PRINT "You may have downloaded the map data from the USGS ftp site and"
PRINT "un-g-zipped the files as an alternative method. These files are"
PRINT "unblocked i.e. they do not have the cr/lf at the end of each "
PRINT "record. This code cannot tell which kind of files are being  "
PRINT "used and the user must tell which type of file format is used"
PRINT
PRINT "Remember the path to this working directory to which"
PRINT "you copied the files. Only the files in that directory"
PRINT "be used to make APRS maps. Only CD files should be in "
PRINT "this hard drive sub-directory. Otherwise this program"
PRINT "will crash. "
PRINT
PRINT "Version 4.0b2  31 Jan 1999"
PRINT
INPUT "What is path to map files (default is c:\dlg)"; path
IF path = "" THEN path = "c:\dlg"
CLS
PRINT "File path  is "; path
rcln% = 82
REM fpt site file records are ony 80 bytes long
PRINT "Are you using the CD for map data (Y/n)?"
q$ = ""
DO
q$ = INKEY$
LOOP WHILE q$ = ""
IF UCASE$(q$) = "Y" OR q$ = CHR$(13) THEN
    rcln% = 82
ELSE
  PRINT "If the data files are from the ftp site, are"
  PRINT "they still unblocked (Y/N)?"
  q$ = ""
  DO
  q$ = INKEY$
  LOOP WHILE q$ = ""
  IF UCASE$(q$) = "Y" THEN
    rcln% = 80
    PRINT "80 byte ftp unblocked record length will be used"
  END IF
END IF
INPUT "Enter a file name for results (.map) will be added ", mapfb      'v3x
CLS
REM ................New code for Version 3.0...........................
PRINT "This version of makemap offers the user the option of producing"
PRINT "one, four, nine or many maps in one session.  If more than one map"
PRINT "is produced the pauses in the program are skipped.  The letter 'C'"
PRINT "in the diagrams below are the user input map center coordinates."
PRINT "For multiple maps, the first 6 letters of the file name are used"
PRINT "and a tag indicating the grid is appended to the file name. The "
PRINT "tags are shown in the diagrams. If you choose the N by M option "
PRINT "the lat/long input corresponds to the upper left corner of the set"
PRINT "of maps following ancient APRS tradition"
PRINT
l$ = STRING$(5, 196)
PRINT "      1            4                  9                S"
PRINT "   "; CHR$(218); l$; CHR$(191);
PRINT "   "; CHR$(218); l$; CHR$(194); l$; CHR$(191);
PRINT "   "; CHR$(218); l$; CHR$(194); l$; CHR$(194);
PRINT l$; CHR$(191); "   Special"
PRINT "   "; CHR$(179); "  C  "; CHR$(179);
PRINT "   "; CHR$(179); "  nw "; CHR$(179); "  ne "; CHR$(179);
PRINT "   "; CHR$(179); "  nw "; CHR$(179); "  nn "; CHR$(179);
PRINT "  ne "; CHR$(179); "    M by N"
PRINT "   "; CHR$(192); l$; CHR$(217);
PRINT "   "; CHR$(195); l$; "C"; l$; CHR$(180);
PRINT "   "; CHR$(195); l$; CHR$(197); l$; CHR$(197);
PRINT l$; CHR$(180); "  grid of maps"
PRINT "          ";
PRINT "   "; CHR$(179); "  sw "; CHR$(179); "  se "; CHR$(179);
PRINT "   "; CHR$(179); "  ww "; CHR$(179); "  cc "; CHR$(179);
PRINT "  ee "; CHR$(179); "  Lat/Long input"
PRINT "          ";
PRINT "   "; CHR$(192); l$; CHR$(193); l$; CHR$(217);
PRINT "   "; CHR$(195); l$; CHR$(197); l$; CHR$(197);
PRINT l$; CHR$(180); "  upper left (NW) corner"
PRINT "                          ";
PRINT "   "; CHR$(179); "  sw "; CHR$(179); "  ss "; CHR$(179);
PRINT "  se "; CHR$(179)
PRINT "                          ";
PRINT "   "; CHR$(192); l$; CHR$(193); l$; CHR$(193);
PRINT l$; CHR$(217)
DO
bozo% = 0
PRINT "Press the key corresponding to the number of maps to be made (1,4, 9 or S)"
q$ = ""
 DO
  q$ = INKEY$
 LOOP WHILE q$ = ""
qb$ = UCASE$(q$)'v3
IF INSTR("149S", qb$) = 0 THEN
 PRINT "That's not an acceptable answer!"
 PRINT "Try it again"
 bozo% = -1
END IF
LOOP WHILE bozo%
IF qb$ = "S" THEN
 ok% = 0
 DO WHILE NOT ok%
  INPUT "How many maps in east-west direction"; mew%
  INPUT "How many maps in north-south direction"; mns%
  nmaps% = mew% * mns%
 IF mew% > 26 OR mns% > 26 THEN
   PRINT "Sorry, the limit is 26 maps in either direction"
   PRINT "redo the last two answers"
 ELSE
  ok% = -1
 END IF
 LOOP
END IF
INPUT "Enter latitude of map center or corner in degrees & minutes (dd,mm.m) ", d!, m!'Manual for now
lat0! = d! + m! / 60!
INPUT "Enter longitude of map center or corner in degrees & minutes (dd,mm.m) ", d!, m!
long0! = ABS(d!) + m! / 60!
long0! = -1! * ABS(long0!) 'Optional format requries negative west longitudes
PRINT

INPUT "Enter map radius (N-S) in nautical miles ", mradm$
mradm! = VAL(mradm$)
ex% = 0
IF RIGHT$(mradm$, 1) = "+" THEN ex% = 1
CLS
PRINT "Now you need to specify the level of detail on the map"
PRINT "Lake and ocean shore lines shown at all levels"
PRINT "This can be Sparse, Normal, Detail, or All available"
PRINT ""
PRINT " Radius     Sparse      Normal      Detail       All"
PRINT
PRINT " >16nm    Not recommended, Class 1 and 2 roads, shoreline only"
PRINT
PRINT "8 to 16nm   Cl1-2roads   Cl1-3rds   Cl1-4rds     Cl1-5&4wd"
PRINT
PRINT "2 to 8      Cl1-3        Cl1-4      Cl1-5        Cl 1-5&4wd"
PRINT
PRINT " <2         Cl1-4        Cl1-5      Cl1-5&4wd    Cl 1-5&4wd"
PRINT
PRINT "With All, you get every river, strean, and drainage ditch"
PRINT "Class is abbrviated Cl; 4wd means four wheel drive trail"
tlv% = -1
valid% = 0
DO
PRINT
INPUT "Enter your desired level of detail, S,N,D,A (default=N)"; dtl$
dtl$ = UCASE$(dtl$)
IF dtl$ = "" THEN dtl$ = "N"
valid% = INSTR("SNDA", dtl$)
IF valid% = 0 THEN PRINT dtl$; " IS NOT A VALID RESPONSE, please try again"
LOOP UNTIL valid% <> 0
SELECT CASE mradm!
CASE IS > 16!
 CLS
 PRINT
 PRINT "The 100K CD is not recommended for maps bigger than"
 PRINT "16 miles. Use the 2Meg CD instead.  The code will proceed"
 PRINT "but be warned that it may crash"
 PRINT
 PRINT "Hit any key to continue"
 DO WHILE INKEY$ = "": LOOP
 rds% = 208
CASE IS > 8!
 rds% = 209
CASE IS > 4!
  rds% = 210
CASE IS > 2!
 rds% = 210
CASE IS <= 2!
  rds% = 211
END SELECT
SELECT CASE dtl$
CASE IS = "S"
sg% = -1
CASE IS = "N"
sg% = 0
CASE IS = "D"
sg% = 1
CASE IS = "A"
sg% = 1
tlv% = 0
END SELECT
rds% = rds% + sg% + ex%
IF rds% > 212 THEN rds% = 212
IF rds% < 208 THEN rds% = 208
CLS
IF NOT tlv% THEN
   PRINT "All features from all map data files will be extracted"
   PRINT "This maximum content mapping but may result in too big"
   PRINT " a map for APRS"
ELSE
  PRINT "Shore lines of seacoasts, lakes and river banks will be"
  PRINT "extracted.  River banks must have been two distinct lines"
  PRINT "on the original maps to be extracted"
  SELECT CASE rds%
  CASE 209
   PRINT "Primary and major secondary roads will be extracted"
  CASE 210
   PRINT "All primary, secondary roads and streets will be extracted"
  CASE 211 TO 212
   PRINT "All road data including tracks and trails will be extracted"
  END SELECT
END IF
PRINT
PRINT "Hit any key to continue"
DO WHILE INKEY$ = "": LOOP
mpernm! = 1852  'Meters per nautical mile
PRINT
PRINT "Do you want to use an adjcent map overlap factor?"
PRINT "Default is zero; values greater than 10% are defaulted"
INPUT "Enter a value between 0 and 10 %"; ovrlp
IF ovrlp = "" THEN
   ovrlap! = 1!
ELSE
   ovrlap! = 1 + VAL(ovrlp) / 100
END IF
IF ovrlap! > 1.10001 THEN ovrlap! = 1!

mradm! = ovrlap! * mradm!  'This done so adjacent maps overlap
CALL fsel(path, nf%)
CLOSE 1
'Scaling the map and screen
utmz! = 99    'Dummy start value
ae# = 6378206 'Clarke 1866 NAD-27
e# = .0822689
e2# = e# * e#
lfac! = COS(pi! * lat0! / 180!)
rady! = mradm!
radx! = 4 * mradm! / 3 'screen aspect ratio
ymax! = mpernm! * rady! 'meters from center to top edge
ymin! = -ymax!
xmax! = mpernm! * radx! 'meters from center to left edge
xmin! = -xmax!
scfy! = 180! * SQR((1 - e2# * (SIN(pi! * lat0! / 180)) ^ 2) ^ 3) / (ae# * (1 - e2#) * pi!)
scfx! = 180! * SQR(1 - e2# * (SIN(pi! * lat0! / 180)) ^ 2) / (ae# * lfac! * pi!)
drady! = rady! * (scfy! * mpernm!)'map vertical half span in degrees lat.
dradx! = radx! * (scfx! * mpernm!)'map horz. half span in degress long.
latmax! = lat0! + drady!
longmax! = ABS(long0!) + dradx!
ppdy! = INT(2! * 175! / drady! + .5) 'Data file scaling both lat&long
ppdx! = INT(2! * 320! / dradx! + .5)
Hfac! = ppdx! / ppdy!   'Sreen horizontal scaling
pixels! = ppdy! * 2 * mradm! * scfy! * 1852
IF pixels! <= 350 THEN
  sfac! = 1
ELSE
  sfac! = 350! / pixels!
END IF

SELECT CASE qb$
CASE "1"
nmaps% = 1
xlat!(1) = lat0!
xlon!(1) = long0!
CASE "4"
nmaps% = 4
dlat! = drady! / ovrlap!
dlon! = dradx! / ovrlap!
xlat!(1) = lat0! + dlat!
xlon!(1) = long0! - dlon!
xlat!(1) = lat0! + dlat!
xlon!(1) = long0! - dlon!
xlat!(2) = lat0! + dlat!
xlon!(2) = long0! + dlon!
xlat!(3) = lat0! - dlat!
xlon!(3) = long0! - dlon!
xlat!(4) = lat0! - dlat!
xlon!(4) = long0! + dlon!
ftag(1) = "nw"
ftag(2) = "ne"
ftag(3) = "sw"
ftag(4) = "se"
IF LEN(mapfb) >= 6 THEN
  mapfb = LEFT$(mapfb, 6)
END IF
CASE "9"
nmaps% = 9
dlat! = 2! * drady! / ovrlap!
dlon! = 2! * dradx! / ovrlap!
ix% = 0
FOR i% = -1 TO 1
FOR j% = -1 TO 1
ix% = ix% + 1
xlat!(ix%) = lat0! - i% * dlat!
xlon!(ix%) = long0! + j% * dlon!
NEXT j%
NEXT i%
IF LEN(mapfb) >= 6 THEN
  mapfb = LEFT$(mapfb, 6)
END IF
CASE "S"
dlat! = 2! * drady! / ovrlap!
dlon! = 2! * dradx! / ovrlap!
lats! = lat0! - dlat! / 2!
lons! = long0! + dlon! / 2
FOR i% = 1 TO mns%
th = CHR$(96 + i%)
latt! = lats! - dlat! * (i% - 1)
FOR j% = 1 TO mew%
k% = j% + mew% * (i% - 1)
xlat!(k%) = latt!
xlon!(k%) = lons! + dlon! * (j% - 1)
ftag(k%) = th + CHR$(96 + j%)
NEXT j%
NEXT i%
IF LEN(mapfb) >= 6 THEN
  mapfb = LEFT$(mapfb, 6)
END IF
END SELECT
REM Ver 3.0 open a log file
IF nmaps% > 1 THEN
  logf = mapfb + ".txt"
  OPEN logf FOR OUTPUT AS #4
  PRINT #4, mapfb, DATE$; TIME$
  PRINT #4, mradm! / ovrlap!; " nautical mile maps"
  PRINT #4, "  File        Time     Lat       Long       Points      Lines"
END IF
CLS
SCREEN 9
WIDTH 80, 43
END SUB

SUB setup (kmap%)
IF nmaps% > 1 THEN
datf = mapfb + ftag(kmap%) + ".dat"'Data extracted from CD goes to this file
mapf = mapfb + ftag(kmap%) + ".map"'This file has final APRS map
ELSE
datf = mapfb + ".dat"
mapf = mapfb + ".map"
END IF
mpernm! = 1852  'Meters per nautical mile
lat0! = xlat!(kmap%)
long0! = xlon!(kmap%)
latmax! = lat0! + drady!
longmax! = ABS(long0!) + dradx!
CALL utm(xx0#, yy0#, utmz!)

OPEN tfl FOR OUTPUT AS #2
PRINT #2, USING "###.####_,"; latmax!
PRINT #2, USING "###.####_,"; longmax!
PRINT #2, USING "#####.##_,"; ppdy!
PRINT #2, USING "###.####_,"; lat0!
PRINT #2, USING "###.####_,"; ABS(long0!)
PRINT #2, USING "###.####_,"; mradm!
PRINT #2, "0,Reservd"
ptp% = INSTR(datf, ".") - 1
PRINT #2, USING "*\      \"; LEFT$(datf, ptp%)

END SUB

DEFSNG A-Z
SUB sort (lx() AS LONG, maxrow AS INTEGER)
' =============================== ShellSort ==================================
'  The ShellSort procedure is similar to the BubbleSort procedure.  However,
'  ShellSort begins by comparing elements that are far apart (separated by
'  the value of the Offset variable, which is initially half the distance
'  between the first and last element), then comparing elements that are
'  closer together (when Offset is one, the last iteration of this procedure
'  is merely a bubble sort).
' ============================================================================
'

   ' Set comparison offset to half the number of records in SortArray:
   offset% = maxrow \ 2

   DO WHILE offset% > 0          ' Loop until offset gets to zero.
      lim% = maxrow - offset%
      DO
         switch% = FALSE         ' Assume no switches at this offset.

         ' Compare elements and switch% ones out of order:
         FOR row = 1 TO lim%
            IF hd(row, 2) > hd(row + offset%, 2) THEN   'soet on y-coord
               SWAP hd(row, 1), hd(row + offset%, 1)
               SWAP hd(row, 2), hd(row + offset%, 2)
               SWAP tl(row, 1), tl(row + offset%, 1)
               SWAP tl(row, 2), tl(row + offset%, 2)
               SWAP lx(row), lx(row + offset%)
               SWAP tindx&(row), tindx&(row + offset%)
               switch% = row
            END IF
         NEXT row

         ' Sort on next pass only to where last switch was made:
         lim% = switch% - offset%
      LOOP WHILE switch%

      ' No switches at last offset, try one half as big:
      offset% = offset% \ 2
   LOOP
END SUB

DEFSTR A-Z
SUB Test (rcno&, rstop&, ratt&, ncoor%, nlatt%, testflg%, icolor%, lab)
REM COMMON SHARED lat0!, long0!, ymax!, xmax!, scfy!, scfx!
REM COMMON SHARED ymin!, xmin!, yy0#, xx0#
REM First test attribute and set color and line label if good
testflg% = 0
longflg% = 0
icolor% = 7
FIELD 1, 6 AS cmj1, 6 AS cmn1, 6 AS cmj2, 6 AS cmn2, 6 AS cmj3, 6 AS cmn3
  GET 1, ratt&
  attrb% = VAL(cmj1)
 IF ncoor% > 60 THEN longflg% = -1
IF tlv% THEN
SELECT CASE attrb%
  CASE 50 'Stream, river bank or shore line
    minor% = VAL(cmn1)
    IF minor% > 199 AND minor% < 207 AND minor% <> 202 THEN 'shore lines
      icolor% = 3
      lab = "st"
      testflg% = -1
    ELSEIF minor% = 605 OR minor% = 606 THEN 'River bank
      icolor% = 3
      lab = "st"
      testflg% = -1
    ELSEIF minor% = 406 THEN 'Dam
      icolor% = 3
      lab = "st"
      testflg% = -1
    END IF
  CASE 170, 179  'roads general
     minor% = VAL(cmn1)
     IF minor% > 200 AND minor% <= rds% THEN 'Road category depends on map size
       icolor% = 7
       lab = "rd"
       testflg% = -1
     ELSEIF minor% = 615 THEN  'By-pass
       icolor% = 10
       lab = "bp"
       testflg% = -1
     END IF
     'Now test to see if second attribute applies
     at2% = VAL(cmj2)
     mn2% = VAL(cmn2)
     IF at2% = 170 AND nlatt% > 2 THEN 'Go to 3rd attribute
       at2% = VAL(cmj3)
       mn2% = VAL(cmn3)
     END IF
     SELECT CASE at2%
     CASE 170  'roads general
     minor% = VAL(cmn2)
     IF minor% > 200 AND minor% <= rds% THEN 'Road category depends on map size
       icolor% = 7
       lab = "rd"
       testflg% = -1
     ELSEIF minor% = 615 THEN  'By-pass
       icolor% = 10
       lab = "bp"
       testflg% = -1
     END IF
     CASE 172  'Interstate
         icolor% = 10
         lab = "I-" + RIGHT$(STR$(mn2%), 3) 'route number
       testflg% = -1
     CASE 173  'US route
         icolor% = 12
         lab = "us" + RIGHT$(STR$(mn2%), 3)  'route number
       testflg% = -1
     CASE 174  'State route
         icolor% = 4
         lab = "sr" + RIGHT$(STR$(mn2%), 3)  'route number
         testflg% = -1
     CASE 175  'Reservation road
         icolor% = 4
         lab = "rv" + RIGHT$(STR$(mn2%), 3)  'route number
         testflg% = -1
     CASE 176 'County route
         icolor% = 7
         lab = "cr" + RIGHT$(STR$(mn2%), 3)  'route number
         testflg% = -1
    END SELECT
'continue with first attribute
  CASE 172  'Interstate
         icolor% = 10
         lab = "I" + RIGHT$(cmn1, 3)
       testflg% = -1
  CASE 173  'US route
         icolor% = 12
         lab = "us" + RIGHT$(cmn1, 3)
       testflg% = -1
  CASE 174  'State route
         icolor% = 4
         lab = "sr" + RIGHT$(cmn1, 3)
       testflg% = -1
  END SELECT
 IF NOT testflg% AND rds% > 208 THEN
  SELECT CASE attrb%
   CASE 175  'Reservation road
         icolor% = 4
         lab = "rv" + RIGHT$(cmn1, 3)  'route number
         testflg% = -1
   CASE 176 'County route
        icolor% = 7
        lab = "cr" + RIGHT$(cmn1, 3)  'route number
         testflg% = -1
   CASE 177  'Lettered county eg WI
         icolor% = 7
         lab = "cr" + CHR$(minor% + 64)'route letter
       testflg% = -1
  END SELECT
 END IF
ELSE   'Selecting all features
 testflg% = -1
END IF
IF testflg% THEN
' Test last point to see if it is on map
FIELD 1, 12 AS u1, 12 AS v1, 12 AS u2, 12 AS v2, 12 AS u3, 12 AS v3
GET 1, rstop& - 1
 IF VAL(u3) <> 0 THEN  'get the very last point; could be anywhere in record
  x! = VAL(u3) - xx0#
  y! = VAL(v3) - yy0#
 ELSEIF VAL(u2) <> 0 THEN
  x! = VAL(u2) - xx0#
  y! = VAL(v2) - yy0#
 ELSE
  x! = VAL(u1) - xx0#
  y! = VAL(v1) - yy0#
 END IF
 IF (y! <= ymax!) AND (y! >= ymin!) THEN
    IF (x! <= xmax!) AND (x! >= xmin!) THEN
     testflg% = -1
    END IF
 END IF
 IF NOT testflg% THEN
 ' Test midpoint to see if it falls on the map
  recmid& = (rstop& - 1 + rcno&) \ 2
  GET 1, recmid&
  x! = VAL(u2) - xx0# 'This catches short 2pt lines
  y! = VAL(v2) - yy0#
   IF (y! <= ymax!) AND (y! >= ymin!) THEN
     IF (x! <= xmax!) AND (x! >= xmin!) THEN
     testflg% = -1
     END IF
   END IF
 IF longflg% THEN 'test quarter points
   IF NOT testflg% THEN
   ' Test first quarter point on long line segments
    recfq& = rcno& + ncoor% \ 4
    GET 1, recfq&
    x! = VAL(u2) - xx0# 'This catches short 2pt lines
    y! = VAL(v2) - yy0#
    IF (y! <= ymax!) AND (y! >= ymin!) THEN
     IF (x! <= xmax!) AND (x! >= xmin!) THEN
      testflg% = -1
     END IF
    END IF
   END IF
   IF NOT testflg% THEN
   ' Test last quarter point on long line segments
    reclq& = rstop& - ncoor% \ 4
    GET 1, reclq&
    x! = VAL(u2) - xx0# 'This catches short 2pt lines
    y! = VAL(v2) - yy0#
    IF (y! <= ymax!) AND (y! >= ymin!) THEN
     IF (x! <= xmax!) AND (x! >= xmin!) THEN
      testflg% = -1
     END IF
    END IF
  END IF
 END IF
' Test first point to see if it is on map
 IF NOT testflg% THEN
  GET 1, rcno&
  x! = VAL(u1) - xx0#
  y! = VAL(v1) - yy0#
 ' PRINT tab30; x!; y!  'debug line
   IF (y! <= ymax!) AND (y! >= ymin!) THEN
     IF (x! <= xmax!) AND (x! >= xmin!) THEN
     testflg% = -1
     END IF
   END IF
 END IF
END IF
END IF
IF NOT tlv% THEN 'Assign color when all data being used.\
FIELD 1, 6 AS cmj1, 6 AS cmn1, 6 AS cmj2, 6 AS cmn2, 6 AS cmj3, 6 AS cmn3
  GET 1, ratt&
  attrb% = VAL(cmj1)
SELECT CASE attrb%
  CASE 50 'Stream, river bank or shore line
      icolor% = 3
      lab = "st"
  CASE 170, 179  'roads general
     minor% = VAL(cmn1)
     IF minor% > 200 THEN 'Road category depends on map size
       icolor% = 7
       lab = "rd"
     ELSEIF minor% = 615 THEN  'By-pass
       icolor% = 10
       lab = "bp"
     END IF
     'Now test to see if second attribute applies
     at2% = VAL(cmj2)
     mn2% = VAL(cmn2)
     IF at2% = 170 AND nlatt% > 2 THEN 'Go to 3rd attribute
       at2% = VAL(cmj3)
       mn2% = VAL(cmn3)
     END IF
     SELECT CASE at2%
     CASE 170  'Any  road feature
         icolor% = 7
         lab = "rd" + RIGHT$(STR$(mn2%), 3)  'route number
     CASE 172  'Interstate
         icolor% = 10
         lab = "I-" + RIGHT$(STR$(mn2%), 3) 'route number
     CASE 173  'US route
         icolor% = 12
         lab = "us" + RIGHT$(STR$(mn2%), 3)  'route number
     CASE 174  'State route
         icolor% = 4
         lab = "sr" + RIGHT$(STR$(mn2%), 3)  'route number
     CASE 175  'Reservation road
         icolor% = 7
         lab = "rd" + RIGHT$(STR$(mn2%), 3)  'route number
     CASE 176 'County route
        icolor% = 7
         lab = "cr" + RIGHT$(STR$(mn2%), 3)  'route number
    END SELECT
'continue with first attribute
  CASE 172  'Interstate
         icolor% = 10
         lab = "I" + RIGHT$(cmn1, 3)
  CASE 173  'US route
         icolor% = 12
         lab = "us" + RIGHT$(cmn1, 3)
  CASE 174  'State route
         icolor% = 4
         lab = "sr" + RIGHT$(cmn1, 3)
  CASE 180
         icolor% = 8
         lab = "rr"
  CASE 190
         icolor% = 14
         lab = "ul"
CASE ELSE
         icolor% = 7
         lab = "rd"
 END SELECT
END IF

END SUB

SUB utm (x#, y#, utmz!)
CONST pi# = 3.14159265359#
'COMMON SHARED lat0!, long0!, ymax!, xmax!, scf!, ppdx!
'This performs the lat/long coordinate conversion of map center
' to 100K CD  UTM projection coordinates.
' Algorithm found in Pearson, 'Map Projections', CRC Press, 1990, p343
' Text on pp 210-213 has numerous typos
a0# = 6378206 'Clark 1866 reference spheroid
e# = .082269
e2# = e# * e#
e4# = e2# * e2#
lat0r! = lat0! * pi# / 180!
dl! = (long0! - utmz!) * pi# / 180!
fe# = 500000  'False easting of x-coordinate of zone center meridian
cphi! = COS(lat0r!)
sphi! = SIN(lat0r!)
tphi! = TAN(lat0r!)
tphi2! = tphi! * tphi!
rp# = a0# / SQR(1! - e2# * sphi! * sphi!)
f1# = (1! - .25 * e2# - .046875 * e4#) * lat0r!
f2# = (.375 * e2# + .093758 * e4#) * SIN(2! * lat0r!)
f3# = .058594 * e4# * SIN(4! * lat0r!)
dm# = a0# * (f1# - f2# + f3#)
n2# = e2# * cphi! ^ 2 / (1 - e2#)
fx# = (1# - tphi2! + n2#)
fy# = (5# - tphi2! + 9# * n2#)
xx# = rp# * (dl! * cphi! + (dl! * cphi!) ^ 3 * fx# / 6#)
yy# = dm# + rp# * (dl! ^ 2 * sphi! * cphi! / 2 + dl! ^ 4 * sphi! * cphi! ^ 3 * fy# / 24#)
x# = .9996 * xx# + fe#
y# = .9996 * yy#


END SUB

