DECLARE SUB Schematic ()
DECLARE SUB ReplyString ()
DECLARE SUB BeginFile ()
DECLARE SUB CloseFile ()
DECLARE SUB LoadAlphabet ()
DECLARE SUB LoadWords ()
DECLARE SUB LoadWAVE ()
DECLARE SUB Say (a$)
DECLARE SUB TestSpell ()
DECLARE SUB ViewFile ()
DECLARE SUB Capture ()
DECLARE SUB PTT (x!)
DECLARE SUB Pause (T!)
DECLARE SUB Spell (a$)
DECLARE SUB Voice (F$, B!, L!)
DECLARE SUB Init ()
DECLARE SUB WB4APR ()
DECLARE SUB Mark ()
DECLARE SUB GetChar (a$)
DECLARE SUB CkKbrd (k$, B!, L!)
DECLARE SUB SkipB (B!)
DECLARE SUB PlotFile (B!, L!, k$)
DECLARE SUB Speak (a$)
COMMON SHARED WAV$, abc$, words$, Flen#, B!, L!, SF, ZF
COMMON SHARED ATL, char$(), Bgn(), Lgh()
COMMON SHARED WTL, Word$(), Bgw(), Lgw()
COMMON SHARED newfile

x = 37: DIM char$(x), Bgn(x), Lgh(x)
x = 50: DIM Word$(x), Bgw(x), Lgw(x)

CALL Init
CALL Schematic

'see Notes for things discovered so far...
'call FindChar  'to find out the key code for a keyboard key

Main:
 DO
   PRINT "WAVETEST.EXE                                                           WB4APR"
   PRINT
   PRINT "This DOS program aids in the building/testing of WAVE files for non-sound card"
   PRINT "old PCs.  First, it lets you test the ALPHABET and WORD files used by APRStt."
   PRINT
   PRINT "Second, it lets you VIEW any WAVE file waveform and select syllables for"
   PRINT "building addressable word files.  At startup, you are viewing the existing"
   PRINT "WORDS.WAV file used for APRStt.  To build an index TABLE for another wave"
   PRINT "file, ENTER the new wave filename and hit NEW to clear the index table.  Then"
   PRINT "VIEW the waveform and use the keys on the VIEW screen to isolate a syllable. "
   PRINT
   PRINT "Once you have identified a syllable, you simply hit the CAPTURE command"
   PRINT "to capture the address and length parameters and then enter the ascii"
   PRINT "name associated with that sound.  This CAPTURE data builds a table and then"
   PRINT "the CLOSE file command lets you save the index TABLE in a .TBL file."
   PRINT

   PRINT "A - Adjust voice Speed    N - New.  Begin constructing a NEW WORD table file"
   PRINT "D - Display Schematic     C - Close new WORD table file and save to disk"
   PRINT "R - REPLY string test     E - Enter new WAVE filename for viewing"
   PRINT "S - SPELL strings"
   PRINT "V - View WAVE file"
   PRINT "Q - Quit"
   PRINT
   PRINT "Select OPTION"; : CALL GetChar(a$): PRINT
   PRINT "---------------------------------------------------------------------------";
  
   IF a$ = "A" THEN
      PRINT "Present voice speed sounds like this...": Spell ("ABCDEFG")
      PRINT : PRINT "Current speed factor is"; SF; ".  (5 is fine on my 25 MHz laptop)"
      INPUT "Enter new value"; SF
      Spell ("ABCDEFG")
   ELSEIF a$ = "N" THEN CALL BeginFile
   ELSEIF a$ = "C" THEN CALL CloseFile
   ELSEIF a$ = "D" THEN CLS : CALL Schematic
   ELSEIF a$ = "E" THEN PRINT : INPUT "Enter new WAVE file name"; WAV$: a$ = "V"
   ELSEIF a$ = "R" THEN CALL ReplyString
   ELSEIF a$ = "S" THEN CALL TestSpell
   ELSEIF a$ = "Q" THEN STOP
   END IF
   IF a$ = "V" THEN CALL ViewFile
 LOOP
END

SUB BeginFile

 CLS
 PRINT "NEW FILE:"
 PRINT
 PRINT "This function to build an index table for all the words or sounds in"
 PRINT "a WAVE file is not perfect.  It currently has an END-OF-FILE bug that"
 PRINT "will crash when you get to the end of the file.  This will cause you"
 PRINT "to loose all your 'capture' data."
 PRINT
 PRINT "WORK-AROUND:  To get around this, with a new file.  Go immediately to"
 PRINT "view the end of the file and approach it incrementally until you get"
 PRINT "an idea of the last viewable syllable in the file without crashing. "
 PRINT "Once you know that end point, then you can go do the CAPTURE process"
 PRINT "and stop before you get there without fear of losing your data."
 PRINT
 PRINT "Another work around is to just record a little blank space on the end"
 PRINT "of the WAVE file and stop before you get there."
 PRINT
 PRINT "Also you can stop and save a Capture file at any time and just use a text"
 PRINT "editor later to join multiple files together later..."
 PRINT

 IF newfile THEN
    BEEP
    INPUT "Current file is not saved.  Save it now (Y/N)", a$
    IF UCASE$(a$) <> "N" THEN CALL CloseFile
 ELSE INPUT "Hit ENTER to continue"; a$
 END IF

 WTL = 0
 newfile = -1

END SUB

SUB Capture

 'word$(i), Bgn(i), Lgh(i)
 LOCATE 23, 1: INPUT "Enter name of sound"; w$
 WTL = WTL + 1
 Word$(WTL) = w$: Bgw(WTL) = B!: Lgw(WTL) = L!

END SUB

SUB CkKbrd (k$, B!, L!)

 IF LEN(k$) = 2 THEN
    IF RIGHT$(k$, 1) = "M" THEN B! = B! + 100: ' IF B! > Flen# - L! THEN B! = Flen# - L!
    IF RIGHT$(k$, 1) = "K" THEN B! = B! - 100: IF B! < 1 THEN B! = 1
    IF RIGHT$(k$, 1) = "H" THEN L! = L! + 100: IF L! > Flen# THEN L! = Flen# - 1
    IF RIGHT$(k$, 1) = "P" THEN L! = L! - 100: IF L! < 1 THEN L! = 1
    'IF RIGHT$(k$, 1) = "Q" THEN ZF = ZF + 1
    'IF RIGHT$(k$, 1) = "I" THEN ZF = ZF - 1: IF ZF < 0 THEN ZF = 0

 ELSE
    LOCATE 23, 1: PRINT SPACE$(50); : LOCATE 23, 1
    IF k$ = "B" THEN INPUT "Begin Value"; B!
    IF k$ = "L" THEN INPUT "Length"; L!
    IF k$ = "C" THEN CALL Capture
    IF k$ = "N" THEN B! = B! + L!: k$ = "V"
    IF k$ = "V" THEN CLOSE : CALL Voice(WAV$, B!, L!)
    IF k$ = "F" THEN ZF = ZF + 1
    IF k$ = "S" THEN ZF = ZF - 1: IF ZF < 0 THEN ZF = 0

 END IF

END SUB

SUB CloseFile

 F$ = "nextfile.tbl"
 PRINT : PRINT "Close File:"
 PRINT : PRINT "Enter file name if other than ["; F$; "]";
 INPUT a$
 IF a$ <> "" THEN F$ = a$

 OPEN F$ FOR OUTPUT AS #2
 PRINT : PRINT "Saving file as "; F$
 FOR i = 1 TO WTL
     WRITE #2, Word$(i), Bgw(i), Lgw(i)
 NEXT
 CLOSE #2

 PRINT "File saved as "; F$
 PRINT
 INPUT "Hit ENTER to continue"; a$
 newfile = 0

END SUB

SUB FindChar

 DO
   CALL GetChar(a$)
   PRINT RIGHT$(a$, 1)
 LOOP

END SUB

SUB GetChar (a$)
 
 DO
   a$ = INKEY$
   IF a$ <> "" THEN EXIT DO
 LOOP
 a$ = UCASE$(a$)

END SUB

SUB Init

 CLS
 PRINT "WAVETEST.EXE"
 SF = 5   'Speed Factor  5 is about right for my 25 MHz laptop
 ZF = 1  'Zoom Factor for Plot screen
 B! = 3000
 L! = 3000  '8000 is one second

 CALL LoadAlphabet
 CALL LoadWords
 CALL LoadWAVE

END SUB

SUB LoadAlphabet

 abc$ = "alphabet.wav"
 F$ = "alphabet.tbl"
 PRINT "Loading Alphabet Table..."
 OPEN F$ FOR INPUT AS #1
 DO UNTIL EOF(1)
    i = i + 1
    INPUT #1, char$(i), Bgn(i), Lgh(i)
    IF char$(i) = "end" THEN i = i - 1: EXIT DO
 LOOP: ATL = i
 CLOSE

END SUB

SUB LoadWAVE

 WAV$ = "alphabet.wav"
 'This is for VIEWING file in OUTVOICE only, not needed for APRStt
 Strt = TIMER
 PRINT "Checking length of "; WAV$; " and processor speed...  "
 PRINT "This can take several seconds..."
 OPEN WAV$ FOR INPUT AS #1
 CALL SkipB(0)
 DO UNTIL EOF(1)
    a$ = INPUT$(2, 1)
    Flen# = Flen# + 2
    
 LOOP
 CLOSE
 Dly = TIMER - Strt
 SF = CINT(36 / (Dly * 4))

END SUB

SUB LoadWords

 words$ = "words.wav"
 F$ = "words.tbl"
 PRINT "Loading WORDS Table..."
 OPEN F$ FOR INPUT AS #1
 DO UNTIL EOF(1)
    i = i + 1
    INPUT #1, Word$(i), Bgw(i), Lgw(i)
    IF Bgw(i) = 0 THEN i = i - 1: EXIT DO
 LOOP: WTL = i
 CLOSE

END SUB

SUB Notes

 'internally to an 8000 Hz WAVE file here are the locations of the
 'RIFF file starting fields:

 'WAVE is at 9
 'fmt_ is at 13
 'fact is at 39
 'data is at 51

END SUB

SUB Pause (T)

 now = TIMER
 DO UNTIL ABS(TIMER - now) > T
 LOOP

END SUB

SUB PlotFile (B!, L!, k$)
 'each sample is 0.125 ms
 CLS : SCREEN 9
 E! = B! + L!
 LL = INT(L!)
 LOCATE 1, 5: PRINT "Speed Factor="; ZF
 LOCATE 1, 25: PRINT "Begin"
 LOCATE 1, 53: PRINT "End"
 LOCATE 1, 68: PRINT "Length"; Flen#;
 LOCATE 2, 5: PRINT "FILE: "; WAV$
 LOCATE 2, 24: PRINT B!; TAB(51); E!
 LOCATE 17, 28: PRINT "<---------"; LL; "--------->"
 LOCATE 18, 38: PRINT INT(LL / 8); "ms"
 LOCATE 20, 1: PRINT "COMMANDS: B-Begin point    L/R arrows <> adjust B     F-Faster"
 LOCATE 21, 11:          PRINT "L-Length adjust  up/dn arrows ^v adjust L   S-Slower"
 LOCATE 22, 11:          PRINT "C-Capture point  V-VOICE the syllable       Q-Quit"
 LOCATE 23, 11:          PRINT "N-Next syllable                              "
   k$ = UCASE$(INKEY$)
    IF k$ <> "" THEN CALL CkKbrd(k$, B!, L!)

 OPEN WAV$ FOR INPUT AS #1
 P = B! - L! - ZF: IF P < 0 THEN P = 0
 CALL SkipB(P)
 FOR y = 0 TO 256 STEP 64: LINE (1, y)-(640, y), 14: NEXT
 LOCATE 1, 1: PRINT "0"
 LOCATE 5, 1: PRINT "64"
 LOCATE 10, 1: PRINT "128"
 LOCATE 14, 1: PRINT "192"
 LOCATE 19, 1: PRINT "256"
 LINE (213, 1)-(213, 260), 15
 LINE (426, 1)-(426, 260), 15
 
 Fend = (Flen# - (ZF + 1)) / 128

 DO 'UNTIL LOC(1) > Fend
    P = P + ZF + 1: IF P > B! + 2 * L! THEN EXIT DO         'pointer in WAV file
    a$ = INPUT$(ZF, 1)
    a$ = INPUT$(1, 1)
    x = 213 + (P - B!) * 640 / (3 * L!)
    PSET (x, ASC(a$))
    k$ = UCASE$(INKEY$)
    IF k$ = "Q" THEN EXIT DO
    IF k$ <> "" THEN CALL CkKbrd(k$, B!, L!): EXIT DO
 LOOP
 CLOSE

END SUB

SUB PTT (x)

 IF x = 1 THEN
    OUT 890, INP(890) OR 1
    CALL Pause(.3)
 ELSE OUT 890, INP(890) AND 254
 END IF
END SUB

SUB ReplyString

 PRINT
 PRINT "REPLAY-STRING COMMAND:"
 PRINT
 PRINT "This routine speaks from a single ascii string that contains words  that"
 PRINT "are included in the WORD file.  Words are delimited by spaces and an extra"
 PRINT "space is rquired on the end as well.  Lower case words that are found in "
 PRINT "the WORD file are spoken. Uppercase words are spelled.  Numerals are "
 PRINT "spelled and any single letter is spelled out as well."
 PRINT
 PRINT "WORDS IN THE CURRENT FILE ARE:  "
 PRINT
 FOR i = 1 TO WTL: PRINT Word$(i); ", "; : NEXT
 PRINT
 PRINT
 INPUT "Enter String to be spoken"; a$
 a$ = a$ + " "
 CALL Speak(a$)

END SUB

SUB Say (a$)
    
 'all words in file must be in lower case

 FOR j = 1 TO WTL
     IF a$ = Word$(j) THEN CALL Voice(words$, Bgw(j), Lgw(j)): j = WTL
 NEXT j

END SUB

SUB Schematic

PRINT
PRINT "LPT1 PARALLEL PORT D/A VOICE CONVERTER SCHEMATIC:                    WB4APR"
PRINT "---------------------------------------------------------------------------"
PRINT
PRINT "                           +---------+"
PRINT " PIN-1 --------------------+ PTT CKT +----> To Radio PTT"
PRINT " PIN-2 --<640K>--+         +---------+"
PRINT " PIN-3 --<320K>--+"
PRINT " PIN-4 --<160K>--+"
PRINT " PIN-5 --<80 K>--*---*---------||---------> To Radio Microphone input"
PRINT " PIN-6 --<40 K>--+   \        10uF"
PRINT " PIN-7 --<20 K>--+   /"
PRINT " PIN-8 --<10 K>--+   \ 33 Ohms"
PRINT " PIN-9 --< 5 K>--+   /"
PRINT " PIN-25--------------* GND"
PRINT
PRINT "The D/A converter used by this program  is simply  8 resistors  on the LPT1"
PRINT "parallel port all summed together.  With a 33 ohm load resistor, the result"
PRINT "is about MIC-Level.  For LINE-Level, use a 390 ohm resistor.       [WB4APR]"
PRINT
INPUT "Hit ENTER to continue"; a$


END SUB

SUB ShowTable

 CLS
 FOR i = 1 TO Lmark
     PRINT i, char$(i), Bgn(i), Lgh(i)
 NEXT

END SUB

SUB SkipB (B!)

 'Skips to "data" and then skips rapidly to B!
 DO UNTIL a = 90 OR c > 7
    a$ = INPUT$(1, 1)
    a = a + 1
    IF c OR a$ = "d" THEN c = c + 1
 LOOP

 x = INT(B! / 250)
 IF x THEN FOR i = 1 TO x: a$ = INPUT$(250, 1): NEXT
 R = B! - x * 250
 a$ = INPUT$(R, 1)

END SUB

SUB Speak (a$)

 'This routine speaks a 'sentence' of words delimited by spaces
 'it speaks lower case words but SPELLS single characters and
 'UPPERCASE words and all numbers.
 'The 'sentence' must end with a space character

 CALL PTT(1)
 w$ = ""
 FOR i = 1 TO LEN(a$)
     c$ = MID$(a$, i, 1)
     IF c$ = " " THEN
        IF LEN(w$) = 1 OR w$ < "a" THEN
           CALL Spell(w$)
        ELSEIF VAL(w$) <> 0 THEN CALL Spell(w$)
        ELSE CALL Say(w$)
        END IF
        w$ = ""
     ELSE w$ = w$ + c$
     END IF
 NEXT i
 CALL PTT(0)

END SUB

SUB Spell (a$)

 x$ = UCASE$(a$)
 FOR i = 1 TO LEN(a$)
     FOR j = 1 TO ATL
         IF MID$(x$, i, 1) = char$(j) THEN CALL Voice(abc$, Bgn(j), Lgh(j))
     NEXT j
 NEXT i

END SUB

SUB TestSpell

 PRINT
 PRINT "SPELLING TEST:"
 PRINT : PRINT "Enter strings and have them spelled.  End by hitting ENTER only..."
 DO
  INPUT "Enter string"; a$
  IF a$ = "" THEN EXIT DO
  CALL PTT(1)
  CALL Spell(a$)
  CALL PTT(0)
 LOOP

END SUB

SUB ViewFile

 DO
   CALL PlotFile(B!, L!, k$)
   IF k$ = "Q" THEN EXIT DO
 LOOP

END SUB

SUB Voice (F$, B!, L!)

 OPEN F$ FOR INPUT AS #1
 CALL SkipB(B!)
 FOR i = 1 TO L!
    a$ = INPUT$(1, 1)
    OUT 888, ASC(a$)
    FOR j = 1 TO SF: NEXT
 NEXT
 CLOSE

END SUB

