/* VERZIA 19991203 */
/*  Nasleduju potrebne HEADER FILES: /* */

     #include <stdio.h>
     #include <time.h>
#if defined (LINUX)
     #include <sys/time.h>
     #include <unistd.h>
#else
     #include <dos.h>
#endif

/* */

/* ###########Subroutine############
*/

int cas_vypis_(void)

{

    #define SIZE 256

       char buffer[SIZE];
       time_t curtime;
       struct tm *loctime;

       /* Get the current time.  */
       curtime = time (NULL);

       /* Convert it to local time representation.  */
       loctime = localtime (&curtime);

       /* Print it out in a choosen format. */
       #if defined (SLOVAK)
        strftime (buffer, SIZE, "DATUM: %A, %d.%b %Y  DEN V ROKU: %j  TYZDEN: %W  CAS: %H:%M:%S  %Z \r", loctime);
       #else
        strftime (buffer, SIZE, "DATE: %A, %d.%b %Y  DAY OF YEAR: %j  WEEK: %W  TIME: %H:%M:%S  %Z \r", loctime);
       #endif

       printf(">>%s<<\n",buffer);

       return(0);
}
/* ######End Suboutine: cas_vypis_ ###########*/

/* ###########Subroutine############

Vrati datum a cas operacneho systemu.

   pri uspechu vracia 0
*/

int cas_hodnoty_(rok, mesiac, den, hodina, minuta, sekunda)

int *rok, *mesiac, *den, *hodina, *minuta, *sekunda;

{

       time_t curtime;
       struct tm *loctime;

       /* Get the current time.  */
       curtime = time (NULL);

       /* Convert it to local time representation.  */
       loctime = localtime (&curtime);

       /* rok je = naozajstny_rok-1900 */
       *rok = loctime->tm_year + 1900;
       /* mesiace su ulozene v rozsahu 0-11 */
       *mesiac = loctime->tm_mon + 1;
       *den = loctime->tm_mday;
       *hodina = loctime->tm_hour;
       *minuta =  loctime->tm_min;
       *sekunda =  loctime->tm_sec;

       return(0);
}
/* ######End Suboutine: cas_hodnoty_ ###########*/

/* ###########Subroutine############
Nastavi cas operacneho systemu

   pri uspechu vracia 0 inak -1
*/

int cas_nastavenie_(rok, mesiac, den, hodina, minuta, sekunda, stotiny)

int *rok, *mesiac, *den, *hodina, *minuta, *sekunda, *stotiny;

{
        time_t sectime;
        struct tm newtime;
        #if defined (LINUX)
         struct timeval tv;
         struct timezone tz;
        #else
         struct time t;
        #endif


  /* zo vstupnych parametrov vyrobime pozadovanu strukturu */
  newtime.tm_year = *rok - 1900;  /* rok je = naozajstny_rok-1900 */
  newtime.tm_mon = *mesiac - 1;   /* mesiace su ulozene v rozsahu 0-11 */
  newtime.tm_mday = *den;
  newtime.tm_hour = *hodina;
  newtime.tm_min = *minuta;
  newtime.tm_sec = *sekunda;
  newtime.tm_isdst = -1;          /* toto tu MUSI byt: daylight saving info is not available */

  /* najskor nastavime datum a cas s presnostou iba na cele sekundy */
  if( (sectime = mktime(&newtime)) != (time_t)-1 )  /* z newtime struktury ziskame reprezentaciu v sekundach */
    {
     stime(&sectime);
     #if defined (LINUX)
       gettimeofday(&tv, &tz);
       tv.tv_sec=sectime;
       tv.tv_usec=0L;
       /* tv.tv_usec = (long)*stotiny * 10000L; /* */
       tv.tv_usec=0L;
       /* return( settimeofday(&tv, &tz) ); /* */
     #else
       t.ti_hour =  *hodina;
       t.ti_min  =  *minuta;
       t.ti_sec  =  *sekunda;
       /* t.ti_hund = *stotiny; /* */
       t.ti_hund = 0;
       /* return( settime(&t) ); /* */
     #endif
     return(0); /* */
    }
  else
    return(-1);

/*-------------------------------------
  nastavovanie iba celych casti sekundy

/* z newtime struktury ziskame reprezentaciu v sekundach * /
  if( (sectime = mktime(&newtime)) != (time_t)-1 )
    return( stime(&sectime) );
  else
    return(-1);


  ------------------------------------- */
}
/* ######End Suboutine: cas_nastavenie_ ###########*/
