/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

class stereographicProjection
extends Projection {
    double radius2 = 114.67242620590352;
    double sinp;
    double cosp;

    LatLon calcMapCenter(LatLon latLon, LatLon latLon2, Rectangle rectangle) {
        LatLon latLon3 = new LatLon(latLon);
        latLon3.lat -= (latLon.lat - latLon2.lat) / 2.0;
        latLon3.lon -= (latLon.lon - latLon2.lon) / 2.0;
        if (Math.abs(latLon3.lon) > 180.0) {
            latLon3.lon = -Trig.sign(latLon3.lon) * (360.0 - latLon3.lon);
        }
        return latLon3;
    }

    XY toMapXY(LatLon latLon) {
        XY xY = new XY();
        if (latLon.equals(this.mapCenterLL)) {
            return xY;
        }
        double d = Trig.radians(latLon.lon - this.mapCenterLL.lon);
        double d2 = Trig.radians(latLon.lat);
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        double d5 = d3 * Math.cos(d);
        double d6 = this.radius2 / (1.0 + this.sinp * d4 + this.cosp * d5);
        xY.x = d6 * d3 * Math.sin(d);
        xY.y = d6 * (this.cosp * d4 - this.sinp * d5);
        return xY;
    }

    LatLon toLatLon(XY xY) {
        LatLon latLon = new LatLon(this.mapCenterLL);
        double d = Math.sqrt(xY.x * xY.x + xY.y * xY.y);
        if (d < 1.0E-5) {
            return latLon;
        }
        double d2 = 2.0 * Math.atan(d / this.radius2);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        latLon.lat = Trig.degrees(Math.asin(d4 * this.sinp + xY.y * d3 * this.cosp / d));
        latLon.lon += Trig.degrees(Math.atan(xY.x * d3 / (d * this.cosp * d4 - xY.y * this.sinp * d3)));
        return latLon;
    }

    stereographicProjection() {
    }

    stereographicProjection(LatLon latLon) {
        this.init(latLon);
    }

    stereographicProjection(LatLon latLon, double d) {
        this.init(latLon);
        this.radius2 = 2.0 * d;
    }

    stereographicProjection(LatLon latLon, double d, boolean bl) {
        this.init(latLon);
        this.radius2 = 2.0 * d;
        if (bl) {
            this.mapCenterLL.lat = 0.0;
        }
    }

    void init(LatLon latLon) {
        super.init(latLon);
        this.sinp = Math.sin(Trig.radians(latLon.lat));
        this.cosp = Math.cos(Trig.radians(latLon.lat));
    }
}

