/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;

class orthographicProjection
extends Projection {
    double sinp;
    double cosp;

    LatLon calcMapCenter(LatLon latLon, LatLon latLon2, Rectangle rectangle) {
        LatLon latLon3 = new LatLon(latLon);
        latLon3.lat -= (latLon.lat - latLon2.lat) / 2.0;
        latLon3.lon -= (latLon.lon - latLon2.lon) / 2.0;
        if (Math.abs(latLon3.lon) > 180.0) {
            latLon3.lon = -Trig.sign(latLon3.lon) * (360.0 - latLon3.lon);
        }
        return latLon3;
    }

    XY toMapXY(LatLon latLon) {
        if (this.mapCenterLL.distanceToDegrees(latLon) > 120.0) {
            return new XY(Double.NaN, Double.NaN);
        }
        if (latLon.equals(this.mapCenterLL)) {
            return new XY();
        }
        double d = latLon.lon - this.mapCenterLL.lon;
        if (Math.abs(d) > 180.0) {
            d = -Trig.sign(d) * (360.0 - Math.abs(d));
        }
        d = Trig.radians(d);
        double d2 = Trig.radians(latLon.lat);
        XY xY = new XY(Trig.degrees(Math.cos(d2) * Math.sin(d)), Trig.degrees(this.cosp * Math.sin(d2) - this.sinp * Math.cos(d2) * Math.cos(d)));
        return xY;
    }

    LatLon toLatLon(XY xY) {
        LatLon latLon = new LatLon(this.mapCenterLL);
        double d = Math.sqrt(xY.x * xY.x + xY.y * xY.y);
        if (d < 1.0E-4) {
            return latLon;
        }
        if (d > 120.0) {
            return new LatLon(Double.NaN, Double.NaN);
        }
        double d2 = Trig.radians(d);
        double d3 = Math.sqrt(1.0 - d2 * d2);
        latLon.lat = Trig.degrees(Math.asin(d3 * this.sinp + xY.y * d2 * this.cosp / d));
        latLon.lon = Math.abs(this.mapCenterLL.lat) == 90.0 ? (latLon.lon += Trig.degrees(Math.atan2(xY.x, -Trig.sign(this.mapCenterLL.lat) * xY.y))) : (latLon.lon += Trig.degrees(Math.atan2(xY.x * d2, d * this.cosp * d3 - xY.y * this.sinp * d2)));
        return latLon;
    }

    orthographicProjection() {
    }

    orthographicProjection(LatLon latLon) {
        this.init(latLon);
    }

    void init(LatLon latLon) {
        super.init(latLon);
        this.sinp = Math.sin(Trig.radians(latLon.lat));
        this.cosp = Math.cos(Trig.radians(latLon.lat));
    }
}

