/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

class TigerMap
extends APRSMap {
    void initMap() {
        this.firstrun = true;
    }

    TigerMap(javAPRS javAPRS2) {
        super(javAPRS2);
        this.theApplet.theParams.backgroundColor = Color.white;
        if (this.theApplet.theParams.foregroundColor == Color.white) {
            this.theApplet.theParams.foregroundColor = Color.black;
        }
        this.theApplet.setUpIcons();
        this.mapPPDXY.x = this.mapPPDXY.y = (double)this.size().height / this.theApplet.theParams.tigerMapHigh;
        if (this.theApplet.theParams.mapCenter.isNaN()) {
            this.screenCenterLL = new LatLon(this.theApplet.theParams.tigerMapTop - this.screenCenterXY.y / this.mapPPDXY.y, this.theApplet.theParams.tigerMapLeft + this.screenCenterXY.x / this.mapPPDXY.x);
            return;
        }
        this.screenCenterLL = new LatLon(this.theApplet.theParams.mapCenter);
    }

    void getMap() {
        if (this.mapImage != null) {
            this.tracker.removeImage(this.mapImage);
            this.mapImage = null;
        }
        this.mapImage = this.getImage(this.createTigerURLstring());
    }

    protected String createTigerURLstring() {
        if (Math.abs(this.screenCenterLL.lon) > 180.0) {
            this.screenCenterLL.lon = -Trig.sign(this.screenCenterLL.lon) * (360.0 - Math.abs(this.screenCenterLL.lon));
        }
        this.mapProjection = new sinusoidalProjection(this.screenCenterLL);
        this.recenter(this.screenCenterLL);
        double d = (double)this.size().height / this.mapPPDXY.y;
        double d2 = (double)this.size().width / this.mapPPDXY.x;
        this.theApplet.theSystem.println("TIGER Map " + this.screenCenterLL.toParam("mapCenter") + " tigerMapHigh=" + d);
        String string = "tiger.census.gov";
        if (this.theApplet.theParams.tigerMapRelay != null) {
            string = this.theApplet.theParams.tigerMapRelay;
        }
        return "http://" + string + "/cgi-bin/mapper/map.gif?lat=" + this.screenCenterLL.lat + "&lon=" + this.screenCenterLL.lon + "&wid=" + d2 + "&ht=" + d + "&iht=" + this.size().height + "&iwd=" + this.size().width;
    }
}

