/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class StationLog
extends Thread {
    protected Hashtable stationTable = new Hashtable();
    protected javAPRS theApplet;
    protected String searchStart = null;
    protected long prevpurge = System.currentTimeMillis();

    StationHistory search(Point point) {
        StationHistory stationHistory = null;
        boolean bl = false;
        APRSMap aPRSMap = this.theApplet.getMap();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                XY xY;
                StationHistory stationHistory2 = (StationHistory)enumeration.nextElement();
                if (stationHistory2.position == null || this.theApplet.checkFilter(stationHistory2) || (xY = aPRSMap.toMapXY(stationHistory2.position.position)).isNaN()) continue;
                Point point2 = aPRSMap.toPixel(xY);
                if (!(Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y)) < 9.0)) continue;
                if (bl) {
                    this.searchStart = stationHistory2.ID;
                    StationHistory stationHistory3 = stationHistory2;
                    Object var10_11 = null;
                    return stationHistory3;
                }
                if (stationHistory == null) {
                    stationHistory = stationHistory2;
                }
                bl = stationHistory2.ID.equals(this.searchStart);
            }
            Object var10_12 = null;
        }
        this.searchStart = stationHistory == null ? null : stationHistory.ID;
        return stationHistory;
    }

    StationLog(javAPRS javAPRS2) {
        this.theApplet = javAPRS2;
        this.setName("Log Purge");
        this.start();
    }

    String[] getHistory() {
        String[] stringArray;
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (this.stationTable.size() == 0) {
                String[] stringArray2 = null;
                Object var5_3 = null;
                return stringArray2;
            }
            stringArray = new String[this.stationTable.size()];
            Enumeration enumeration = this.stationTable.elements();
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = ((StationHistory)enumeration.nextElement()).ID;
                ++n;
            }
            Object var5_4 = null;
        }
        return stringArray;
    }

    Vector getHistory(long l) {
        long l2 = System.currentTimeMillis() - l;
        Vector<Object> vector = new Vector<Object>();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size() * 2);
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                Object object;
                StationHistory stationHistory;
                block14: {
                    block12: {
                        block13: {
                            stationHistory = (StationHistory)enumeration.nextElement();
                            if (stationHistory.lastHeard.getTime() < l2 || this.theApplet.checkFilter(stationHistory)) continue;
                            if (stationHistory.wx != null) {
                                vector.addElement(stationHistory.wx);
                                continue;
                            }
                            object = null;
                            if (stationHistory.track == null || stationHistory.position == null) break block12;
                            if (stationHistory.position.icon <= 0) break block13;
                            Vector vector2 = stationHistory.track;
                            synchronized (vector2) {
                                int n = stationHistory.track.size();
                                int n2 = 0;
                                while (n2 < n) {
                                    object = (Report)stationHistory.track.elementAt(n2);
                                    if (((Report)object).time >= l2) {
                                        vector.addElement(object);
                                    }
                                    ++n2;
                                }
                                Object var14_11 = null;
                                break block14;
                            }
                        }
                        vector.addElement(stationHistory.position);
                        break block14;
                    }
                    if (stationHistory.position != null) {
                        vector.addElement(stationHistory.position);
                    }
                }
                if (object == null || stationHistory.position == null || object.equals(stationHistory.position)) continue;
                vector.addElement(stationHistory.position);
            }
            Object var12_12 = null;
        }
        return vector;
    }

    void drawHistory(Graphics graphics, boolean bl) {
        Object var11_9;
        StationHistory stationHistory;
        APRSMap aPRSMap = this.theApplet.getMap();
        if (aPRSMap == null) {
            return;
        }
        Vector<StationHistory> vector = new Vector<StationHistory>();
        Cloneable cloneable = this.stationTable;
        synchronized (cloneable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size());
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                stationHistory = (StationHistory)enumeration.nextElement();
                if (stationHistory.position == null || this.theApplet.checkFilter(stationHistory)) continue;
                vector.addElement(stationHistory);
            }
            var11_9 = null;
        }
        int n = 0;
        while (n < vector.size()) {
            stationHistory = (StationHistory)vector.elementAt(n);
            if (stationHistory.wx != null) {
                aPRSMap.drawIcon(stationHistory.wx);
            } else {
                aPRSMap.drawIcon(stationHistory.position);
            }
            if (this.theApplet.theParams.trackStations) {
                Report report = null;
                if (bl && stationHistory.track != null) {
                    cloneable = stationHistory.track;
                    synchronized (cloneable) {
                        block15: {
                            int n2 = stationHistory.track.size();
                            if (n2 <= 1) break block15;
                            int n3 = 0;
                            while (n3 < n2) {
                                report = aPRSMap.drawTrack(report, (Report)stationHistory.track.elementAt(n3));
                                ++n3;
                            }
                        }
                        var11_9 = null;
                    }
                }
            }
            ++n;
        }
    }

    protected String strProcess(String string) {
        String string2 = string.substring(0, string.indexOf(62)) + "             ";
        return string2.substring(0, 10) + string.substring(string.indexOf(58) + 1);
    }

    StationHistory findStation(String string) {
        return (StationHistory)this.stationTable.get(string);
    }

    StationHistory findStation(Report report) {
        if (Math.round(report.position.lat) == 0L && Math.round(report.position.lon) == 0L && !report.validWX) {
            return null;
        }
        if (Math.abs(report.position.lat) >= 90.0 || Math.abs(report.position.lon) >= 180.0) {
            return null;
        }
        StationHistory stationHistory = this.findStation(report.ID);
        if (stationHistory == null) {
            if (report.killObject) {
                return null;
            }
            stationHistory = new StationHistory(this.theApplet.theParams.trackStations);
            stationHistory.ID = new String(report.ID);
            this.stationTable.put(stationHistory.ID, stationHistory);
            if (this.theApplet.theParams.showNewStations && report.icon >= 0) {
                if (this.theApplet.theParams.homeID != null) {
                    if (!this.theApplet.theParams.homeID.equals(report.ID)) {
                        StationHistory stationHistory2 = this.findStation(this.theApplet.theParams.homeID);
                        if (stationHistory2 != null) {
                            if (Report.metric) {
                                this.theApplet.showStatus("New Station: " + report.ID + " distance: " + Math.round(stationHistory2.position.position.distanceTo(report.position) * 1.609344) + " kilometers, bearing: " + Math.round(stationHistory2.position.position.bearingTo(report.position)) + "\u00b0");
                            } else {
                                this.theApplet.showStatus("New Station: " + report.ID + " distance: " + Math.round(stationHistory2.position.position.distanceTo(report.position)) + " miles, bearing: " + Math.round(stationHistory2.position.position.bearingTo(report.position)) + "\u00b0");
                            }
                        } else {
                            this.theApplet.showStatus("New Station: " + report.ID);
                        }
                    }
                } else {
                    this.theApplet.showStatus("New Station: " + report.ID);
                }
            }
        } else if (report.killObject) {
            this.stationTable.remove(report.ID);
        }
        if (this.theApplet.theParams.trackStations && report.icon > 0 && (Math.round(report.position.lat) != 0L || Math.round(report.position.lon) != 0L)) {
            if (stationHistory.track == null) {
                stationHistory.track = new Vector();
            }
            Vector vector = stationHistory.track;
            synchronized (vector) {
                block44: {
                    int n;
                    int n2 = n = stationHistory.track.size();
                    if (n2 > 0) {
                        Report report2;
                        if (this.theApplet.theParams.trackSort) {
                            report2 = (Report)stationHistory.track.lastElement();
                            while (n2 > 0 && report2.time > report.time) {
                                report2 = (Report)stationHistory.track.elementAt(--n2);
                            }
                            if (report2.position.distanceToDegrees(report.position) <= this.theApplet.theParams.minTrackDist) {
                                n2 = -100;
                            }
                            if (n2 > 0) {
                                Report report3 = (Report)stationHistory.track.elementAt(n2 - 1);
                                if (report3.position.distanceToDegrees(report.position) <= this.theApplet.theParams.minTrackDist) {
                                    n2 = -100;
                                }
                            }
                            if (n2 >= 0) {
                                if (report2.time > report.time) {
                                    if (n2 > 0) {
                                        report2 = (Report)stationHistory.track.elementAt(n2 - 1);
                                        stationHistory.track.insertElementAt(report, n2);
                                    } else {
                                        stationHistory.track.insertElementAt(report, n2);
                                    }
                                } else if (n2 >= n) {
                                    stationHistory.track.addElement(report);
                                } else {
                                    stationHistory.track.insertElementAt(report, n2 + 1);
                                }
                            }
                        } else {
                            report2 = (Report)stationHistory.track.lastElement();
                            if (report2.position.distanceToDegrees(report.position) > this.theApplet.theParams.minTrackDist) {
                                stationHistory.track.addElement(report);
                            }
                        }
                        if (this.theApplet.theParams.purgeCache > 0L) {
                            long l = System.currentTimeMillis() - this.theApplet.theParams.purgeCache;
                            int n3 = stationHistory.track.size();
                            int n4 = 0;
                            while (n4 < n3) {
                                Report report4 = (Report)stationHistory.track.elementAt(n4);
                                if (report4.time < l) {
                                    stationHistory.track.removeElementAt(n4);
                                    --n4;
                                    --n3;
                                }
                                ++n4;
                            }
                        }
                    } else {
                        stationHistory.track.addElement(report);
                    }
                    if (stationHistory.track.size() <= 1) break block44;
                    APRSMap aPRSMap = this.theApplet.getMap();
                    aPRSMap.drawTrack((Report)stationHistory.track.elementAt(stationHistory.track.size() - 2), (Report)stationHistory.track.lastElement());
                }
                Object var11_14 = null;
            }
        }
        stationHistory.lastHeard.setTime(System.currentTimeMillis());
        ++stationHistory.count;
        if (report.validWX) {
            if (Math.round(report.position.lat) != 0L || Math.round(report.position.lon) != 0L) {
                if (stationHistory.position == null) {
                    stationHistory.position = report;
                } else {
                    stationHistory.position.position = report.position;
                }
            }
            stationHistory.wx = report;
        } else {
            stationHistory.position = report;
        }
        if (stationHistory.wx != null && stationHistory.position != null) {
            stationHistory.wx.position = stationHistory.position.position;
            stationHistory.wx.icon = stationHistory.position.icon;
            stationHistory.wx.altIcons = stationHistory.position.altIcons;
            stationHistory.wx.overlay = stationHistory.position.overlay;
        }
        return stationHistory;
    }

    void dumpData() {
        Vector vector = new Vector();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size());
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Object var5_5 = null;
        }
        if (!vector.isEmpty()) {
            this.theApplet.theSystem.println("*********Station List (" + this.stationTable.size() + " stations)*****************************", false);
            int n = 0;
            while (n < vector.size()) {
                Thread.yield();
                StationHistory stationHistory = (StationHistory)vector.elementAt(n);
                if (this.theApplet.theParams.showStatusRaw) {
                    if (stationHistory.wx != null) {
                        this.theApplet.theSystem.println(new String(stationHistory.wx.theData), false);
                    } else {
                        this.theApplet.theSystem.println(new String(stationHistory.position.theData), false);
                    }
                } else if (stationHistory.wx != null) {
                    this.theApplet.theSystem.println(stationHistory.wx.toString(), false);
                } else {
                    this.theApplet.theSystem.println(stationHistory.position.toString(), false);
                }
                ++n;
            }
            this.theApplet.theSystem.println("***********************************************************", true);
        }
    }

    void wxData() {
        StationHistory stationHistory;
        Vector<StationHistory> vector = new Vector<StationHistory>();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size());
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                stationHistory = (StationHistory)enumeration.nextElement();
                if (stationHistory.wx == null) continue;
                vector.addElement(stationHistory);
            }
            Object var5_6 = null;
        }
        if (!vector.isEmpty()) {
            this.theApplet.theSystem.println("********Weather List*************************", false);
            int n = 0;
            while (n < vector.size()) {
                Thread.yield();
                stationHistory = (StationHistory)vector.elementAt(n);
                this.theApplet.theSystem.println(stationHistory.wx.toWxString(), false);
                ++n;
            }
            this.theApplet.theSystem.println("*********************************************", true);
        }
    }

    void dumpBeacon() {
        StationHistory stationHistory;
        Vector<StationHistory> vector = new Vector<StationHistory>();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size());
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                stationHistory = (StationHistory)enumeration.nextElement();
                if (stationHistory.stringBeacon == null) continue;
                vector.addElement(stationHistory);
            }
            Object var5_6 = null;
        }
        if (!vector.isEmpty()) {
            this.theApplet.theSystem.println("********Status List***********************************", false);
            int n = 0;
            while (n < vector.size()) {
                Thread.yield();
                stationHistory = (StationHistory)vector.elementAt(n);
                this.theApplet.theSystem.println(this.strProcess(stationHistory.stringBeacon), false);
                ++n;
            }
            this.theApplet.theSystem.println("*********************************************************", true);
        }
    }

    void dumpID() {
        StationHistory stationHistory;
        Vector<StationHistory> vector = new Vector<StationHistory>();
        Hashtable hashtable = this.stationTable;
        synchronized (hashtable) {
            if (!this.stationTable.isEmpty()) {
                vector.ensureCapacity(this.stationTable.size());
            }
            Enumeration enumeration = this.stationTable.elements();
            while (enumeration.hasMoreElements()) {
                stationHistory = (StationHistory)enumeration.nextElement();
                if (stationHistory.stringID == null) continue;
                vector.addElement(stationHistory);
            }
            Object var5_6 = null;
        }
        if (!vector.isEmpty()) {
            this.theApplet.theSystem.println("*********ID List****************************************", false);
            int n = 0;
            while (n < vector.size()) {
                Thread.yield();
                stationHistory = (StationHistory)vector.elementAt(n);
                this.theApplet.theSystem.println(this.strProcess(stationHistory.stringID), false);
                ++n;
            }
            this.theApplet.theSystem.println("*********************************************************", true);
        }
    }

    public void run() {
        if (this.theApplet.theParams.purgeCache == 0L) {
            return;
        }
        while (true) {
            long l;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.yield();
            }
            if ((l = System.currentTimeMillis()) < this.prevpurge + 60000L) continue;
            this.prevpurge = l;
            l -= this.theApplet.theParams.purgeCache;
            Vector<String> vector = new Vector<String>();
            Hashtable hashtable = this.stationTable;
            synchronized (hashtable) {
                if (!this.stationTable.isEmpty()) {
                    vector.ensureCapacity(this.stationTable.size());
                }
                Enumeration<Object> enumeration = this.stationTable.elements();
                while (enumeration.hasMoreElements()) {
                    StationHistory stationHistory = (StationHistory)enumeration.nextElement();
                    if (stationHistory.lastHeard.getTime() >= l) continue;
                    vector.addElement(stationHistory.ID);
                }
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.stationTable.remove(enumeration.nextElement());
                }
                Object var7_6 = null;
            }
            if (vector.isEmpty()) continue;
            this.theApplet.getMap().repaint();
        }
    }
}

