/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Vector;

class StationHistory {
    protected String ID;
    protected Report position = null;
    protected Report wx = null;
    protected Vector track = null;
    protected int count = 0;
    protected String stringID = null;
    protected String stringBeacon = null;
    String heardVia = null;
    Date lastHeard = new Date();

    StationHistory(boolean bl) {
        if (bl) {
            this.track = new Vector();
            return;
        }
        this.track = null;
    }

    void dumpAll(ConsolePrint consolePrint, boolean bl) {
        consolePrint.println(" ", false);
        consolePrint.println("Full data for " + this.ID + " (heard via " + this.heardVia + " at " + this.lastHeard + ")", false);
        if (this.stringBeacon != null) {
            consolePrint.println("Beacon:", false);
            consolePrint.println("   " + this.stringBeacon, false);
        }
        if (this.stringID != null) {
            consolePrint.println("ID:", false);
            consolePrint.println("   " + this.stringID, false);
        }
        if (this.position != null) {
            consolePrint.println("Position:", false);
            if (bl) {
                consolePrint.println("   " + new String(this.position.theData), false);
            }
            consolePrint.println("   " + this.position.toString(), false);
        }
        if (this.wx != null) {
            consolePrint.println("Weather:", false);
            if (bl) {
                consolePrint.println("   " + new String(this.wx.theData), false);
            }
            consolePrint.println("   " + this.wx.toString(), false);
        }
        if (this.track != null && this.track.size() > 1) {
            consolePrint.println("Tracking data: ", false);
            int n = this.track.size();
            if (n > 1) {
                int n2 = 0;
                while (n2 < n) {
                    Report report = (Report)this.track.elementAt(n2++);
                    if (bl) {
                        consolePrint.println("   " + new String(report.theData), false);
                    }
                    consolePrint.println("   " + report.toString(), false);
                }
            }
        }
        consolePrint.println("", true);
    }
}

