/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;

class Report {
    static boolean metric = false;
    int icon = 0;
    int overlay = 0;
    LatLon position;
    int course = 0;
    int speed = 0;
    int altitude = -99999;
    int power = -1;
    int height = -1;
    int gain = -1;
    int directivity = -1;
    int range = -1;
    int strength = -1;
    int bearing = -1;
    int number = -1;
    int quality = -1;
    String toField = "";
    String signpost = "";
    int corridor = 0;
    int comments = -1;
    double pressure = 0.0;
    int message = -1;
    int temperature = -999;
    int intTemp = -999;
    int humidity = -999;
    int gust = 0;
    int suswind = 0;
    int rrain = 0;
    int prain = 0;
    int pprain = 0;
    long time = System.currentTimeMillis();
    int gfw = 0;
    int sfw = 0;
    int hfw = 0;
    long offsetUTC = 9999L;
    boolean altIcons = false;
    String ID = "";
    byte[] theData = null;
    String reportType = "nul";
    String protoString = null;
    String systemString = null;
    String bandString = null;
    boolean validWX = false;
    boolean killObject = false;

    public String toString() {
        if (this.validWX) {
            return this.toWxString();
        }
        String string = (this.ID + "          ").substring(0, 9);
        if (this.position.lat != 0.0 || this.position.lon != 0.0) {
            string = string + " " + this.position.toString();
        }
        if (this.reportType.equals("HC ") || this.reportType.equals("TY ") || this.reportType.equals("TC ") || this.reportType.equals("TS ") || this.reportType.equals("TD ")) {
            string = string + " " + this.reportType.trim();
            double d = 1.150779;
            if (metric) {
                d = 1.852;
            }
            if (this.course > 0) {
                string = metric ? string + " heading " + this.course + "\u00b0 @ " + Math.round((double)this.speed * 1.852) + " KPH" : string + " heading " + this.course + "\u00b0 @ " + Math.round((double)this.speed * 1.150779) + " MPH";
            }
            if (this.gust > 0) {
                string = string + " gusts " + Math.round((double)this.gust * d);
            }
            if (this.suswind > 0) {
                string = string + " sus. wind " + Math.round((double)this.suswind * d);
            }
            if (this.hfw > 0) {
                string = string + " hfw " + Math.round((double)this.hfw * d);
            }
            if (this.sfw > 0) {
                string = string + " sfw " + Math.round((double)this.sfw * d);
            }
            if (this.gfw > 0) {
                string = string + " gfw " + Math.round((double)this.gfw * d);
            }
            if (this.pressure > 0.0) {
                string = this.pressure > 100.0 ? string + " Pres " + this.pressure + "mb" : string + " Pres " + (this.pressure + 1000.0) + "mb";
            }
        } else {
            if (!this.reportType.equals("Object") && !this.reportType.equals("Item") || !this.altIcons || this.icon + 32 != 108) {
                if (this.course > 0) {
                    string = metric ? string + " course " + this.course + "\u00b0 speed " + Math.round((double)this.speed * 1.852) + " KPH" : string + " course " + this.course + "\u00b0 speed " + Math.round((double)this.speed * 1.150779) + " MPH";
                    if (this.number > 0) {
                        string = metric ? string + " bearing=" + this.bearing + "\u00b0 N=" + this.number + " Range=" + Math.round(Math.pow(2.0, this.range) * 1.609344) + "km Q=" + this.quality : string + " bearing=" + this.bearing + "\u00b0 N=" + this.number + " Range=" + Math.round(Math.pow(2.0, this.range)) + "mi Q=" + this.quality;
                    }
                } else if (this.power >= 0) {
                    string = metric ? string + " Power=" + this.power * this.power + "w haat=" + Math.round(10.0 * Math.pow(2.0, this.height) * 0.3048) + "m Gain=" + Math.round(Math.pow(10.0, (double)this.gain / 10.0)) + "db Dir=" + this.directivity + "\u00b0 Range=" + Math.round((double)this.range * 1.609344) + "km" : string + " Power=" + this.power * this.power + "w haat=" + Math.round(10.0 * Math.pow(2.0, this.height)) + "' Gain=" + Math.round(Math.pow(10.0, (double)this.gain / 10.0)) + "db Dir=" + this.directivity + "\u00b0 Range=" + this.range + "mi";
                } else if (this.strength >= 0) {
                    string = metric ? string + " Strength=" + this.strength + " haat=" + Math.round(10.0 * Math.pow(2.0, this.height) * 0.3048) + "m Gain=" + Math.round(Math.pow(10.0, (double)this.gain / 10.0)) + "db Dir=" + this.directivity + "\u00b0" : string + " Strength=" + this.strength + " haat=" + Math.round(10.0 * Math.pow(2.0, this.height)) + "' Gain=" + Math.round(Math.pow(10.0, (double)this.gain / 10.0)) + "db Dir=" + this.directivity + "\u00b0";
                } else if (this.range >= 0) {
                    string = metric ? string + " Range=" + Math.round((double)this.range * 1.609344) + "km" : string + " Range=" + this.range + "mi";
                }
            }
            if (this.altitude > -99999) {
                string = metric ? string + " alt " + Math.round((double)this.altitude * 0.3048) + "m" : string + " alt " + this.altitude + "'";
            }
            if (this.comments >= 0) {
                string = string + " " + new String(this.theData, this.comments, this.theData.length - this.comments);
            }
        }
        return string;
    }

    Report() {
        this.position = new LatLon();
    }

    private String numToString(int n, int n2) {
        String string = "      " + n;
        return string.substring(string.length() - n2);
    }

    private String numToString(double d, int n) {
        String string = "      " + (int)d;
        return string.substring(string.length() - n);
    }

    void setTime(boolean bl, long l) {
        this.time = l;
        if (bl) {
            this.offsetUTC = new Date(l).getTimezoneOffset() * 60000;
        }
    }

    private String numToString(double d, int n, int n2) {
        d *= Math.pow(10.0, n2);
        d = (int)d;
        String string = "      " + (d /= Math.pow(10.0, n2));
        int n3 = string.indexOf(46);
        string = n3 > 0 ? string + "00000" : string + ".00000";
        n3 = string.indexOf(46);
        string = string.substring(0, n3 + n2 + 1);
        return string.substring(string.length() - n);
    }

    String toWxString() {
        String string = (this.ID + "          ").substring(0, 9);
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(2);
        if (this.validWX) {
            if (this.course > 0) {
                string = metric ? string + " Wind " + Math.round((double)this.speed * 1.609344) + " KPH @ " + this.course + "\u00b0" : string + " Wind " + this.speed + " MPH @ " + this.course + "\u00b0";
            }
            if (this.gust > 0) {
                string = metric ? string + " gust " + Math.round((double)this.gust * 1.609344) : string + " gust " + this.gust;
            }
            if (this.temperature > -100) {
                string = metric ? string + " Temp " + Math.round(((double)this.temperature - 32.0) / 1.8) + "\u00b0C" : string + " Temp " + this.temperature + "\u00b0F";
            }
            if (this.pprain > 0) {
                string = metric ? string + " rain since MN " + decimalFormat.format((double)this.pprain * 25.4 / 100.0) + "mm" : string + " rain since MN " + decimalFormat.format((double)this.pprain / 100.0) + "\"";
            }
            if (this.prain > 0) {
                string = metric ? string + " 24h rain " + decimalFormat.format((double)this.prain * 25.4 / 100.0) + "mm" : string + " 24h rain " + decimalFormat.format((double)this.prain / 100.0) + "\"";
            }
            if (this.rrain > 0) {
                string = metric ? string + " 1h rain " + decimalFormat.format((double)this.rrain * 25.4 / 100.0) + "mm" : string + " 1h rain " + decimalFormat.format((double)this.rrain / 100.0) + "\"";
            }
            if (this.pressure > 0.0) {
                string = this.pressure > 100.0 ? string + " Pres " + this.pressure : string + " Pres " + (this.pressure + 1000.0);
                string = string + "mb";
            }
            if (this.humidity > 0) {
                string = string + " humd " + this.humidity + "%";
            }
            return string;
        }
        return "";
    }

    private String dateString(long l) {
        Date date = new Date(l);
        if (this.offsetUTC == 999L) {
            return this.int2(date.getMonth() + 1) + "/" + this.int2(date.getDate()) + "/" + this.int2((date.getYear() + 1900) % 100) + " " + this.int2(date.getHours()) + ":" + this.int2(date.getMinutes()) + "z";
        }
        date.setTime(date.getTime() - this.offsetUTC);
        return this.int2(date.getMonth() + 1) + "/" + this.int2(date.getDate()) + "/" + this.int2((date.getYear() + 1900) % 100) + " " + this.int2(date.getHours()) + ":" + this.int2(date.getMinutes());
    }

    private String int2(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return decimalFormat.format(n);
    }

    String toString1() {
        String string = this.toString();
        return string;
    }
}

