/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

abstract class Parser
extends Thread {
    javAPRS theApplet = null;
    String theFileName = null;
    BufferedInputStream theFile = null;
    private boolean restart = false;
    int reload = 0;
    long lastUpdated = System.currentTimeMillis() + 86400000L;
    boolean firstError = true;
    byte[] tbuffer = new byte[512];
    int tbufferi = 0;

    protected int myParseInt(String string) {
        int n = 0;
        int n2 = 0;
        if (!this.isNum(string.charAt(0))) {
            ++n2;
        }
        if (!this.isNum(string.charAt(1))) {
            ++n2;
        }
        if (!this.isNum(string.charAt(2)) && n2 == 2) {
            return 0;
        }
        n = n2;
        try {
            while (this.isNum(string.charAt(n))) {
                ++n;
            }
        }
        catch (Exception exception) {}
        try {
            return Integer.parseInt(string.substring(n2, n));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void plotReport(Report report) {
        if (this.theApplet.getMap() != null) {
            Report report2 = report;
            try {
                StationHistory stationHistory = this.theApplet.theLog.findStation(report);
                if (stationHistory != null) {
                    stationHistory.heardVia = this.theFileName;
                    if (stationHistory.wx != null) {
                        report2 = stationHistory.wx;
                    }
                    if (report2.icon >= 0) {
                        this.theApplet.getMap().drawIcon(report2);
                        return;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    Parser() {
    }

    protected double convertNMEA(String string) {
        double d = 0.0;
        int n = string.indexOf(46);
        try {
            if (n > 3 || n < 0) {
                if (n > 3) {
                    d = Double.valueOf(string.substring(0, n - 2));
                    d += Double.valueOf(string.substring(n - 2)) / 60.0;
                } else {
                    d = Double.valueOf(string.substring(0, string.length() - 2));
                    d += Double.valueOf(string.substring(string.length() - 2)) / 60.0;
                }
            } else {
                d = Double.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    protected double convertNMEA(double d) {
        int n = (int)(d /= 100.0);
        d -= (double)n;
        d *= 100.0;
        return (d /= 60.0) + (double)n;
    }

    protected byte[] readLine() throws IOException {
        int n = this.theFile.read();
        while (n >= 0) {
            if (n == 10 || n == 13) {
                if (this.tbufferi > 0) {
                    if (this.tbufferi < this.tbuffer.length) {
                        byte[] byArray = new byte[this.tbufferi];
                        System.arraycopy(this.tbuffer, 0, byArray, 0, this.tbufferi);
                        this.tbufferi = 0;
                        return byArray;
                    }
                    this.tbufferi = 0;
                }
            } else if (n != 0 && this.tbufferi < this.tbuffer.length) {
                this.tbuffer[this.tbufferi++] = (byte)n;
            }
            n = this.theFile.read();
        }
        this.tbufferi = 0;
        return null;
    }

    protected boolean isNum(char c) {
        if (c == '-') {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    protected BufferedInputStream openDataStream(String string) {
        URL uRL = null;
        BufferedInputStream bufferedInputStream = null;
        if (string.indexOf("://") > 0) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.theApplet.theSystem.println("File name error");
            }
        } else {
            try {
                uRL = new URL(this.theApplet.getCodeBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                this.theApplet.theSystem.println("File name error");
            }
        }
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            this.theApplet.theSystem.println(iOException.toString());
            bufferedInputStream = null;
        }
        if (bufferedInputStream == null && this.firstError) {
            this.theApplet.showStatus("Error opening data file:" + string);
            this.theApplet.theSystem.println("Error opening data file:" + uRL);
            this.firstError = false;
        }
        return bufferedInputStream;
    }

    protected void finalize() throws IOException {
        if (this.theFile != null) {
            ((FilterInputStream)this.theFile).close();
        }
        this.theFile = null;
    }

    abstract Report doParse(byte[] var1);

    synchronized void restartParser() {
        if (!this.restart) {
            this.restart = true;
            this.notifyAll();
        }
    }

    public void run() {
        if (this.theFileName.length() <= 1) {
            return;
        }
        try {
            while (true) {
                this.theFile = this.openDataStream(this.theFileName);
                if (this.theFile == null) {
                    this.restartParser();
                }
                boolean bl = true;
                while (!this.restart && bl) {
                    byte[] byArray = null;
                    try {
                        Thread.yield();
                        byArray = this.readLine();
                        if (byArray == null) {
                            bl = false;
                            continue;
                        }
                        this.lastUpdated = System.currentTimeMillis();
                        if (this instanceof NETparser) {
                            if (this.theApplet.pauseMap.waitIf(true, 30000L)) {
                                this.theApplet.pauseMap.setValueAndReleaseAll(false);
                            }
                        } else {
                            this.theApplet.pauseMap.waitIf(true);
                        }
                        if (this.restart || byArray.length <= 10) continue;
                        Report report = null;
                        try {
                            report = this.doParse(byArray);
                        }
                        catch (Exception exception) {
                            report = null;
                            this.theApplet.theSystem.println("Parse Error: " + exception);
                            this.theApplet.theSystem.println(new String(byArray));
                        }
                        if (report != null) {
                            try {
                                this.plotReport(report);
                            }
                            catch (Exception exception) {
                                this.theApplet.theSystem.println("Parser.plotReport: " + exception);
                                this.theApplet.theSystem.println(report.toString());
                            }
                        }
                        if (this.theApplet.theParams.sleep > 0) {
                            try {
                                Thread.sleep(this.theApplet.theParams.sleep);
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.yield();
                            }
                        }
                        if (this.theApplet.theParams.echoDataStatus) {
                            this.theApplet.showStatus(new String(byArray));
                        }
                        if (!this.theApplet.theParams.echoDataConsole) continue;
                        this.theApplet.theSystem.println(new String(byArray));
                    }
                    catch (IOException iOException) {
                        this.theApplet.theSystem.println("Parser.run: " + iOException);
                        if (byArray != null) {
                            this.theApplet.theSystem.println(byArray.toString());
                        }
                        this.restartParser();
                    }
                }
                this.lastUpdated += 86400000L;
                try {
                    ((FilterInputStream)this.theFile).close();
                }
                catch (Exception exception) {}
                if (this.theApplet.theParams.systemList != null) {
                    this.theApplet.theSystem.println("Total listings: " + this.theApplet.theLog.stationTable.size());
                }
                if (this.reload == 0 && this.theApplet.theParams.stationList && !(this instanceof NETparser)) {
                    return;
                }
                if (this.theFile == null) {
                    this.waitForRestart(5000L);
                    continue;
                }
                this.theFile = null;
                this.waitForRestart((long)this.reload * 1000L);
            }
        }
        catch (ThreadDeath threadDeath) {
            if (this.theFile != null) {
                try {
                    ((FilterInputStream)this.theFile).close();
                }
                catch (Exception exception) {}
                this.theFile = null;
            }
            throw threadDeath;
        }
    }

    protected LatLon grid2LL(String string) {
        if (string.length() != 4 || string.length() != 6) {
            return null;
        }
        if (!(Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1)) && Character.isDigit(string.charAt(2)) && Character.isDigit(string.charAt(3)))) {
            return null;
        }
        double d = 180 - 20 * ('\u0001' + string.charAt(0) - 65);
        double d2 = 10 * (string.charAt(1) - 74);
        d += (double)(20 - ('\u0001' + string.charAt(2) - 48) * 2);
        d2 += (double)(string.charAt(3) - 48);
        if (string.length() == 6) {
            if (!Character.isUpperCase(string.charAt(4)) || !Character.isUpperCase(string.charAt(5))) {
                return null;
            }
            d += (24.0 - (double)(string.charAt(4) - 65)) / 12.0;
            d2 += (double)(string.charAt(5) - 65) / 24.0;
        }
        return new LatLon(d2, -d);
    }

    protected int fromHex(char c) throws IllegalArgumentException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 65;
        }
        throw new IllegalArgumentException();
    }

    protected int fromHex(String string) throws IllegalArgumentException {
        int n = string.length();
        int n2 = 1;
        int n3 = 0;
        while (n > 0) {
            n3 += this.fromHex(string.charAt(n - 1)) * n2;
            n2 *= 16;
            --n;
        }
        return n3;
    }

    synchronized void waitForRestart(long l) {
        if (!this.restart) {
            if (l == 0L) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.restart = false;
    }
}

