/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

class Parameters {
    javAPRS theApplet;
    String dosMap;
    String gifMap;
    String shapeFile;
    Color shapeColor = Color.gray;
    OrderedHashTable mapList = new OrderedHashTable();
    String mapListFile;
    String systemList;
    String protoList;
    String tigerMapRelay;
    String blastMapRelay;
    String iconFile;
    String bandList;
    Hashtable displayOnly = new Hashtable();
    String digiOnly;
    Hashtable dontDisplay = new Hashtable();
    String mapProjection;
    long autoMapReload;
    long autoMapRedraw;
    int autoDisplayID;
    boolean sendLogin = true;
    long purgeCache;
    long startDate;
    int nFiles;
    int[] fileReload;
    String[] dataFile;
    long[] cacheTime;
    String homeID;
    double scale = 1.0;
    double gifMapLeft;
    double gifMapTop;
    double gifMapRight;
    double gifMapBottom;
    double gifMapPPDh;
    double gifMapPPDv;
    LatLon gifScrCtrLL = new LatLon(Double.NaN, Double.NaN);
    LatLon mapCenter = new LatLon(Double.NaN, Double.NaN);
    double expediaMapWide;
    double tigerMapLeft;
    double tigerMapTop;
    double tigerMapHigh;
    double blastMapLeft;
    double blastMapTop;
    double blastMapHigh;
    double gifMapHigh;
    double offsetX;
    double offsetY;
    int sleep;
    double iconScale = 1.0;
    boolean mapTrack;
    boolean userTime;
    boolean autoScale = true;
    boolean autoFit;
    boolean stationList = true;
    boolean drawVectors = true;
    boolean drawCircles;
    boolean trackStations = true;
    boolean trackSort;
    double minTrackDist = 3.333333333333333E-4;
    boolean echoDataConsole;
    boolean echoDataStatus;
    boolean showNewStations = true;
    boolean showHurricaneRadius = true;
    boolean showStationNames = true;
    boolean showMapLabels = true;
    boolean showStatusRaw;
    boolean showAllMapLabels;
    boolean pickBackground;
    boolean useAPRStime = true;
    boolean displayLocalTime = true;
    boolean copyrightTop = true;
    boolean displayWxOnly;
    Color backgroundColor = Color.lightGray;
    Color backgroundColorOrig = Color.lightGray;
    Color foregroundColor = Color.black;
    Color labelColor = Color.blue;
    Color titleColor = Color.red;
    Color plotColor = Color.red;
    Color highlightColor = Color.yellow;
    String displayIcons;
    String displayAltIcons;

    private int get(String string, int n) {
        Integer n2;
        String string2 = this.theApplet.getParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            n2 = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n2;
    }

    private long get(String string, long l) {
        Long l2;
        String string2 = this.theApplet.getParameter(string);
        if (string2 == null) {
            return l;
        }
        try {
            l2 = Long.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
        return l2;
    }

    private double get(String string, double d) {
        Double d2;
        String string2 = this.theApplet.getParameter(string);
        if (string2 == null) {
            return d;
        }
        try {
            d2 = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
        return d2;
    }

    private boolean get(String string, boolean bl) {
        Boolean bl2;
        String string2 = this.theApplet.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        try {
            bl2 = Boolean.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
        return bl2;
    }

    private String get(String string, String string2) {
        String string3 = this.theApplet.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    Parameters(javAPRS javAPRS2) {
        this.theApplet = javAPRS2;
        this.loadParams();
    }

    private String get(String string) {
        return this.theApplet.getParameter(string);
    }

    String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"dosMap", "String", "Filename of Dos APRS map"}, {"offsetX", "integer", "inital horizontal scroll of map"}, {"offsetY", "integer", "inital vertical scroll of map"}, {"scale", "double", "Initial scale of map"}, {"autoScale", "boolean", "Automatically scale map"}, {"autoFit", "boolean", "Fit map to screen"}, {"showMapLabels", "boolean", "Display map labels appropriate to scale"}, {"showAllMapLabels", "boolean", "Display all map labels regardless of scale"}, {"mapCenterLat", "double", "Center latitude of map"}, {"mapCenterLon", "double", "Center longitude of map"}, {"screenCenterLat", "double", "Center latitude of screen"}, {"screenCenterLon", "double", "Center longitude of screen"}, {"shapeMap", "String", "Filename of ShapeFile"}, {"shapeColor", "integer", "Color of ShapeFile lines"}, {"gifMap", "String", "Filename of GIF map"}, {"gifMapTop", "double", "Northern latitude of GIF map"}, {"gifMapBottom", "double", "Southern latitude of GIF map"}, {"gifMapLeft", "double", "Western longitude of GIF map"}, {"gifMapRight", "double", "Eastern longitude of GIF map"}, {"gifMapPPDh", "double", "Pixels per degree wide"}, {"gifMapPPDv", "double", "Pixels per degree high"}, {"gifMapHigh", "double", "Degrees high"}, {"mapProjection", "String", "Name of map projection GIF created in"}, {"tigerMapRelay", "String", "Address of Tiger map source"}, {"tigerMapTop", "double", "Northern latitude of Tiger map"}, {"tigerMapLeft", "double", "Western longitude of Tiger map"}, {"tigerMapHigh", "double", "Height in degrees of Tiger map"}, {"blastMapRelay", "String", "Address of MapBlast map source"}, {"blastMapTop", "double", "Northern latitude of MapBlast map"}, {"blastMapLeft", "double", "Western longitude of MapBlast map"}, {"blastMapHigh", "double", "Height in degrees of MapBlast map"}, {"expediaMapWide", "double", "Width in degrees of Expedia map"}, {"mapList", "String", "Map selection list"}, {"mapListFile", "String", "File containing map selection list"}, {"dataFile1", "String", "Name of first data file"}, {"dataFile2", "String", "Name of 2nd data file, etc"}, {"dataFile3", "String", "Supported extensions: .hst, .tnc, .nmea"}, {"fileReload1", "String", "Interval in seconds that file will reload"}, {"fileReload2", "String", "separate interval for each dataFile"}, {"sleep", "integer", "Milliseconds to sleep following each plot"}, {"cacheTime1", "integer", "Time in past to send at client connect"}, {"cacheTime2", "integer", "separate for each server port"}, {"purgeCache", "integer", "Time to hold position reports"}, {"autoMapReload", "integer", "Time between map reloads"}, {"autoMapRedraw", "integer", "Time map redraws"}, {"copyrightTop", "boolean", "Shows copyright notice at top of map"}, {"stationList", "boolean", "Save station positions, on redraw plot from memory"}, {"useAPRStime", "boolean", "Use time in packet if available"}, {"displayLocaltime", "boolean", "Display local time (not UTC)"}, {"iconFile", "String", "Primary icon GIF"}, {"trackStations", "boolean", "Save station tracks, plot on redraw"}, {"trackSort", "boolean", "Sort tracks by time"}, {"drawVectors", "boolean", "Draw course and speed vectors"}, {"showHuricaneRadius", "boolean", "Draw wind circles on Tropical objects"}, {"showStationNames", "boolean", "Draw station names next to icons"}, {"autoDisplayID", "double", "Don't display station names unless this close (PPD)"}, {"showNewStations", "boolean", "Displays new stations heard in status bar"}, {"echoDataConsole", "boolean", "Displays incoming data to Java Console"}, {"echoDataStatus", "boolean", "Displays incoming data to status bar"}, {"showStatusRaw", "boolean", "Displays all incoming data to Java Console"}, {"homeID", "String", "Callsign of station to anchor bearing/distance calculation"}, {"sendLogin", "boolean", "Send server login"}, {"displayOnly", "String", "Display only stations in this list"}, {"digiOnly", "String", "Display only stations with this in the packet"}, {"dontDisplay", "String", "Don't display stations in this list"}, {"displayWxOnly", "String", "Display only weather stations"}, {"displayIcons", "String", "Display only these icons"}, {"displayAltIcons", "String", "Display only these alternate icons"}, {"metric", "boolean", "Use Metric units"}, {"pickBackgroundColor", "boolean", "Display background selection list"}, {"backgroundColor", "String", "gray,black, or white"}, {"foregroundColor", "integer", "Text color"}, {"labelColor", "integer", "Label color"}, {"titleColor", "integer", "Title color"}, {"plotColor", "integer", "Vector plot color"}};
        return stringArray;
    }

    private String loadMapListFile() {
        URL uRL = null;
        DataInputStream dataInputStream = null;
        String string = "";
        try {
            uRL = new URL(this.theApplet.getCodeBase(), "maps/" + this.mapListFile);
        }
        catch (MalformedURLException malformedURLException) {
            this.theApplet.theSystem.println("File name error: " + this.mapListFile);
        }
        try {
            dataInputStream = new DataInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            dataInputStream = null;
        }
        if (dataInputStream == null) {
            this.theApplet.showStatus("Error opening mapList file: " + this.mapListFile);
            this.theApplet.theSystem.println("Error opening mapList file: " + this.mapListFile);
        } else {
            try {
                String string2 = dataInputStream.readLine();
                while (string2 != null) {
                    string = string + string2 + '$';
                    string2 = dataInputStream.readLine();
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private void loadParams() {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer;
        String string = this.get("serverCommand", "");
        this.theApplet.loginString = string.length() > 0 ? this.theApplet.loginString + " " + string + "\r\n" : this.theApplet.loginString + "\r\n";
        this.dosMap = this.get("dosMap", this.dosMap);
        String string2 = this.get("gifMap");
        if (string2 != null) {
            this.gifMap = string2;
            this.dosMap = null;
        }
        if ((string2 = this.get("shapeMap")) != null) {
            this.gifMap = null;
            this.dosMap = null;
            this.shapeFile = string2;
        }
        String string3 = this.get("mapList");
        this.mapListFile = this.get("mapListFile");
        if (this.mapListFile != null) {
            string3 = this.loadMapListFile();
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, "^$", true);
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                object = "";
                String string4 = "";
                if (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                }
                if (string4.equals("^")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                        if (((String)object).equals("$")) {
                            object = object2;
                        } else if (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                        }
                    } else {
                        object = object2;
                    }
                } else {
                    object = object2;
                }
                this.mapList.put((String)object, (String)object2);
            }
        }
        this.systemList = this.get("systemList");
        this.protoList = this.get("protoList");
        this.iconFile = this.get("iconFile");
        this.bandList = this.get("bandList");
        string2 = this.get("displayOnly");
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.length() <= 0) continue;
                this.displayOnly.put(new String(string2), string2);
            }
        }
        this.digiOnly = this.get("digiOnly");
        string2 = this.get("dontDisplay");
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, "/");
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.length() <= 0) continue;
                this.dontDisplay.put(new String(string2), string2);
            }
        }
        this.displayIcons = this.get("displayIcons");
        this.displayAltIcons = this.get("displayAltIcons");
        string2 = " ";
        this.nFiles = -1;
        while (string2 != null) {
            ++this.nFiles;
            string2 = this.get("dataFile" + (this.nFiles + 1));
        }
        if (this.nFiles > 0) {
            this.dataFile = new String[this.nFiles];
            this.fileReload = new int[this.nFiles];
            this.cacheTime = new long[this.nFiles];
            int n = 0;
            while (n < this.nFiles) {
                this.dataFile[n] = this.get("dataFile" + (n + 1));
                this.fileReload[n] = this.get("fileReload" + (n + 1), 0);
                this.cacheTime[n] = this.get("cacheTime" + (n + 1), 0L) * 60000L;
                ++n;
            }
        }
        this.purgeCache = this.get("purgeCache", 0L) * 60000L;
        this.homeID = this.get("homeID");
        this.mapTrack = this.get("trackMap", false);
        this.tigerMapRelay = this.get("tigerMapRelay");
        this.blastMapRelay = this.get("blastMapRelay");
        this.iconScale = this.get("iconScale", 1.0);
        this.scale = this.get("scale", -1.0);
        if (this.scale == -1.0) {
            this.scale = 1.0;
            this.autoScale = true;
        } else {
            this.autoScale = false;
        }
        this.mapCenter.lat = this.get("mapCenterLat", Double.NaN);
        this.mapCenter.lon = -this.get("mapCenterLon", Double.NaN);
        this.tigerMapTop = this.get("tigerMapTop", Double.NaN);
        this.tigerMapLeft = -this.get("tigerMapLeft", Double.NaN);
        this.tigerMapHigh = this.get("tigerMapHigh", 0.0);
        this.blastMapTop = this.get("blastMapTop", Double.NaN);
        this.blastMapLeft = -this.get("blastMapLeft", Double.NaN);
        this.blastMapHigh = this.get("blastMapHigh", 0.0);
        this.expediaMapWide = this.get("expediaMapWide", 0.0);
        this.gifMapTop = this.get("gifMapTop", Double.NaN);
        this.gifMapLeft = -this.get("gifMapLeft", Double.NaN);
        this.gifMapBottom = this.get("gifMapBottom", Double.NaN);
        this.gifMapRight = -this.get("gifMapRight", Double.NaN);
        this.gifMapPPDh = this.get("gifMapPPDh", 0.0);
        this.gifMapPPDv = this.get("gifMapPPDv", 0.0);
        this.gifMapHigh = this.get("gifMapHigh", 0.0);
        this.gifScrCtrLL.lat = this.get("screenCenterLat", Double.NaN);
        this.gifScrCtrLL.lon = -this.get("screenCenterLon", Double.NaN);
        this.mapProjection = this.get("mapProjection", "latlon");
        this.offsetX = -this.get("offsetX", 0.0);
        this.offsetY = -this.get("offsetY", 0.0);
        this.autoScale = this.get("autoScale", true);
        this.autoFit = this.get("autoFit", false);
        Report.metric = this.get("metric", false);
        this.pickBackground = this.get("pickBackground", false);
        this.stationList = this.get("stationList", true);
        this.trackStations = this.get("trackStations", true);
        this.trackSort = this.get("trackSort", false);
        this.minTrackDist = this.get("minTrackDist", 0.02) / 60.0;
        this.echoDataConsole = this.get("echoDataConsole", false);
        this.echoDataStatus = this.get("echoDataStatus", false);
        this.drawVectors = this.get("drawVectors", true);
        this.drawCircles = this.get("drawCircles", false);
        this.showStationNames = this.get("showStationNames", true);
        this.showMapLabels = this.get("showMapLabels", true);
        this.showAllMapLabels = this.get("showAllMapLabels", false);
        this.showHurricaneRadius = this.get("showHurricaneRadius", true);
        this.copyrightTop = this.get("copyrightTop", true);
        this.displayWxOnly = this.get("displayWxOnly", false);
        this.showNewStations = this.get("showNewStations", true);
        this.showStatusRaw = this.get("showStatusRaw", false);
        this.displayLocalTime = this.get("displayLocalTime", true);
        this.sendLogin = this.get("sendLogin", true);
        this.sleep = this.get("sleep", 0);
        this.autoMapRedraw = this.get("autoMapRedraw", 0L) * 60000L;
        this.autoMapReload = this.get("autoMapReload", 0L) * 60000L;
        this.autoDisplayID = this.get("autoDisplayID", 0);
        string2 = this.get("backgroundColor");
        if (string2 != null) {
            if (string2.equalsIgnoreCase("black")) {
                this.backgroundColor = Color.black;
                this.foregroundColor = Color.white;
            } else if (string2.equalsIgnoreCase("white")) {
                this.backgroundColor = Color.white;
            }
        }
        this.backgroundColorOrig = this.backgroundColor;
        string2 = this.get("startDate");
        if (string2 != null) {
            this.useAPRStime = true;
            this.userTime = true;
            object2 = new StringTokenizer(string2, "/ ,-");
            try {
                object = new Date();
                ((Date)object).setMonth(Integer.parseInt(((StringTokenizer)object2).nextToken()) - 1);
                ((Date)object).setDate(Integer.parseInt(((StringTokenizer)object2).nextToken()));
                ((Date)object).setYear(Integer.parseInt(((StringTokenizer)object2).nextToken()));
                this.startDate = ((Date)object).getTime();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.useAPRStime = this.get("useAPRStime", this.useAPRStime);
        int n = this.get("foregroundColor", -1);
        if (n >= 0) {
            this.foregroundColor = DosMapLine.getColor(n);
        }
        if ((n = this.get("labelColor", -1)) >= 0) {
            this.labelColor = DosMapLine.getColor(n);
        }
        if ((n = this.get("titleColor", -1)) >= 0) {
            this.titleColor = DosMapLine.getColor(n);
        }
        if ((n = this.get("plotColor", -1)) >= 0) {
            this.plotColor = DosMapLine.getColor(n);
        }
        if ((n = this.get("highlightColor", -1)) >= 0) {
            this.highlightColor = DosMapLine.getColor(n);
        }
        if ((n = this.get("shapeColor", -1)) >= 0) {
            this.shapeColor = DosMapLine.getColor(n);
        }
    }
}

