/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Point;
import java.util.Date;
import java.util.StringTokenizer;

class NMEAParser
extends Parser {
    NMEAParser(String string, int n, javAPRS javAPRS2) {
        this.theFileName = string;
        this.theApplet = javAPRS2;
        this.reload = n;
        this.setName(this.theFileName + " Parser");
    }

    NMEAParser(javAPRS javAPRS2) {
        this.theFileName = null;
        this.reload = 0;
        this.theApplet = javAPRS2;
        this.setName("NMEA Parser");
        this.start();
    }

    protected void plotReport(Report report) {
        if (report == null) {
            return;
        }
        if (report.position.lat == 0.0 && report.position.lon == 0.0) {
            return;
        }
        APRSMap aPRSMap = this.theApplet.getMap();
        if (aPRSMap.mapInvalid) {
            return;
        }
        if (aPRSMap != null) {
            Point point = aPRSMap.toPixel(report.position);
            if (point.x < 0 || point.x >= aPRSMap.size().width || point.y < 0 || point.y >= aPRSMap.size().height) {
                return;
            }
            Graphics graphics = aPRSMap.getGraphics();
            if (graphics != null) {
                graphics.setColor(this.theApplet.theParams.plotColor);
                if (this.theApplet.theParams.drawVectors && report.speed > 0) {
                    aPRSMap.drawIcon(graphics, 14, point, report.course, report.speed, report.validWX);
                    return;
                }
                graphics.fillOval(point.x - 2, point.y - 2, 4, 4);
            }
        }
    }

    void setApplet(javAPRS javAPRS2) {
        this.theApplet = javAPRS2;
    }

    Report doParse(byte[] byArray) {
        Report report = null;
        String string = new String(byArray, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        if (n < 8) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (stringArray[n - 1].indexOf(42) >= 0) {
            n2 = stringArray[n - 1].indexOf(42);
            stringArray[n - 1] = n2 == 0 ? "" : stringArray[n - 1].substring(0, n2);
        }
        if (stringArray[0].equals("$GPRMC")) {
            if (!stringArray[2].equals("A")) {
                return null;
            }
            report = new Report();
            report.reportType = "RMC";
            report.setTime(this.theApplet.theParams.displayLocalTime, System.currentTimeMillis());
            if (this.theApplet.theParams.useAPRStime) {
                try {
                    Date date = new Date();
                    date.setDate(Integer.parseInt(stringArray[9].substring(0, 2)));
                    date.setMonth(Integer.parseInt(stringArray[9].substring(2, 4)) - 1);
                    date.setYear(Integer.parseInt(stringArray[9].substring(4, 6)));
                    date.setHours(Integer.parseInt(stringArray[1].substring(0, 2)));
                    date.setMinutes(Integer.parseInt(stringArray[1].substring(2, 4)));
                    date.setSeconds(Integer.parseInt(stringArray[1].substring(4, 6)));
                    report.setTime(this.theApplet.theParams.displayLocalTime, date.getTime());
                }
                catch (NumberFormatException numberFormatException) {
                    report.setTime(this.theApplet.theParams.displayLocalTime, System.currentTimeMillis());
                }
            }
            try {
                report.course = (int)Math.round(Double.valueOf(stringArray[8]));
                if (report.course == 0) {
                    report.course = 360;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                report.speed = (int)Math.round(Double.valueOf(stringArray[7]));
            }
            catch (NumberFormatException numberFormatException) {}
            report.position.lat = this.convertNMEA(stringArray[3]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[4].equals("S")) {
                report.position.lat *= -1.0;
            }
            report.position.lon = this.convertNMEA(stringArray[5]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[6].equals("W")) {
                report.position.lon *= -1.0;
            }
        } else if (stringArray[0].equals("$GPGLL")) {
            if (!stringArray[6].equals("A")) {
                return null;
            }
            report = new Report();
            report.reportType = "GLL";
            report.position.lat = this.convertNMEA(stringArray[1]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[2].equals("S")) {
                report.position.lat *= -1.0;
            }
            report.position.lon = this.convertNMEA(stringArray[3]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[4].equals("W")) {
                report.position.lon *= -1.0;
            }
            report.setTime(this.theApplet.theParams.displayLocalTime, System.currentTimeMillis());
        } else if (stringArray[0].equals("$GPGGA")) {
            n2 = 0;
            try {
                n2 = Integer.parseInt(stringArray[6]);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (n2 != 1 && n2 != 2) {
                return null;
            }
            report = new Report();
            report.reportType = "GGA";
            report.setTime(this.theApplet.theParams.displayLocalTime, System.currentTimeMillis());
            report.position.lat = this.convertNMEA(stringArray[2]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[3].equals("S")) {
                report.position.lat *= -1.0;
            }
            report.position.lon = this.convertNMEA(stringArray[4]);
            if (report.position.isNaN()) {
                return null;
            }
            if (stringArray[5].equals("W")) {
                report.position.lon *= -1.0;
            }
            try {
                report.altitude = (int)Math.round(Double.valueOf(stringArray[9]) / 0.3048);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return report;
    }

    public void run() {
        if (this.theFileName == null) {
            return;
        }
        super.run();
    }
}

