/*
 * Decompiled with CFR 0.152.
 */
class LatLon {
    public double lat;
    public double lon;

    String dToDM1(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 60.0;
        String string = " " + n + ":" + d2;
        return string.substring(1);
    }

    double distanceToDegrees(LatLon latLon) {
        double d;
        double d2;
        if (this.lat < 0.0 && latLon.lat < 0.0) {
            d2 = Trig.radians(90.0 + this.lat);
            d = Trig.radians(90.0 + latLon.lat);
        } else {
            d2 = Trig.radians(90.0 - this.lat);
            d = Trig.radians(90.0 - latLon.lat);
        }
        double d3 = Math.abs(this.lon - latLon.lon);
        if (d3 > 180.0) {
            d3 = 360.0 - d3;
        }
        d3 = Trig.radians(d3);
        return Trig.degrees(Math.acos(Math.cos(d2) * Math.cos(d) + Math.sin(d2) * Math.sin(d) * Math.cos(d3)));
    }

    double distanceTo(LatLon latLon) {
        return 69.04674 * this.distanceToDegrees(latLon);
    }

    public String toString() {
        String string = this.lat < 0.0 ? this.dToDM(-1.0 * this.lat) + "S " : this.dToDM(this.lat) + "N ";
        if (this.lon < 0.0) {
            return string + this.dToDM(-1.0 * this.lon) + "W";
        }
        return string + this.dToDM(this.lon) + "E";
    }

    LatLon() {
        this.lat = 0.0;
        this.lon = 0.0;
    }

    LatLon(double d, double d2) {
        this.lat = d;
        this.lon = d2;
    }

    LatLon(LatLon latLon) {
        this.lat = latLon.lat;
        this.lon = latLon.lon;
    }

    String dToDM(double d) {
        int n = (int)d;
        double d2 = (d - (double)n) * 600.0 / 10.0;
        String string = " ";
        if (n < 100) {
            string = string + " ";
        }
        if (n < 10) {
            string = string + " ";
        }
        string = string + n;
        String string2 = " ";
        if (d2 < 10.0) {
            string2 = string2 + " ";
        }
        if ((string2 = string2 + d2).indexOf(".") < 0) {
            string2 = string2 + ".0";
        }
        string2 = string2 + "000";
        return string.substring(1) + string2.substring(0, 6) + "'";
    }

    String toParam(String string, String string2) {
        return string + "=" + this.lat + " " + string2 + "=" + -this.lon;
    }

    String toParam(String string) {
        return this.toParam(string + "Lat", string + "Lon");
    }

    void setLatLon(double d, double d2) {
        this.lat = d;
        this.lon = d2;
    }

    double bearingTo(LatLon latLon) {
        double d = Trig.radians(90.0 - latLon.lat);
        double d2 = Trig.radians(90.0 - this.lat);
        double d3 = Trig.radians(Math.max(this.lon, latLon.lon) - Math.min(this.lon, latLon.lon));
        double d4 = Math.acos(Math.cos(d) * Math.cos(d2) + Math.sin(d) * Math.sin(d2) * Math.cos(d3));
        double d5 = Trig.degrees(Math.asin(Math.sin(d) * Math.sin(d3) / Math.sin(d4)));
        if (d > d2) {
            d5 = 180.0 - d5;
        }
        if (latLon.lon < this.lon) {
            d5 = 360.0 - d5;
        }
        if (d5 < 0.0) {
            d5 = 360.0 - d5;
        }
        return d5;
    }

    public boolean equals(LatLon latLon) {
        if (latLon == null) {
            return false;
        }
        return this.lat == latLon.lat && this.lon == latLon.lon;
    }

    LatLon latLonAtDistance(double d, double d2) {
        LatLon latLon = new LatLon();
        if (d2 == 0.0) {
            latLon.lat = this.lat + d / 60.0;
            latLon.lon = this.lon;
            return latLon;
        }
        if (d2 == 180.0) {
            latLon.lat = this.lat - d / 60.0;
            latLon.lon = this.lon;
            return latLon;
        }
        double d3 = Trig.radians(d2);
        if (d2 > 180.0) {
            d3 = Math.PI * 2 - d3;
        }
        double d4 = Trig.radians(90.0 - this.lat);
        double d5 = Trig.radians(d / 60.0);
        latLon.lat = Math.acos(Math.cos(d4) * Math.cos(d5) + Math.sin(d4) * Math.sin(d5) * Math.cos(d3));
        latLon.lon = Trig.degrees(Math.asin(Math.sin(d5) * Math.sin(d3) / Math.sin(latLon.lat)));
        latLon.lat = 90.0 - Trig.degrees(latLon.lat);
        latLon.lon = d2 > 180.0 ? this.lon - latLon.lon : this.lon + latLon.lon;
        if (Math.abs(latLon.lon) > 180.0) {
            latLon.lon = -Trig.sign(latLon.lon) * (360.0 - Math.abs(latLon.lon));
        }
        return latLon;
    }

    String toString1() {
        String string = this.dToDM1(this.lat) + ",";
        return string + this.dToDM1(this.lon);
    }

    boolean isNaN() {
        return Double.isNaN(this.lat) || Double.isNaN(this.lon);
    }
}

