/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

class HSTparser
extends Parser {
    HSTparser(String string, int n, javAPRS javAPRS2) {
        this.theFileName = string;
        this.reload = n;
        this.theApplet = javAPRS2;
        this.setName(this.theFileName + " Parser");
        this.start();
    }

    boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    protected long timeParse(String string) {
        Date date = this.theApplet.theParams.startDate != 0L ? new Date(this.theApplet.theParams.startDate) : new Date(System.currentTimeMillis());
        int n = date.getDate();
        try {
            int n2;
            switch (string.charAt(6)) {
                case 'h': {
                    date.setHours(Integer.parseInt(string.substring(0, 2)));
                    date.setMinutes(Integer.parseInt(string.substring(2, 4)));
                    date.setSeconds(Integer.parseInt(string.substring(4, 6)));
                    break;
                }
                case '/': {
                    date = new Date(date.getTime() + (long)(date.getTimezoneOffset() * 60000));
                }
                case 'z': {
                    n2 = Integer.parseInt(string.substring(0, 2));
                    date.setDate(n2);
                    int n3 = Integer.parseInt(string.substring(2, 4));
                    date.setHours(n3);
                    int n4 = Integer.parseInt(string.substring(4, 6));
                    date.setMinutes(n4);
                    date.setSeconds(0);
                    break;
                }
                default: {
                    return System.currentTimeMillis();
                }
            }
            if (this.theApplet.theParams.userTime) {
                if (date.getDate() < n) {
                    n2 = date.getMonth();
                    if (n2 > 0) {
                        date.setMonth(date.getMonth() - 1);
                    } else {
                        date.setMonth(11);
                        date.setYear(date.getYear() - 1);
                    }
                }
            } else if (date.getDate() > n) {
                n2 = date.getMonth();
                if (n2 > 0) {
                    date.setMonth(date.getMonth() - 1);
                } else {
                    date.setMonth(11);
                    date.setYear(date.getYear() - 1);
                }
            }
            if (string.charAt(6) == '/') {
                date = new Date(date.getYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds());
            }
            return date.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return System.currentTimeMillis();
        }
    }

    boolean isLetterOrDigit(char c) {
        return this.isDigit(c) || this.isLetter(c);
    }

    Report doParse(byte[] byArray) {
        boolean bl = false;
        String string = new String(byArray, 0);
        Report report = new Report();
        report.setTime(this.theApplet.theParams.displayLocalTime, System.currentTimeMillis());
        try {
            if (string.charAt(29) != '.') {
                String string2;
                string = string2 = string.substring(0, 9) + "       " + string.substring(9);
                this.theApplet.theSystem.println("new HST String:" + string);
            }
            report.reportType = "HST";
            report.ID = string.substring(0, 9);
            report.position.lat = this.convertNMEA(string.substring(25, 32));
            if (report.position.isNaN()) {
                return null;
            }
            if (string.charAt(32) == 'S') {
                report.position.lat *= -1.0;
            }
            report.position.lon = this.convertNMEA(string.substring(34, 42));
            if (report.position.isNaN()) {
                return null;
            }
            if (string.charAt(42) == 'W') {
                report.position.lon *= -1.0;
            }
            report.icon = string.charAt(43) - 32;
            boolean bl2 = report.altIcons = string.charAt(33) != '/';
            if (this.isLetterOrDigit(string.charAt(33))) {
                report.overlay = string.charAt(33) - 32;
            }
            if (report.position.lat == 0.0 || report.position.lon == 0.0) {
                return null;
            }
            bl = true;
            if (this.theApplet.theParams.useAPRStime) {
                report.setTime(this.theApplet.theParams.displayLocalTime, this.timeParse(string.substring(18, 60)));
            }
            if (string.charAt(47) == '/') {
                report.course = Integer.parseInt(string.substring(44, 47));
                report.speed = Integer.parseInt(string.substring(48, 51));
            }
            int n = 30;
            if (report.icon == 63) {
                report.validWX = true;
                report.reportType = "WX ";
                int n2 = string.indexOf("/B", n);
                if (n2 > 0) {
                    report.pressure = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/b", n)) > 0) {
                    report.pressure = (double)Integer.parseInt(string.substring(n2 + 2, n2 + 6)) / 10.0;
                }
                if ((n2 = string.indexOf("/T", n)) > 0) {
                    report.temperature = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/H", n)) > 0) {
                    report.humidity = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/h", n)) > 0) {
                    report.humidity = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/G", n)) > 0) {
                    report.gust = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/g", n)) > 0) {
                    report.gust = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/P", n)) > 0) {
                    report.prain = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/p", n)) > 0) {
                    report.prain = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/R", n)) > 0) {
                    report.rrain = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
                if ((n2 = string.indexOf("/r", n)) > 0) {
                    report.rrain = Integer.parseInt(string.substring(n2 + 2, n2 + 5));
                }
            } else if (report.icon == 32) {
                report.reportType = "Hur";
                int n3 = string.indexOf(94, n);
                if (n3 > 0) {
                    report.gust = Integer.parseInt(string.substring(n3 + 1, n3 + 4));
                    report.suswind = Integer.parseInt(string.substring(n3 - 4, n3 - 1));
                }
                if ((n3 = string.indexOf(38, n)) > 0) {
                    report.sfw = Integer.parseInt(string.substring(n3 + 1, n3 + 4));
                    report.hfw = Integer.parseInt(string.substring(n3 - 3, n3));
                }
            }
            return report;
        }
        catch (Exception exception) {
            if (bl) {
                return report;
            }
            return null;
        }
    }
}

