/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;

class GifMap
extends APRSMap {
    protected String theFileName;
    protected Image orgImage = null;
    protected Rectangle imgRect = null;
    protected XY orgPPDXY;
    protected LatLon orgImgCenterLL;
    protected boolean initFromParam = true;
    private static /* synthetic */ Class class$latlonProjection;

    void initMap() {
        if (this.orgImage == null) {
            return;
        }
        XY xY = new XY(this.mapSize);
        this.scaleToScreen(xY);
        XY xY2 = this.toScreenXY(this.toMapXY(this.orgImgCenterLL));
        Point point = xY.toPoint();
        Rectangle rectangle = new Rectangle(0, 0, point.x, point.y);
        rectangle.setLocation((int)Math.round(xY2.x - ((double)rectangle.width - 1.0) / 2.0), (int)Math.round(xY2.y - ((double)rectangle.height - 1.0) / 2.0));
        this.mapImage = this.createImage(this.size().width, this.size().height);
        Graphics graphics = this.mapImage.getGraphics();
        if (this.screenRect.intersects(rectangle)) {
            Rectangle rectangle2 = this.screenRect.intersection(rectangle);
            xY = new XY(rectangle2.width, rectangle2.height);
            this.scaleToMap(xY);
            xY.scale(this.orgPPDXY);
            XY xY3 = this.toMapXY(rectangle2.getLocation());
            xY3.scale(this.orgPPDXY);
            XY xY4 = this.toMapXY(this.orgImgCenterLL);
            xY4.scale(this.orgPPDXY);
            xY4.reverseOffsetXY(new XY(((double)this.imgRect.width - 1.0) / 2.0, -((double)this.imgRect.height - 1.0) / 2.0));
            xY3.reverseOffsetXY(xY4);
            xY3.y = -xY3.y;
            Point point2 = xY3.toPoint();
            Point point3 = xY.toPoint();
            Rectangle rectangle3 = new Rectangle(point2, new Dimension(point3.x, point3.y));
            int[] nArray = new int[rectangle3.width * rectangle3.height];
            try {
                PixelGrabber pixelGrabber = new PixelGrabber(this.orgImage, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, nArray, 0, rectangle3.width);
                if (pixelGrabber.grabPixels()) {
                    pixelGrabber.getPixels();
                }
            }
            catch (Exception exception) {
                this.theApplet.theSystem.println("Grab Error: " + exception);
                this.mapImage = null;
                return;
            }
            graphics.drawImage(this.createImage(new MemoryImageSource(rectangle3.width, rectangle3.height, nArray, 0, rectangle3.width)), rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, this.theApplet.theParams.backgroundColor, null);
        } else {
            graphics.setColor(this.theApplet.theParams.backgroundColor);
            graphics.fillRect(0, 0, this.size().width, this.size().height);
        }
        this.theApplet.theSystem.println("GIF Map " + this.theFileName + " " + this.screenCenterLL.toParam("screenCenter") + " scale=" + this.mapPPDXY.x / this.orgPPDXY.x);
    }

    GifMap(String string, javAPRS javAPRS2) {
        super(javAPRS2);
        this.theApplet.setUpIcons();
        this.theFileName = string;
    }

    void getMap() {
        Object object;
        if (this.orgImage != null) {
            this.tracker.removeImage(this.orgImage);
            this.orgImage = null;
            this.imgRect = null;
        }
        if (this.theFileName.startsWith("http:")) {
            this.orgImage = this.getImage(this.theFileName);
        } else {
            object = null;
            try {
                object = new URL(this.theApplet.getCodeBase(), "maps/" + this.theFileName);
            }
            catch (MalformedURLException malformedURLException) {
                this.drawErrorString("URL Error: " + malformedURLException);
                return;
            }
            this.orgImage = this.getImage(((URL)object).toExternalForm());
        }
        if (this.orgImage == null) {
            return;
        }
        this.imgRect = new Rectangle(this.orgImage.getWidth(null), this.orgImage.getHeight(null));
        if (!this.initFromParam) {
            this.initMap();
            return;
        }
        this.initFromParam = false;
        object = new LatLon(this.theApplet.theParams.gifMapTop, this.theApplet.theParams.gifMapLeft);
        LatLon latLon = new LatLon(this.theApplet.theParams.gifMapBottom, this.theApplet.theParams.gifMapRight);
        Class clazz = null;
        try {
            clazz = Class.forName(this.theApplet.theParams.mapProjection + "Projection");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.theApplet.theSystem.println(this.theApplet.theParams.mapProjection + "Projection class does not exist");
            clazz = class$latlonProjection != null ? class$latlonProjection : (class$latlonProjection = GifMap.class$("latlonProjection"));
        }
        try {
            this.mapProjection = (Projection)clazz.newInstance();
        }
        catch (Exception exception) {
            this.theApplet.theSystem.println(exception.toString() + " while creating " + this.theApplet.theParams.mapProjection + "Projection");
            this.mapProjection = new latlonProjection();
        }
        if (latLon.isNaN()) {
            if (this.theApplet.theParams.gifMapPPDh == 0.0) {
                this.theApplet.theParams.gifMapPPDh = this.theApplet.theParams.gifMapPPDv;
            } else if (this.theApplet.theParams.gifMapPPDv == 0.0) {
                this.theApplet.theParams.gifMapPPDv = this.theApplet.theParams.gifMapPPDh;
            }
            if (this.theApplet.theParams.gifMapPPDh == 0.0) {
                this.theApplet.theSystem.println("GIF parameters not correctly specified");
                return;
            }
            latLon.lon = ((LatLon)object).lon + ((double)this.imgRect.width - 1.0) / this.theApplet.theParams.gifMapPPDh;
            latLon.lat = ((LatLon)object).lat - ((double)this.imgRect.height - 1.0) / this.theApplet.theParams.gifMapPPDv;
        }
        if (this.theApplet.theParams.mapCenter.isNaN()) {
            this.mapProjection.init(this.mapProjection.calcMapCenter((LatLon)object, latLon, this.imgRect));
        } else {
            this.mapProjection.init(this.theApplet.theParams.mapCenter);
        }
        this.orgImgCenterLL = this.mapProjection.getImageCtrLL((LatLon)object, latLon);
        this.mapPPDXY = this.mapProjection.getScaleXY((LatLon)object, latLon, this.imgRect);
        this.orgPPDXY = new XY(this.mapPPDXY);
        this.mapSize = new XY((double)this.imgRect.width / this.orgPPDXY.x, (double)this.imgRect.height / this.orgPPDXY.y);
        this.autosize();
        this.screenCenterLL = this.theApplet.theParams.gifScrCtrLL.isNaN() ? this.orgImgCenterLL : new LatLon(this.theApplet.theParams.gifScrCtrLL);
        this.recenter(this.screenCenterLL);
        this.initMap();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

