/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

class ExpediaMap
extends APRSMap {
    protected String stringURL;
    protected static final double expediaDegree = 177.30434782608697;
    protected String map = "WLD0409";
    protected static dblRectangle USA = new dblRectangle(new XY(-180, 85), new XY(-50, 30));
    protected static dblRectangle FLTX = new dblRectangle(new XY(-102, 30), new XY(-79, 24));
    protected static dblRectangle TX = new dblRectangle(new XY(-105, 30), new XY(-102, 28));
    protected static dblRectangle HI = new dblRectangle(new XY(-161, 24), new XY(-154, 18));
    protected static dblRectangle Europe = new dblRectangle(new XY(-25, 75), new XY(45, 35));
    protected double vWidth;

    void initMap() {
        this.firstrun = true;
    }

    ExpediaMap(javAPRS javAPRS2) {
        super(javAPRS2);
        this.theApplet.theParams.backgroundColor = Color.white;
        if (this.theApplet.theParams.foregroundColor == Color.white) {
            this.theApplet.theParams.foregroundColor = Color.black;
        }
        this.theApplet.setUpIcons();
        this.vWidth = this.size().width;
        if (3 * this.size().width > 4 * this.size().height) {
            this.vWidth = (double)this.size().height * 4.0 / 3.0;
        }
        this.mapPPDXY.y = this.mapPPDXY.x = this.vWidth / this.theApplet.theParams.expediaMapWide;
        this.screenCenterLL = new LatLon(this.theApplet.theParams.mapCenter);
    }

    void getMap() {
        if (this.mapImage != null) {
            this.tracker.removeImage(this.mapImage);
            this.mapImage = null;
        }
        this.mapImage = this.getImage(this.createExpediaURLstring());
    }

    protected String createExpediaURLstring() {
        if (Math.abs(this.screenCenterLL.lon) > 180.0) {
            this.screenCenterLL.lon = -Trig.sign(this.screenCenterLL.lon) * (360.0 - Math.abs(this.screenCenterLL.lon));
        }
        this.mapProjection = new orthographicProjection(this.screenCenterLL);
        long l = this.CalcScale();
        this.recenter(this.screenCenterLL);
        this.theApplet.theSystem.println("Expedia Map " + this.screenCenterLL.toParam("mapCenter") + " expediaMapWide=" + this.vWidth / this.mapPPDXY.x);
        return "http://msrvmaps.mappoint.net/isapi/MSMap.dll?ID=3XNsF.&C=" + this.screenCenterLL.lat + "," + this.screenCenterLL.lon + "&L=" + this.map + "&CV=1&A=" + l + "&S=" + this.size().width + "," + this.size().height;
    }

    protected long CalcScale() {
        long l = 1L;
        if (USA.contains(this.screenCenterLL.lon, this.screenCenterLL.lat) || FLTX.contains(this.screenCenterLL.lon, this.screenCenterLL.lat) || TX.contains(this.screenCenterLL.lon, this.screenCenterLL.lat) || HI.contains(this.screenCenterLL.lon, this.screenCenterLL.lat)) {
            this.map = "USA0409";
        } else if (Europe.contains(this.screenCenterLL.lon, this.screenCenterLL.lat)) {
            this.map = "EUR0809";
        } else {
            l = 100L;
            this.map = "WLD0409";
        }
        long l2 = Math.round(177.30434782608697 * this.vWidth / this.mapPPDXY.x);
        if (l2 < l) {
            l2 = l;
            this.mapPPDXY.y = this.mapPPDXY.x = 177.30434782608697 * (this.vWidth / (double)l2);
        } else if (l2 == 0L) {
            l2 = 1L;
            this.mapPPDXY.y = this.mapPPDXY.x = 177.30434782608697 * this.vWidth;
        }
        return l2;
    }
}

