/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Point;
import java.util.StringTokenizer;
import java.util.Vector;

class DosMapLine {
    Color color;
    String name = "";
    private int curPoint = 0;
    private Vector coordinates = new Vector();
    private static final Color[] colorTable = new Color[]{Color.black, Color.blue.darker(), Color.green.darker(), Color.cyan.darker(), Color.red.darker(), Color.magenta.darker(), Color.yellow.darker(), Color.lightGray, Color.darkGray, Color.blue.brighter(), Color.green.brighter(), Color.cyan.brighter(), Color.red.brighter(), Color.magenta.brighter(), Color.yellow.brighter(), Color.white};

    Point addPoint(String string, double d, LatLon latLon) {
        Point point;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 2) {
            return null;
        }
        try {
            point = new Point(Integer.parseInt(stringTokenizer.nextToken().trim()), -Integer.parseInt(stringTokenizer.nextToken().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException + " error with Line Point: " + string);
            return null;
        }
        LatLon latLon2 = new LatLon(latLon.lat + (double)point.y / d, latLon.lon + (double)point.x / d);
        this.coordinates.addElement(latLon2);
        return point;
    }

    DosMapLine(String string) {
        int n = string.indexOf(44);
        if (n >= 0) {
            this.name = string.substring(n + 1).trim();
            string = string.substring(0, n).trim();
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        this.color = DosMapLine.getColor(n);
    }

    LatLon getNextPoint() {
        if (this.morePoints()) {
            return (LatLon)this.coordinates.elementAt(this.curPoint++);
        }
        return null;
    }

    static final Color getColor(int n) {
        return colorTable[n % 16];
    }

    boolean morePoints() {
        return this.curPoint < this.coordinates.size();
    }

    int getSize() {
        return this.coordinates.size();
    }

    LatLon getFirstPoint() {
        if (this.coordinates.size() == 0) {
            return null;
        }
        this.curPoint = 1;
        return (LatLon)this.coordinates.firstElement();
    }
}

