/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

class DosMap
extends APRSMap {
    Vector lines = new Vector();
    Vector labels = new Vector();
    String theFileName;
    double orgPPD = 0.0;
    XY orgScreenCenter;

    void initMap() {
        XY xY = this.orgScreenCenter.diff(this.mapScreenCenterXY);
        xY.scale(this.orgPPD);
        this.theApplet.theSystem.println("DOS Map: " + this.theApplet.theParams.dosMap + " scale=" + this.mapPPDXY.x / this.orgPPD + " offsetX=" + xY.x + " offsetY=" + -xY.y);
        this.mapImage = this.createImage(this.size().width, this.size().height);
        Graphics graphics = this.mapImage.getGraphics();
        graphics.setColor(this.theApplet.theParams.backgroundColor);
        graphics.fillRect(0, 0, this.size().width, this.size().height);
        this.drawMapSlow(graphics);
    }

    public String toString() {
        String string = super.toString();
        string = string + "\r\norgPPD: " + this.orgPPD;
        string = string + "\r\norgScreenCenter: " + this.orgScreenCenter.toString();
        string = string + "\r\n" + this.printMapFile();
        return string;
    }

    DosMap(String string, javAPRS javAPRS2) {
        super(javAPRS2);
        this.theApplet.setUpIcons();
        this.theFileName = string;
    }

    String printMapFile() {
        Object object;
        String string = "Polylines:";
        int n = 0;
        while (n < this.lines.size()) {
            object = (DosMapLine)this.lines.elementAt(n);
            string = string + "\n\r" + ((DosMapLine)object).name + " " + ((DosMapLine)object).color;
            LatLon latLon = ((DosMapLine)object).getFirstPoint();
            while (latLon != null) {
                string = string + "\n\r" + latLon;
                latLon = ((DosMapLine)object).getNextPoint();
            }
            ++n;
        }
        string = string + "\n\rLabels:";
        n = 0;
        while (n < this.labels.size()) {
            object = (DosMapLabel)this.labels.elementAt(n);
            string = string + "\n\r" + ((DosMapLabel)object).overlay + " " + ((DosMapLabel)object).icon + " " + ((DosMapLabel)object).color + " " + ((DosMapLabel)object).name + " " + ((DosMapLabel)object).PPDLevel + ((DosMapLabel)object).LL.toString();
            ++n;
        }
        return string;
    }

    void getMap() {
        Object object;
        String string = null;
        DataInputStream dataInputStream = null;
        URL uRL = null;
        Object var4_4 = null;
        if (this.theFileName.startsWith("http:")) {
            try {
                uRL = new URL(this.theFileName);
            }
            catch (MalformedURLException malformedURLException) {
                this.drawErrorString("URL error: " + malformedURLException);
                throw new SecurityException("URL error: " + malformedURLException);
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
                catch (Exception exception) {
                    Object[] objectArray;
                    Class[] classArray;
                    try {
                        object = Class.forName("netscape.security.PrivilegeManager");
                        classArray = new Class[]{Class.forName("java.lang.String")};
                        objectArray = new Object[]{"UniversalConnect"};
                        ((Class)object).getMethod("enablePrivilege", classArray).invoke(null, objectArray);
                    }
                    catch (Exception exception2) {
                        try {
                            object = Class.forName("java.net.SocketPermission");
                            classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                            objectArray = new Object[]{uRL.getHost() + ":" + uRL.getPort(), "connect"};
                            var4_4 = ((Class)object).getConstructor(classArray).newInstance(objectArray);
                        }
                        catch (Exception exception3) {
                            this.drawErrorString("Security Error");
                            throw new SecurityException(exception3.toString());
                        }
                    }
                }
            }
        } else {
            try {
                uRL = new URL(this.theApplet.getCodeBase(), "maps/" + this.theFileName);
            }
            catch (MalformedURLException malformedURLException) {
                this.drawErrorString("URL Error");
                throw new SecurityException("DOS Map URL Error");
            }
        }
        try {
            dataInputStream = new DataInputStream(uRL.openStream());
        }
        catch (Exception exception) {
            this.drawErrorString("Error opening file: " + uRL + ", " + exception);
            this.theApplet.theSystem.println("Error opening DOS Map file: " + uRL + ", " + exception);
            return;
        }
        try {
            string = dataInputStream.readLine();
            int n = string.indexOf(44);
            if (n < 1) {
                n = string.length();
            }
            object = new LatLon();
            ((LatLon)object).lat = Double.valueOf(string.substring(0, n).trim());
            string = dataInputStream.readLine();
            n = string.indexOf(44);
            if (n < 1) {
                n = string.length();
            }
            ((LatLon)object).lon = -Double.valueOf(string.substring(0, n).trim()).doubleValue();
            string = dataInputStream.readLine();
            n = string.indexOf(44);
            if (n < 1) {
                n = string.length();
            }
            this.mapPPDXY.x = this.orgPPD = Double.valueOf(string.substring(0, n).trim()).doubleValue();
            this.mapPPDXY.y = this.orgPPD;
            string = dataInputStream.readLine();
            n = string.indexOf(44);
            if (n < 1) {
                n = string.length();
            }
            this.screenCenterLL.lat = Double.valueOf(string.substring(0, n).trim());
            string = dataInputStream.readLine();
            n = string.indexOf(44);
            if (n < 1) {
                n = string.length();
            }
            this.screenCenterLL.lon = -Double.valueOf(string.substring(0, n).trim()).doubleValue();
            this.mapProjection = new latlonProjection(this.screenCenterLL);
            try {
                this.recenter(this.screenCenterLL);
            }
            catch (Exception exception) {}
            this.orgScreenCenter = new XY();
            int n2 = 0;
            do {
                string = dataInputStream.readLine();
            } while (++n2 < 4);
            string = string.trim();
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            block22: while (string.equals("0,0")) {
                string = dataInputStream.readLine();
                DosMapLine dosMapLine = new DosMapLine(string.trim());
                this.lines.addElement(dosMapLine);
                string = dataInputStream.readLine().trim();
                while (!string.equals("0,0") && !string.equals("0,-1")) {
                    Point point = dosMapLine.addPoint(string, this.orgPPD, (LatLon)object);
                    if (point != null) {
                        n2 = Math.min(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.x);
                        n5 = Math.max(n5, point.y);
                    }
                    if ((string = dataInputStream.readLine()) == null) continue block22;
                    string = string.trim();
                }
            }
            this.mapSize.x = (double)(n4 - n2 + 1) / this.orgPPD;
            this.mapSize.y = (double)(n5 - n3 + 1) / this.orgPPD;
        }
        catch (NumberFormatException numberFormatException) {
            this.theApplet.theSystem.println("Format exception ***" + string);
            char c = string.charAt(0);
            this.theApplet.theSystem.println("char: " + c);
        }
        catch (IOException iOException) {
            string = null;
        }
        this.lines.trimToSize();
        if (string != null) {
            try {
                string = dataInputStream.readLine();
            }
            catch (IOException iOException) {
                string = null;
            }
        }
        while (string != null) {
            try {
                string = dataInputStream.readLine();
            }
            catch (IOException iOException) {
                string = null;
            }
            if (string == null) break;
            DosMapLabel dosMapLabel = new DosMapLabel(string.trim());
            if (dosMapLabel.PPDLevel == 0.0) continue;
            int n = 0;
            while (n < this.labels.size()) {
                if (((DosMapLabel)this.labels.elementAt((int)n)).PPDLevel < dosMapLabel.PPDLevel) {
                    this.labels.insertElementAt(dosMapLabel, n);
                    break;
                }
                ++n;
            }
            if (n != this.labels.size()) continue;
            this.labels.addElement(dosMapLabel);
        }
        this.labels.trimToSize();
        this.moveCenter(new XY(this.theApplet.theParams.offsetX, this.theApplet.theParams.offsetY), false);
        this.autosize();
        this.initMap();
        this.show();
        this.requestFocus();
        this.theApplet.showStatus("");
    }

    void drawMapSlow(Graphics graphics) {
        Object object;
        Serializable serializable;
        Object object2;
        dblRectangle dblRectangle2 = new dblRectangle(this.toMapXY(new Point(0, 0)), this.toMapXY(new Point(this.size().width - 1, this.size().height - 1)));
        int n = 0;
        while (n < this.lines.size()) {
            object2 = (DosMapLine)this.lines.elementAt(n);
            serializable = ((DosMapLine)object2).color;
            if (serializable.equals(this.theApplet.theParams.backgroundColor)) {
                serializable = Color.gray;
            }
            graphics.setColor((Color)serializable);
            object = ((DosMapLine)object2).getFirstPoint();
            while (object != null) {
                LatLon latLon = ((DosMapLine)object2).getNextPoint();
                if (latLon == null) break;
                XY xY = this.mapProjection.toMapXY((LatLon)object);
                XY xY2 = this.mapProjection.toMapXY(latLon);
                XY xY3 = this.toMapXY((LatLon)object);
                XY xY4 = this.toMapXY(latLon);
                if ((xY.equals(xY3) && xY2.equals(xY4) || !xY.equals(xY3) && !xY2.equals(xY4)) && dblRectangle2.intersects(new dblRectangle(xY3, xY4))) {
                    Point point = this.toPixel(xY3);
                    Point point2 = this.toPixel(xY4);
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                }
                object = latLon;
            }
            ++n;
        }
        if (this.theApplet.theParams.showMapLabels) {
            n = 0;
            while (n < this.labels.size()) {
                object2 = (DosMapLabel)this.labels.elementAt(n);
                if (!this.theApplet.theParams.showAllMapLabels && ((DosMapLabel)object2).PPDLevel < 3600.0 / this.mapPPDXY.x) {
                    return;
                }
                serializable = this.toPixel(((DosMapLabel)object2).LL);
                if (this.screenRect.contains((Point)serializable)) {
                    if (((DosMapLabel)object2).icon != 0) {
                        if (((DosMapLabel)object2).overlay == 47) {
                            this.drawIcon(graphics, ((DosMapLabel)object2).icon, (Point)serializable);
                        } else {
                            this.drawIcon(graphics, ((DosMapLabel)object2).icon + 128, (Point)serializable);
                            if (((DosMapLabel)object2).overlay != 92) {
                                this.drawOverlay(graphics, ((DosMapLabel)object2).overlay - 32, (Point)serializable);
                            }
                        }
                    }
                    ((Point)serializable).x -= ((DosMapLabel)object2).name.length() * 7;
                    graphics.setFont(this.theApplet.theFont);
                    graphics.setColor(this.theApplet.theParams.backgroundColor);
                    graphics.drawString(((DosMapLabel)object2).name, ((Point)serializable).x + 1, ((Point)serializable).y + 1);
                    graphics.drawString(((DosMapLabel)object2).name, ((Point)serializable).x + 1, ((Point)serializable).y - 1);
                    graphics.drawString(((DosMapLabel)object2).name, ((Point)serializable).x - 1, ((Point)serializable).y + 1);
                    graphics.drawString(((DosMapLabel)object2).name, ((Point)serializable).x - 1, ((Point)serializable).y - 1);
                    object = DosMapLine.getColor(((DosMapLabel)object2).color);
                    if (((DosMapLabel)object2).color == 0) {
                        object = this.theApplet.theParams.labelColor;
                    }
                    if (((Color)object).equals(this.theApplet.theParams.backgroundColor)) {
                        object = Color.gray;
                    }
                    graphics.setColor((Color)object);
                    graphics.drawString(((DosMapLabel)object2).name, ((Point)serializable).x, ((Point)serializable).y);
                }
                ++n;
            }
        }
    }
}

