/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

class BlastMap
extends APRSMap {
    protected String stringURL;
    protected static final double blastFactor = 3.155555555555556E8;

    void initMap() {
        this.firstrun = true;
    }

    BlastMap(javAPRS javAPRS2) {
        super(javAPRS2);
        this.theApplet.theParams.backgroundColor = Color.white;
        if (this.theApplet.theParams.foregroundColor == Color.white) {
            this.theApplet.theParams.foregroundColor = Color.black;
        }
        this.theApplet.setUpIcons();
        this.mapPPDXY.x = this.mapPPDXY.y = (double)this.size().height / this.theApplet.theParams.blastMapHigh;
        if (this.theApplet.theParams.mapCenter.isNaN()) {
            this.screenCenterLL = new LatLon(this.theApplet.theParams.blastMapTop - this.screenCenterXY.y / (this.mapPPDXY.y * 2.0), this.theApplet.theParams.blastMapLeft + this.screenCenterXY.x / this.mapPPDXY.x);
            return;
        }
        this.screenCenterLL = new LatLon(this.theApplet.theParams.mapCenter);
    }

    protected String createBlastURLstring() {
        if (Math.abs(this.screenCenterLL.lon) > 180.0) {
            this.screenCenterLL.lon = -Trig.sign(this.screenCenterLL.lon) * (360.0 - Math.abs(this.screenCenterLL.lon));
        }
        double d = this.CalcScale();
        this.recenter(this.screenCenterLL);
        this.theApplet.theSystem.println("MapBlast Map " + this.screenCenterLL.toParam("mapCenter") + " blastMapHigh=" + (double)this.size().height / this.mapPPDXY.y);
        String string = "www.vicinity.com";
        if (this.theApplet.theParams.blastMapRelay != null) {
            string = this.theApplet.theParams.blastMapRelay;
        }
        String string2 = "MI";
        if (Report.metric) {
            string2 = "KM";
        }
        return "http://" + string + "/gif?CT=" + this.screenCenterLL.lat + ":" + this.screenCenterLL.lon + ":" + d + ":&DU=" + string2 + "&IC=" + this.screenCenterLL.lat + ":" + this.screenCenterLL.lon + ":10:&FAM=myblast" + "&W=" + this.size().width + "&H=" + this.size().height;
    }

    void getMap() {
        if (this.mapImage != null) {
            this.tracker.removeImage(this.mapImage);
            this.mapImage = null;
        }
        this.mapImage = this.getImage(this.createBlastURLstring());
    }

    protected double CalcScale() {
        double d = 3.155555555555556E8 / this.mapPPDXY.x;
        if (d > 2.0E8) {
            d = 2.0E8;
            this.screenCenterLL.lat = 0.0;
            this.mapPPDXY.y = this.mapPPDXY.x = 3.155555555555556E8 / d;
        }
        this.mapProjection = d >= 5.0E7 ? new vandergrintenProjection(this.screenCenterLL) : new stereographicProjection(this.screenCenterLL, 57.29577951308232, true);
        return d;
    }
}

