/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.BufferedInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

abstract class APRSMap
extends Canvas {
    javAPRS theApplet;
    XY mapSize;
    XY mapPPDXY = new XY(1.0, 1.0);
    XY mapScreenCenterXY = new XY();
    Rectangle screenRect;
    XY screenCenterXY;
    LatLon screenCenterLL = new LatLon();
    XY screenScaleXY = new XY(1.0, 1.0);
    Projection mapProjection;
    MediaTracker tracker = new MediaTracker(this);
    Image mapImage;
    Boolean threadSemaphore = new Boolean(true);
    boolean firstrun = true;
    Point titlePoint = new Point(30, 10);
    boolean mapInvalid = true;
    String lastCall;

    LatLon toLatLon(Point point) {
        return this.toLatLon(this.toMapXY(point));
    }

    LatLon toLatLon(int n, int n2) {
        return this.toLatLon(this.toMapXY(new Point(n, n2)));
    }

    protected LatLon toLatLon(XY xY) {
        if (xY.isNaN()) {
            return new LatLon(Double.NaN, Double.NaN);
        }
        if (Math.abs(xY.y) > 180.0) {
            return new LatLon(Double.NaN, Double.NaN);
        }
        xY.x %= 360.0;
        if (Math.abs(xY.x) > 180.0) {
            xY.x = -Trig.sign(xY.x) * (360.0 - xY.x);
        }
        LatLon latLon = this.mapProjection.toLatLon(xY);
        if (Math.abs(latLon.lat) > 90.0) {
            latLon.lat = Double.NaN;
        }
        if (Math.abs(latLon.lon) > 180.0) {
            latLon.lon = -Trig.sign(latLon.lon) * (360.0 - Math.abs(latLon.lon));
        }
        return latLon;
    }

    protected void autosize() {
        XY xY;
        if (this.theApplet.theParams.autoScale && this.theApplet.theParams.scale == 1.0) {
            xY = new XY(this.mapSize);
            this.scaleToScreen(xY);
            XY xY2 = new XY((double)this.size().width / xY.x, (double)this.size().height / xY.y);
            this.mapPPDXY.scale(Math.min(xY2.x, xY2.y));
        } else {
            this.mapPPDXY.scale(this.theApplet.theParams.scale);
        }
        if (this.theApplet.theParams.autoFit) {
            xY = new XY(this.mapSize);
            this.scaleToScreen(xY);
            this.screenScaleXY.x = (double)this.size().width / xY.x;
            this.screenScaleXY.y = (double)this.size().height / xY.y;
        }
        this.recenter(this.toLatLon(this.toMapXY(this.screenCenterXY)));
    }

    private void drawRange(Graphics graphics, Point point, Report report) {
        if (!this.theApplet.theParams.drawCircles) {
            return;
        }
        Color color = report.strength >= 0 ? (report.ID.equals(this.lastCall) ? Color.pink : Color.red.brighter()) : (report.number > 0 ? (report.ID.equals(this.lastCall) ? Color.pink : Color.red.darker()) : (report.ID.equals(this.lastCall) ? this.theApplet.theParams.highlightColor : Color.green.brighter()));
        if (report.range > 0) {
            if (report.directivity > 0) {
                this.drawOval(graphics, color, point, (double)report.range / 1.150779, report.directivity);
                return;
            }
            if (report.number > 0) {
                int n = report.bearing < 22 ? 360 : (report.bearing < 67 ? 45 : (report.bearing < 112 ? 90 : (report.bearing < 157 ? 135 : (report.bearing < 202 ? 180 : (report.bearing < 247 ? 225 : (report.bearing < 292 ? 270 : (report.bearing < 337 ? 315 : 360)))))));
                this.drawOval(graphics, color, point, (double)report.range / 1.150779, n);
                return;
            }
            this.drawOval(graphics, color, point, (double)report.range / 1.150779);
        }
    }

    protected void scaleToScreen(XY xY) {
        xY.scale(this.mapPPDXY);
        xY.scale(this.screenScaleXY);
    }

    private void drawLine(Graphics graphics, Color color, Point point, double d, double d2) {
        LatLon latLon = this.toLatLon(point);
        LatLon latLon2 = latLon.latLonAtDistance(d, d2);
        XY xY = this.toMapXY(latLon2);
        if (xY.isNaN()) {
            return;
        }
        Point point2 = this.toPixel(xY);
        if (!point.equals(point2) && (d2 > 180.0 && point.x - point2.x >= 0 || d2 < 180.0 && point.x - point2.x <= 0 || d2 == 180.0 || d2 == 360.0)) {
            graphics.setColor(color);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
        }
    }

    protected void drawLoadingString(String string) {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setColor(this.theApplet.theParams.backgroundColor);
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            graphics.setFont(new Font("Helvetica", 0, 10));
            graphics.setColor(this.theApplet.theParams.titleColor);
            graphics.drawString("Loading " + string + "...", 10, 10);
        }
        this.theApplet.showStatus("Loading " + string + "...");
    }

    abstract void getMap();

    protected void zoom(boolean bl, boolean bl2) {
        double d = 1.0;
        if (bl2) {
            d = 2.0;
        }
        if (bl) {
            this.mapPPDXY.scale(2.0 * d);
        } else {
            this.mapPPDXY.reverseScale(2.0 * d);
        }
        this.recenter(this.screenCenterLL);
    }

    private void drawIconName(String string, Point point, Graphics graphics) {
        graphics.setColor(this.theApplet.theParams.backgroundColor);
        graphics.drawString(string, point.x + 9, point.y + 4);
        graphics.drawString(string, point.x + 9, point.y + 6);
        graphics.drawString(string, point.x + 11, point.y + 4);
        graphics.drawString(string, point.x + 11, point.y + 6);
        graphics.setColor(this.theApplet.theParams.foregroundColor);
        graphics.drawString(string, point.x + 10, point.y + 5);
    }

    protected Image getImage(String string) {
        Image image = null;
        URL uRL = null;
        Object var4_4 = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.drawErrorString("URL error: " + malformedURLException);
            return null;
        }
        try {
            Object[] objectArray;
            Class<?> clazz;
            SecurityManager securityManager;
            int n = uRL.getPort();
            if (n == -1) {
                n = 80;
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                try {
                    securityManager.checkConnect(uRL.getHost(), n);
                }
                catch (Exception exception) {
                    Class[] classArray;
                    try {
                        clazz = Class.forName("netscape.security.PrivilegeManager");
                        classArray = new Class[]{Class.forName("java.lang.String")};
                        objectArray = new Object[]{"UniversalConnectWithRedirect"};
                        clazz.getMethod("enablePrivilege", classArray).invoke(null, objectArray);
                    }
                    catch (Exception exception2) {
                        clazz = Class.forName("java.net.SocketPermission");
                        classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                        objectArray = new Object[]{uRL.getHost() + ":" + n, "connect"};
                        var4_4 = clazz.getConstructor(classArray).newInstance(objectArray);
                    }
                }
            }
            clazz = uRL.openConnection();
            int n2 = ((URLConnection)((Object)clazz)).getContentLength();
            objectArray = new BufferedInputStream(((URLConnection)((Object)clazz)).getInputStream());
            byte[] byArray = null;
            if (n2 < 0) {
                byte[] byArray2 = new byte[500000];
                int n3 = 0;
                int n4 = objectArray.read();
                while (n4 != -1) {
                    byArray2[n3++] = (byte)n4;
                    n4 = objectArray.read();
                }
                objectArray.close();
                if (n3 == 0) {
                    throw new Exception("Could not get image: " + uRL.toExternalForm());
                }
                byArray = new byte[n3];
                System.arraycopy(byArray2, 0, byArray, 0, n3);
            } else {
                if (n2 == 0) {
                    objectArray.close();
                    throw new Exception("Could not get image file: " + uRL.toExternalForm());
                }
                byArray = new byte[n2];
                int n5 = objectArray.read(byArray, 0, n2);
                int n6 = 0;
                while (n6 + n5 < n2) {
                    n5 = objectArray.read(byArray, n6 += n5, n2 - n6);
                }
            }
            objectArray.close();
            image = Toolkit.getDefaultToolkit().createImage(byArray);
            if (image == null) {
                throw new Exception("Netscape Image Error");
            }
        }
        catch (Exception exception) {
            this.drawErrorString("Error opening map: " + uRL + " Error: " + exception);
            return null;
        }
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        if (this.tracker.isErrorAny()) {
            this.tracker.removeImage(image);
            this.drawErrorString("Error loading map: " + this.tracker.getErrorsAny().toString());
            return null;
        }
        this.theApplet.showStatus("");
        return image;
    }

    Report drawTrack(Report report, Report report2) {
        if (report2 == null) {
            return null;
        }
        if (this.mapInvalid) {
            return null;
        }
        if (this.theApplet.checkFilter(report2)) {
            return null;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return null;
        }
        Point point = this.toPixel(report2.position);
        if (point.x < 0) {
            point.x = (int)(((double)this.degrees360() + (double)point.x) % (double)this.degrees360());
        }
        if (!this.screenRect.contains(point)) {
            return null;
        }
        if (report2.ID.equals(this.theApplet.theParams.homeID)) {
            graphics.setColor(this.theApplet.theParams.highlightColor);
        } else {
            graphics.setColor(this.theApplet.theParams.plotColor);
        }
        graphics.fillOval(point.x - 1, point.y - 1, 3, 3);
        if (report != null && !this.theApplet.checkFilter(report) && report2.position.distanceTo(report.position) < 400.0) {
            Point point2 = this.toPixel(report.position);
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
        }
        return report2;
    }

    protected Point toPixel(XY xY) {
        if (xY.isNaN()) {
            return new Point(-1, -1);
        }
        return this.toScreenXY(xY).toPoint();
    }

    Point toPixel(LatLon latLon) {
        return this.toPixel(this.toMapXY(latLon));
    }

    protected void drawErrorString(String string) {
        this.theApplet.showStatus(string);
        this.theApplet.theSystem.println(string);
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(new Font("Helvetica", 1, 10));
            graphics.setColor(this.theApplet.theParams.titleColor);
            graphics.drawString(string, 10, 24);
        }
        this.theApplet.showStatus(string);
    }

    void deadReckon(Report report) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (report.validWX || report.course == 0 || report.speed == 0) {
            return;
        }
        long l = System.currentTimeMillis() - report.time;
        if (l <= 1000L || l > 3600000L) {
            return;
        }
        Point point = this.toPixel(report.position);
        if (point.x < 0) {
            point.x = (int)(((double)this.degrees360() + (double)point.x) % (double)this.degrees360());
        }
        if (!this.screenRect.contains(point)) {
            return;
        }
        this.drawLine(graphics, Color.blue, point, (double)report.speed * ((double)l / 3600000.0), report.course);
    }

    public boolean keyDown(Event event, int n) {
        boolean bl = (event.modifiers & 1) != 0;
        switch (n) {
            case 68: 
            case 100: 
            case 1003: {
                this.zoom(true, bl);
                break;
            }
            case 85: 
            case 117: 
            case 1002: {
                this.zoom(false, bl);
                break;
            }
            case 1004: {
                this.moveCenter(new XY(0.0, -((double)this.size().height) / 2.0), bl);
                break;
            }
            case 1005: {
                this.moveCenter(new XY(0.0, (double)this.size().height / 2.0), bl);
                break;
            }
            case 1006: {
                this.moveCenter(new XY(-((double)this.size().width) / 2.0, 0.0), bl);
                break;
            }
            case 1007: {
                this.moveCenter(new XY((double)this.size().width / 2.0, 0.0), bl);
                break;
            }
            case 78: 
            case 110: {
                if (this.lastCall != null && this.theApplet.theLog != null) {
                    StationHistory stationHistory = this.theApplet.theLog.findStation(this.lastCall);
                    stationHistory.dumpAll(this.theApplet.theSystem, true);
                }
                return true;
            }
            case 84: 
            case 116: {
                if (this.lastCall != null && this.theApplet.theLog != null) {
                    StationHistory stationHistory = this.theApplet.theLog.findStation(this.lastCall);
                    if (stationHistory != null && stationHistory.position != null) {
                        this.recenter(stationHistory.position.position);
                        this.theApplet.theParams.homeID = stationHistory.ID;
                        this.theApplet.theParams.mapTrack = true;
                        this.theApplet.showStatus("Tracking " + stationHistory.ID);
                        this.theApplet.theSystem.println("Tracking " + stationHistory.ID);
                        this.initMap();
                        this.hide();
                        this.show();
                        this.requestFocus();
                        return true;
                    }
                } else if (this.theApplet.theParams.mapTrack) {
                    this.theApplet.theParams.homeID = null;
                    this.theApplet.theParams.mapTrack = false;
                    this.theApplet.showStatus("Tracking Reset");
                    this.theApplet.theSystem.println("Tracking Reset");
                    this.hide();
                    this.show();
                    this.requestFocus();
                    return true;
                }
                return true;
            }
            case 82: 
            case 114: {
                StationHistory stationHistory;
                if (this.lastCall != null && this.theApplet.theLog != null && (stationHistory = this.theApplet.theLog.findStation(this.lastCall)) != null && stationHistory.position != null) {
                    this.deadReckon(stationHistory.position);
                }
                return true;
            }
            case 67: 
            case 99: {
                this.theApplet.theParams.drawCircles = !this.theApplet.theParams.drawCircles;
                this.hide();
                this.show();
                this.requestFocus();
                return true;
            }
            default: {
                return false;
            }
        }
        this.initMap();
        this.hide();
        this.show();
        this.requestFocus();
        return true;
    }

    protected XY toMapXY(Point point) {
        return this.toMapXY(new XY(point));
    }

    protected XY toMapXY(XY xY) {
        XY xY2 = new XY(xY);
        xY2.reverseOffsetXY(this.screenCenterXY);
        xY2.y = -xY2.y;
        this.scaleToMap(xY2);
        xY2.offsetXY(this.mapScreenCenterXY);
        return xY2;
    }

    protected XY toScreenXY(XY xY) {
        XY xY2 = new XY(xY);
        xY2.reverseOffsetXY(this.mapScreenCenterXY);
        this.scaleToScreen(xY2);
        xY2.y = -xY2.y;
        xY2.offsetXY(this.screenCenterXY);
        return xY2;
    }

    abstract void initMap();

    protected XY toMapXY(LatLon latLon) {
        if (latLon.isNaN() || Math.abs(latLon.lat) > 90.0) {
            return new XY(Double.NaN, Double.NaN);
        }
        XY xY = this.mapProjection.toMapXY(latLon);
        double d = xY.x - this.mapScreenCenterXY.x;
        if (Math.abs(d) > 180.0) {
            xY.x = -Trig.sign(d) * (360.0 - Math.abs(d)) + this.mapScreenCenterXY.x;
        }
        return xY;
    }

    void drawOverlay(Graphics graphics, int n, Point point) {
        if (graphics == null) {
            return;
        }
        if (this.theApplet.iconImage[n + 256] == null && this.theApplet.overlayIcons != null) {
            try {
                this.theApplet.iconImage[n + 256] = this.theApplet.createImage(new FilteredImageSource(this.theApplet.overlayIcons.getSource(), new CropImageFilter(n / 16 * 16, n % 16 * 16, 16, 16)));
                this.theApplet.tracker.addImage(this.theApplet.iconImage[n + 256], 1);
                try {
                    this.theApplet.tracker.waitForID(1);
                }
                catch (InterruptedException interruptedException) {}
                if (this.theApplet.tracker.isErrorID(1)) {
                    this.theApplet.theSystem.println(this.theApplet.tracker.getErrorsAny().toString());
                    this.theApplet.tracker.removeImage(this.theApplet.iconImage[n + 256]);
                    this.theApplet.iconImage[n + 256] = null;
                }
            }
            catch (Exception exception) {
                this.theApplet.theSystem.println("overlay: " + n + " error: " + exception);
            }
        }
        if (this.theApplet.iconImage[n + 256] != null) {
            if (this.theApplet.theParams.iconScale == 1.0) {
                graphics.drawImage(this.theApplet.iconImage[n + 256], point.x - 8, point.y - 8, null);
                return;
            }
            int n2 = (int)Math.round(16.0 * this.theApplet.theParams.iconScale);
            graphics.drawImage(this.theApplet.iconImage[n + 256], point.x - n2 / 2, point.y - n2 / 2, n2, n2, null);
            return;
        }
        this.theApplet.theSystem.println("overlay is null: " + n);
    }

    private void drawOval(Graphics graphics, Color color, Point point, double d, int n) {
        if ((double)n == 0.0) {
            this.drawOval(graphics, color, point, d);
            return;
        }
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        switch (n) {
            case 45: {
                d3 = 0.5;
                d5 = 0.5;
                break;
            }
            case 90: {
                d5 = 0.5;
                break;
            }
            case 135: {
                d2 = 0.5;
                d5 = 0.5;
                break;
            }
            case 180: {
                d2 = 0.5;
                break;
            }
            case 225: {
                d2 = 0.5;
                d4 = 0.5;
                break;
            }
            case 270: {
                d4 = 0.5;
                break;
            }
            case 315: {
                d3 = 0.5;
                d4 = 0.5;
                break;
            }
            case 360: {
                d3 = 0.5;
            }
        }
        LatLon latLon = this.toLatLon(point);
        XY xY = this.toMapXY(latLon.latLonAtDistance(d * d2, 0.0));
        XY xY2 = this.toMapXY(latLon.latLonAtDistance(d * d3, 180.0));
        XY xY3 = this.toMapXY(latLon.latLonAtDistance(d * d5, 270.0));
        XY xY4 = this.toMapXY(latLon.latLonAtDistance(d * d4, 90.0));
        if (xY.isNaN() || xY2.isNaN() || xY3.isNaN() || xY4.isNaN()) {
            return;
        }
        xY.x = xY3.x;
        xY2.x = xY4.x;
        Point point2 = this.toPixel(xY);
        Point point3 = this.toPixel(xY2);
        if (point2.x < point3.x - 32 && point2.y < point3.y - 32) {
            graphics.setColor(color);
            graphics.drawOval(point2.x, point2.y, 1 + point3.x - point2.x, 1 + point3.y - point2.y);
        }
    }

    public String toString() {
        String string = this.getName() + ":";
        string = string + "\r\nmapSize: " + this.mapSize.toString();
        string = string + "\r\nmapCenterLL: " + this.mapProjection.mapCenterLL.toString();
        string = string + "\r\nmapCenterXY: " + this.toMapXY(this.mapProjection.mapCenterLL).toString();
        string = string + "\r\nmapPPDXY: " + this.mapPPDXY.toString();
        string = string + "\r\nmapScreenCenterXY: " + this.mapScreenCenterXY.toString();
        string = string + "\r\nscreenCenterXY: " + this.screenCenterXY.toString();
        string = string + "\r\nscreenCenterLL: " + this.screenCenterLL.toString();
        string = string + "\r\nscreenScaleXY: " + this.screenScaleXY.toString();
        return string;
    }

    protected APRSMap(javAPRS javAPRS2) {
        this.theApplet = javAPRS2;
        this.resize(this.theApplet.mapPanel.size());
        this.screenRect = new Rectangle(this.size());
        this.screenCenterXY = new XY(((double)this.size().width - 1.0) / 2.0, ((double)this.size().height - 1.0) / 2.0);
        this.mapSize = new XY((double)this.size().width, (double)this.size().height);
        this.show();
        this.requestFocus();
    }

    private void drawOval(Graphics graphics, Color color, Point point, double d) {
        LatLon latLon = this.toLatLon(point);
        XY xY = this.toMapXY(latLon.latLonAtDistance(d, 0.0));
        XY xY2 = this.toMapXY(latLon.latLonAtDistance(d, 180.0));
        XY xY3 = this.toMapXY(latLon.latLonAtDistance(d, 270.0));
        XY xY4 = this.toMapXY(latLon.latLonAtDistance(d, 90.0));
        if (xY.isNaN() || xY2.isNaN() || xY3.isNaN() || xY4.isNaN()) {
            return;
        }
        xY.x = xY3.x;
        xY2.x = xY4.x;
        Point point2 = this.toPixel(xY);
        Point point3 = this.toPixel(xY2);
        if (point2.x < point3.x - 32 && point2.y < point3.y - 32) {
            graphics.setColor(color);
            graphics.drawOval(point2.x, point2.y, 1 + point3.x - point2.x, 1 + point3.y - point2.y);
        }
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            this.mapInvalid = false;
            return;
        }
        this.mapInvalid = true;
        if (this.firstrun) {
            graphics.setColor(this.theApplet.theParams.backgroundColor);
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            this.drawLoadingString(this.getClass().getName());
            this.getMap();
            this.firstrun = false;
        }
        if (this.mapImage != null) {
            graphics.drawImage(this.mapImage, 0, 0, this.theApplet.theParams.backgroundColor, null);
        }
        this.mapInvalid = false;
        if (this.theApplet.theParams.stationList && this.theApplet.theLog != null) {
            this.theApplet.theLog.drawHistory(graphics, this.theApplet.theParams.trackStations);
        }
    }

    protected void recenter(LatLon latLon) {
        if (latLon.isNaN()) {
            return;
        }
        this.screenCenterLL = new LatLon(latLon);
        this.mapScreenCenterXY = this.toMapXY(this.screenCenterLL);
    }

    void drawIcon(Graphics graphics, int n, Point point) {
        block11: {
            if (graphics == null) {
                return;
            }
            if (this.theApplet.iconImage[n] == null) {
                try {
                    CropImageFilter cropImageFilter;
                    Image image = this.theApplet.allIcons;
                    if (n > 127 && n < 256) {
                        image = this.theApplet.allAltIcons;
                        cropImageFilter = new CropImageFilter((n - 128) / 16 * 16, (n - 128) % 16 * 16, 16, 16);
                    } else {
                        cropImageFilter = new CropImageFilter(n / 16 * 16, n % 16 * 16, 16, 16);
                    }
                    if (image == null) break block11;
                    this.theApplet.iconImage[n] = this.theApplet.createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
                    this.theApplet.tracker.addImage(this.theApplet.iconImage[n], 1);
                    try {
                        this.theApplet.tracker.waitForID(1);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.theApplet.tracker.isErrorID(1)) {
                        this.theApplet.theSystem.println(this.theApplet.tracker.getErrorsAny().toString());
                        this.theApplet.tracker.removeImage(this.theApplet.iconImage[n]);
                        this.theApplet.iconImage[n] = null;
                    }
                }
                catch (Exception exception) {
                    this.theApplet.theSystem.println("icon: " + n + " error: " + exception);
                }
            }
        }
        if (this.theApplet.iconImage[n] != null) {
            if (this.theApplet.theParams.iconScale == 1.0) {
                graphics.drawImage(this.theApplet.iconImage[n], point.x - 8, point.y - 8, null);
                return;
            }
            int n2 = (int)Math.round(16.0 * this.theApplet.theParams.iconScale);
            graphics.drawImage(this.theApplet.iconImage[n], point.x - n2 / 2, point.y - n2 / 2, n2, n2, null);
            return;
        }
        graphics.setColor(this.theApplet.theParams.plotColor);
        graphics.fillOval(point.x - 2, point.y - 2, 4, 4);
        this.theApplet.theSystem.println("icon is null: " + n);
    }

    void drawIcon(Graphics graphics, int n, Point point, String string) {
        this.drawIcon(graphics, n, point);
        graphics.setFont(this.theApplet.theFont);
        this.drawIconName(string, point, graphics);
    }

    void drawIcon(Graphics graphics, int n, Point point, double d, double d2, boolean bl) {
        this.drawIcon(graphics, n, point);
        if (d2 > 0.0) {
            if (bl) {
                this.drawLine(graphics, this.theApplet.theParams.plotColor, point, d2 / 1.150779, d);
                return;
            }
            this.drawLine(graphics, this.theApplet.theParams.plotColor, point, d2, d);
        }
    }

    void drawIcon(Graphics graphics, int n, Point point, String string, double d, double d2, boolean bl) {
        try {
            graphics.setFont(this.theApplet.theFont);
            this.drawIconName(string, point, graphics);
            this.drawIcon(graphics, n, point, d, d2, bl);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    void drawIcon(Report report) {
        Rectangle rectangle;
        if (this.mapInvalid) {
            return;
        }
        if (this.theApplet.checkFilter(report)) {
            return;
        }
        if (report.position.isNaN()) {
            return;
        }
        if (Math.round(report.position.lat) == 0L && Math.round(report.position.lon) == 0L) {
            return;
        }
        Graphics graphics = this.getGraphics();
        Point point = this.toPixel(report.position);
        if (this.theApplet.theParams.mapTrack && report.ID.equals(this.theApplet.theParams.homeID) && !(rectangle = new Rectangle(this.screenRect.width / 4, this.screenRect.height / 4, this.screenRect.width / 2, this.screenRect.height / 2)).contains(point)) {
            this.recenter(report.position);
            this.initMap();
            this.hide();
            this.show();
            this.requestFocus();
            return;
        }
        if (report.reportType == "Object" && report.altIcons && report.overlay == 0 && report.icon + 32 == 108 && report.course > 0 && report.speed > 0) {
            double d = Math.pow(report.course % 100, 2.0) / 100.0;
            double d2 = Math.pow(report.speed % 100, 2.0) / 100.0;
            int n = report.course / 100;
            LatLon latLon = n == 6 ? new LatLon(report.position.lat - d, report.position.lon - d2) : new LatLon(report.position.lat - d, report.position.lon + d2);
            if (latLon.isNaN()) {
                return;
            }
            XY xY = this.mapProjection.toMapXY(report.position);
            XY xY2 = this.toMapXY(report.position);
            XY xY3 = this.mapProjection.toMapXY(latLon);
            XY xY4 = this.toMapXY(latLon);
            if (xY.equals(xY2) && xY3.equals(xY4) || !xY.equals(xY2) && !xY3.equals(xY4)) {
                Point point2 = this.toPixel(latLon);
                if (point2.equals(point)) {
                    return;
                }
                Rectangle rectangle2 = new Rectangle(point.x, point.y, point2.x - point.x + 1, point2.y - point.y + 1);
                if (!this.screenRect.intersects(rectangle2)) {
                    return;
                }
                graphics.setColor(DosMapLine.getColor(report.speed / 100 + 8));
                switch (n) {
                    case 0: {
                        graphics.drawOval(point2.x - (point2.y - point.y), point.y, (point2.y - point.y) * 2, (point2.y - point.y) * 2);
                        break;
                    }
                    case 1: 
                    case 6: {
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        break;
                    }
                    case 2: {
                        graphics.drawOval(point.x, point.y, point2.x - point.x, point2.y - point.y);
                        break;
                    }
                    case 3: {
                        int[] nArray = new int[3];
                        int[] nArray2 = new int[3];
                        nArray[0] = point.x;
                        nArray2[0] = point.y;
                        nArray[1] = point2.x;
                        nArray2[1] = point2.y;
                        nArray[2] = point.x - (point2.x - point.x);
                        nArray2[2] = point2.y;
                        graphics.drawPolygon(nArray, nArray2, 3);
                        break;
                    }
                    case 4: {
                        graphics.drawRect(point.x, point.y, point2.x - point.x, point2.y - point.y);
                        break;
                    }
                    case 5: {
                        graphics.fillOval(point2.x - (point2.y - point.y), point.y, (point2.y - point.y) * 2, (point2.y - point.y) * 2);
                        break;
                    }
                    case 7: {
                        graphics.fillOval(point.x, point.y, point2.x - point.x, point2.y - point.y);
                        break;
                    }
                    case 8: {
                        int[] nArray = new int[3];
                        int[] nArray3 = new int[3];
                        nArray[0] = point.x;
                        nArray3[0] = point.y;
                        nArray[1] = point2.x;
                        nArray3[1] = point2.y;
                        nArray[2] = point.x - (point2.x - point.x);
                        nArray3[2] = point2.y;
                        graphics.fillPolygon(nArray, nArray3, 3);
                        break;
                    }
                    case 9: {
                        graphics.fillRect(point.x, point.y, point2.x - point.x, point2.y - point.y);
                    }
                }
                if (this.theApplet.theParams.showStationNames && (double)this.theApplet.theParams.autoDisplayID < this.mapPPDXY.x) {
                    graphics.setFont(this.theApplet.theFont);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n2 = fontMetrics.stringWidth(report.ID);
                    Point point3 = new Point(point);
                    switch (n) {
                        case 0: 
                        case 5: {
                            point3 = point2;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 9: {
                            point3 = new Point(point);
                            point3.y += (point2.y - point.y) / 2 - 3;
                            point3.x += (point2.x - point.x - n2) / 2;
                            break;
                        }
                        case 3: 
                        case 8: {
                            point3 = new Point(point);
                            point3.y += (point2.y - point.y) / 2 - 3;
                            point3.x -= n2 / 2;
                            break;
                        }
                        case 6: {
                            point3 = new Point(point);
                            point3.y += (point2.y - point.y) / 2 - 3;
                            point3.x -= (point.x - point2.x - n2) / 2;
                        }
                    }
                    this.drawIconName(report.ID, point3, graphics);
                }
            }
            return;
        }
        if (!this.screenRect.contains(point)) {
            return;
        }
        int n = report.icon;
        if (report.altIcons) {
            n += 128;
        }
        if ((report.reportType == "Item" || report.reportType == "Object") && report.altIcons && report.icon + 32 == 109 && report.overlay == 0 && report.signpost.length() > 0) {
            this.drawIcon(graphics, n, point);
            graphics.setColor(Color.black);
            graphics.setFont(new Font("Helvetica", 0, 8));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = fontMetrics.stringWidth(report.signpost);
            graphics.drawString(report.signpost, point.x - n3 / 2, point.y + 3);
            if (this.theApplet.theParams.showStationNames && (double)this.theApplet.theParams.autoDisplayID < this.mapPPDXY.x) {
                graphics.setFont(this.theApplet.theFont);
                this.drawIconName(report.ID, point, graphics);
            }
        } else if (this.theApplet.theParams.showStationNames && (double)this.theApplet.theParams.autoDisplayID < this.mapPPDXY.x) {
            if (this.theApplet.theParams.drawVectors) {
                if (this.theApplet.theParams.displayWxOnly) {
                    if (report.temperature > -100) {
                        this.drawIcon(graphics, n, point, String.valueOf(report.temperature), report.course, report.speed, report.validWX);
                    } else {
                        this.drawIcon(graphics, n, point, "-", report.course, report.speed, report.validWX);
                    }
                } else {
                    this.drawIcon(graphics, n, point, report.ID, report.course, report.speed, report.validWX);
                }
            } else {
                this.drawIcon(graphics, n, point, report.ID);
            }
            this.drawRange(graphics, point, report);
        } else {
            if (this.theApplet.theParams.drawVectors) {
                this.drawIcon(graphics, n, point, report.course, report.speed, report.validWX);
            } else {
                this.drawIcon(graphics, n, point);
            }
            this.drawRange(graphics, point, report);
        }
        if (report.icon == 32 && this.theApplet.theParams.showHurricaneRadius) {
            if (report.sfw > 0) {
                this.drawOval(graphics, Color.green, point, report.sfw);
            }
            if (report.gfw > 0) {
                this.drawOval(graphics, Color.yellow, point, report.gfw);
            }
            if (report.hfw > 0) {
                this.drawOval(graphics, Color.red, point, report.hfw);
            }
        }
        if (report.overlay != 0) {
            this.drawOverlay(graphics, report.overlay, point);
        }
    }

    protected void scaleToMap(XY xY) {
        xY.reverseScale(this.screenScaleXY);
        xY.reverseScale(this.mapPPDXY);
    }

    protected void moveCenter(XY xY, boolean bl) {
        if (bl) {
            xY.x *= 2.0;
            xY.y *= 2.0;
        }
        XY xY2 = new XY(this.screenCenterXY);
        xY2.offsetXY(xY);
        this.recenter(this.toLatLon(this.toMapXY(xY2)));
    }

    protected void moveCenter(Point point) {
        this.recenter(this.toLatLon(point));
    }

    private int degrees360() {
        return (int)Math.round(360.0 * this.screenScaleXY.x * this.mapPPDXY.x);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = (event.modifiers & 1) != 0;
        if ((event.modifiers & 0xC) != 0) {
            this.moveCenter(new Point(n, n2));
            this.zoom(true, bl);
            this.initMap();
            this.hide();
            this.show();
        } else if ((event.modifiers & 2) != 0) {
            this.moveCenter(new Point(n, n2));
            this.initMap();
            this.hide();
            this.show();
        } else {
            StationHistory stationHistory = null;
            if (this.theApplet.theLog != null) {
                stationHistory = this.theApplet.theLog.search(new Point(n, n2));
            }
            if (stationHistory == null) {
                LatLon latLon;
                if (this.lastCall != null) {
                    if (this.theApplet.theLog != null) {
                        stationHistory = this.theApplet.theLog.findStation(this.lastCall);
                    }
                    this.lastCall = null;
                    if (stationHistory != null) {
                        if (stationHistory.wx != null) {
                            this.drawIcon(stationHistory.wx);
                        } else {
                            this.drawIcon(stationHistory.position);
                        }
                    }
                }
                if ((latLon = this.toLatLon(n, n2)).isNaN()) {
                    return true;
                }
                if (this.theApplet.theParams.homeID != null) {
                    stationHistory = this.theApplet.theLog.findStation(this.theApplet.theParams.homeID);
                    if (stationHistory != null) {
                        if (Report.metric) {
                            this.theApplet.showStatus(latLon.toString() + "  distance: " + Math.round(stationHistory.position.position.distanceTo(latLon) * 1.609344) + " kilometers bearing: " + Math.round(stationHistory.position.position.bearingTo(latLon)) + "\u00b0");
                        } else {
                            this.theApplet.showStatus(latLon.toString() + "  distance: " + Math.round(stationHistory.position.position.distanceTo(latLon)) + " miles bearing: " + Math.round(stationHistory.position.position.bearingTo(latLon)) + "\u00b0");
                        }
                    }
                } else {
                    this.theApplet.showStatus(latLon.toString());
                }
            } else {
                if (this.lastCall != null) {
                    StationHistory stationHistory2 = this.theApplet.theLog.findStation(this.lastCall);
                    this.lastCall = stationHistory.ID;
                    if (stationHistory2 != null) {
                        if (stationHistory2.wx != null) {
                            this.drawIcon(stationHistory2.wx);
                        } else {
                            this.drawIcon(stationHistory2.position);
                        }
                    }
                } else {
                    this.lastCall = stationHistory.ID;
                }
                if (this.theApplet.theParams.showStatusRaw) {
                    this.theApplet.showStatus(new String(stationHistory.position.theData));
                } else if (stationHistory.wx != null) {
                    this.theApplet.showStatus(stationHistory.wx.toString1());
                } else {
                    this.theApplet.showStatus(stationHistory.position.toString1());
                }
                if (stationHistory.wx != null) {
                    this.drawIcon(stationHistory.wx);
                } else {
                    this.drawIcon(stationHistory.position);
                }
            }
        }
        this.requestFocus();
        return true;
    }

    public boolean action(Event event, Object object) {
        this.theApplet.theSystem.println(event.toString());
        return false;
    }
}

