/* *SIMPLE* program to decode the TNOS Features Flags from the
   Features Map produced by 'tnos -m'
 */

 
#include <stdio.h>
#include "map.h"


#define CHECKFOR(y)	if (string[y##_OFF] & y##_VAL)	printf (format, #y)

#define PLAIN	0
#define HEADER	1
#define CONFIG	2

unsigned char string[MAPLENGTH + 1];

char const *format = "%s\n";
char const *format2 = "%s\t%d\n";

void
main (int argc, char *argv[])
{
int index = 1;
char *tmp;
unsigned char *cp;
char buf[3];
int ch;
int mode = PLAIN;

	if (argc > 1 && !strcmp (argv[1], "-c"))	{
		format = "set %s\t1\n";
		format2 = "set %s\t%d\n";
		argc--;
		++argv;
		mode = CONFIG;
	} else if (argc > 1 && !strcmp (argv[1], "-h"))	{
		format = "#define %s\t1\n";
		format2 = "#define %s\t%d\n";
		argc--;
		++argv;
		mode = HEADER;
	}
	if (argc == 4 && !strcmp (argv[1], "Features") && !strcmp (argv[2], "map:"))
		index = 3;
	tmp = argv[index];
	cp = string;
	while (*tmp)	{
		buf[0] = *tmp++;
		buf[1] = *tmp++;
		buf[2] = 0;
		sscanf (buf, "%x", &ch);
		*cp++ = ch;
	}

	CHECKFOR(ALERTMONITOR);
	CHECKFOR(ALLCMD);
	CHECKFOR(ALLSERV);
	CHECKFOR(ALLSESSIONS);
	CHECKFOR(ALTERBID);
	CHECKFOR(ARCNET);
	CHECKFOR(ASKHOME);
	CHECKFOR(ASY);
	CHECKFOR(ATCMD);
	CHECKFOR(AUTOROUTE);
	CHECKFOR(AXBCSTR);
	CHECKFOR(AXIP);
	CHECKFOR(AXUI);
	CHECKFOR(BBSEXPORT);
	CHECKFOR(BBSIMPORT);
	CHECKFOR(BOOTPCLIENT);
	CHECKFOR(BOOTPSERVER);
	CHECKFOR(BROWSER);
	CHECKFOR(CALLBOOK);
	CHECKFOR(CALLCLI);
	CHECKFOR(CALLSERVER);
	CHECKFOR(CATALOG);
	CHECKFOR(CONVERS);
	CHECKFOR(CRONTAB);
	CHECKFOR(DELEGATE);
	CHECKFOR(DIALER);
	CHECKFOR(DOS_GETFILEATTR);
	CHECKFOR(DRSI);
	CHECKFOR(DSERVER);
	CHECKFOR(EAGLE);
	CHECKFOR(EDITHEADERS);
	CHECKFOR(ENCAP);
	CHECKFOR(ESCAPE);
	CHECKFOR(EXPIRY);
	CHECKFOR(FBBCMP);
	CHECKFOR(FBBFWD);
	CHECKFOR(FIFOSERVER);
	CHECKFOR(FILECMDS);
	CHECKFOR(FOQ_CMDS);
	CHECKFOR(FORTH);
	CHECKFOR(FTPTDISC);
	CHECKFOR(GATECMDS);
	CHECKFOR(GPS);
	CHECKFOR(HAPN);
	CHECKFOR(HOLDMODS);
	CHECKFOR(HOLDMONITOR);
	CHECKFOR(HOPCHECK);
	CHECKFOR(HOPPER);
	CHECKFOR(HS);
	CHECKFOR(HTTPPBBS);
	CHECKFOR(HTTP);
	CHECKFOR(IPACCESS);
	CHECKFOR(ISUNIX);
	CHECKFOR(KISS);
	CHECKFOR(LOCK);
	CHECKFOR(LOG_GMT_TZ);
	CHECKFOR(LOOKSESSION);
	CHECKFOR(LZW);
	CHECKFOR(MAILBOX);
	CHECKFOR(MAILCMDS);
	CHECKFOR(MAILFILTER);
	CHECKFOR(MAILFOR);
	CHECKFOR(MBFWD);
	CHECKFOR(MBXTDISC);
	CHECKFOR(MESSAGESERVER);
	CHECKFOR(MONITOR);
	CHECKFOR(NETROM);
	CHECKFOR(NNTPFILTER);
	CHECKFOR(NNTPS);
	CHECKFOR(NNTP);
	CHECKFOR(NODECALL);
	CHECKFOR(NR4TDISC);
	CHECKFOR(NRS);
	CHECKFOR(PACKET);
	CHECKFOR(PC100);
	CHECKFOR(PC_EC);
	CHECKFOR(PI);
	CHECKFOR(PING_SECURE);
	CHECKFOR(PIPECMD);
	CHECKFOR(POLLEDKISS);
	CHECKFOR(POOLED);
	CHECKFOR(POP2CLIENT);
	CHECKFOR(POP2SERVER);
	CHECKFOR(POP3CLIENT);
	CHECKFOR(POP3SERVER);
	CHECKFOR(POP);
	CHECKFOR(PPP);
	CHECKFOR(QRZCALLB);
	CHECKFOR(RARP);
	CHECKFOR(RDATE);
	CHECKFOR(REJECT);
	CHECKFOR(REQSVR);
	CHECKFOR(RIP);
	CHECKFOR(RLINE);
	CHECKFOR(RLOGINCLI);
	CHECKFOR(RLOGINSERV);
	CHECKFOR(RMAIL);
	CHECKFOR(ROUTESERVER);
	CHECKFOR(RSPF);
	CHECKFOR(RXECHO);
	CHECKFOR(SAMCALLB);
	CHECKFOR(SCC);
	CHECKFOR(SCREENSAVER);
	CHECKFOR(SCRIPTING);
	CHECKFOR(SERVERS);
	CHECKFOR(SETPSINFO);
	CHECKFOR(SHELL);
	CHECKFOR(SLFP);
	CHECKFOR(SLIP);
	CHECKFOR(SM_CURSES);
	CHECKFOR(SM_DUMB);
	CHECKFOR(SM_RAW);
	CHECKFOR(SOUNDS);
	CHECKFOR(SQL);
	CHECKFOR(STATS_AREA);
	CHECKFOR(STATS_FWD);
	CHECKFOR(STATS_HTTP);
	CHECKFOR(STATS_MSG);
	CHECKFOR(STATS);
	CHECKFOR(STATS_TFC);
	CHECKFOR(STATS_USE);
	CHECKFOR(STRICT_CALL);
	CHECKFOR(STRICT_HTTPCALL);
	CHECKFOR(TCPACCESS);
	CHECKFOR(TCPGATE);
	CHECKFOR(TERMSERVER);
	CHECKFOR(TIPMAIL);
	CHECKFOR(TRACESERVER);
	CHECKFOR(TRACE);
	CHECKFOR(TRANSLATE);
	CHECKFOR(TSCRIPTSERVER);
	CHECKFOR(TTYCALL);
	CHECKFOR(TUTOR);
	CHECKFOR(UDPACCESS);
	CHECKFOR(UNIX_SOCKETS);
	CHECKFOR(USEPOP3);
	CHECKFOR(USERLOG);
	CHECKFOR(USE_TZOFFSET);
	CHECKFOR(VERSION_ON_FILE);
	CHECKFOR(VJCOMPRESS);
	CHECKFOR(WPAGES);
	CHECKFOR(XFWD);
	CHECKFOR(XMODEM);
	CHECKFOR(XSERVER);

	CHECKFOR(UNUSED1);

	if (mode != PLAIN)	{
		printf (format2, "MTHRESH", 16384);
		printf (format2, "NROWS", 25);
		printf (format2, "NIBUFS", 10);
		printf (format2, "IBUFSIZE", 1024);
		printf (format2, "NSESSIONS", 20);
		printf (format2, "DEFNSOCK", 40);
	}
}
