/* the structures used for message statistics */


struct msg_stats	{
	long	days;			/* days that stats are valid for */

	/* these are each 2 element arrays, [0] is incoming, [1] is outgoing */
	long	messages[2];		/* total cumulative messages */

	/* these are for daily and weekly stats - 2 element arrays, as before */
	long	hourly[24][2];		/* hourly messages */
	long	daily[7][2];		/* daily messages */
	long	monthly[31][2];		/* day/month messages */
	long	yearly[12][2];		/* month/year messages */

	/* these are the current hour and day - not updated till period is complete */
	long	hour[2];		/* current hour's usage in 1/10 minute */
	long	day[2];			/* current day's usage in 1/10 minute */
	long	month[2];		/* current year's usage in 1/10 minute */

	/* last stats start time */
	time_t	start;

	/* last update time */
	time_t	last;
};




