/* Mods by PA0GRI */
#ifndef	_SOCKET_H
#define	_SOCKET_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#if !defined(_STDARG_H) && !defined(__dj_include_stdarg_h_)
#include <stdarg.h>
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef _PROC_H
#include "proc.h"
#endif

#ifndef _SOCKADDR_H
#include "sockaddr.h"
#endif

/* Local IP wildcard address */
#ifndef INADDR_ANY
#define	INADDR_ANY	0x0L
#endif

/* IP protocol numbers */
/* now in internet.h */

/* TCP port numbers */
#define	IPPORT_ECHO	7	/* Echo data port */
#define	IPPORT_DISCARD	9	/* Discard data port */
#define	IPPORT_DAYTIME	13	/* Daytime data port */
#define IPPORT_QUOTE	17	/* Quote of the day port */
#define	IPPORT_FTPD	20	/* FTP Data port */
#define	IPPORT_FTP	21	/* FTP Control port */
#define IPPORT_TELNET	23	/* Telnet port */
#define IPPORT_SMTP	25	/* Mail port */
#define	IPPORT_TIME	37	/* Time data port */
#define IPPORT_TFTPD    69	/* TFTP data port */
#define	IPPORT_FINGER	79	/* Finger port */
#define IPPORT_HTTP	80	/* HTTP port */
#define	IPPORT_TTYLINK	87	/* Chat port */
#define	IPPORT_POP	109	/* Pop port */
#define	IPPORT_POP2	109	/* Pop port */
#define IPPORT_POP3	110	/* Pop port */
#define IPPORT_NNTP	119	/* Netnews port */
#define	IPPORT_RLOGIN	513	/* Remote login */
#define IPPORT_CALLDB	1235	/* Pulled out of the air GRACILIS */
#define IPPORT_TRACE	1236	/* Pulled out of the air - WG7J */
#define IPPORT_FTELNET	2323	/* FBB/Telnet port */
#define IPPORT_NEWS     3597    /* News Tutorial */
#define IPPORT_INFO     3598    /* Info Tutorial */
#define IPPORT_TUTOR    3599    /* Tutorial */
#define	IPPORT_CONVERS	3600	/* Converse */
#define IPPORT_XCONVERS 3601    /* LZW Convers */
#define IPPORT_TERM	5000	/* Serial interface server port */
#define IPPORT_CBS	7373	/* KO4KS CallBook Server port */
#define IPPORT_X	7388	/* X server control port (out of the air) */
#define	IPPORT_ROUTE	8873	/* Dynamic route server */

/* UDP port numbers */
#define	IPPORT_DOMAIN	53
#define	IPPORT_BOOTPS	67	/* bootp server */
#define	IPPORT_BOOTPC	68	/* bootp client */
#define	IPPORT_RWHO	513
#define	IPPORT_RIP	520
#define	IPPORT_TIMED	525	/* Time daemon */
#define	IPPORT_REMOTE	1234	/* Pulled out of the air */

#ifndef AF_INET
#define	AF_INET		0
#define	AF_AX25		1
#define AF_NETROM	2
#define	AF_LOCAL	3

#define	SOCK_STREAM	0
#define	SOCK_DGRAM	1
#define	SOCK_RAW	2
#define SOCK_SEQPACKET	3
#endif

/* Socket flag values - controls newline mapping */
#define	SOCK_BINARY	0	/* socket in raw (binary) mode */
#define	SOCK_ASCII	1	/* socket in cooked (newline mapping) mode */
#define	SOCK_QUERY	2	/* Return setting without change */

/* Socket noblock values, set with sockblock() */
#define SOCK_BLOCK      0
#define SOCK_NOTXBLOCK  1
#define SOCK_NORXBLOCK  2


/*
 * Avoid collisions with the C library's socket interface.  We may want to use
 * that in the future, anyway.  (Something like WAMPES tcpgate, but with some
 * protections.)
 */

#define accept j_accept
#define bind j_bind
#define connect j_connect
#define getpeername j_getpeername
#define getsockname j_getsockname
#define listen j_listen
#define setflush j_setflush
#define shutdown j_shutdown
#define socket j_socket
#define socketpair j_socketpair
#define recv j_recv
#define recvfrom j_recvfrom
#define send j_send
#define sendto j_sendto


#ifdef UNIX
#define EABORT ECONNRESET
#ifdef linux
#define EALARM ETIME
#else
#define EALARM ETIMEDOUT
#endif

#else

#undef EMFILE
#define	EMFILE	1
#undef EBADF
#define	EBADF	2
#undef EINVAL
#define	EINVAL	3
#define	ESOCKTNOSUPPORT	4
#define	EAFNOSUPPORT	5
#define	EOPNOTSUPP	6
#undef EFAULT
#define	EFAULT		7
#define	ENOTCONN	8
#define	ECONNREFUSED	9
#define EAFNOSUPP	10
#define	EISCONN		11
#define	EWOULDBLOCK	12
#undef EINTR
#define	EINTR		13
#define	EADDRINUSE	14
#undef ENOMEM
#define	ENOMEM		15
#define EMSGSIZE	16
#define	EALARM		17
#define	EABORT		18

#endif

/* In socket.c: */
extern int Axi_sock;	/* Socket listening to AX25 (there can be only one) */

int accept (int s,char *peername,int *peernamelen);
int bind (int s,char *name,int namelen);
int close_s (int s);
int connect (int s,char *peername,int peernamelen);
void freesock (struct proc *pp);
int getpeername (int s,char *peername,int *peernamelen);
int getsockname (int s,char *name,int *namelen);
int listen (int s,int backlog);
int recv_mbuf (int s,struct mbuf **bpp,int flags,char *from,int *fromlen);
int send_mbuf (int s,struct mbuf *bp,int flags,char *to,int tolen);
int setflush (int s,int c);
int shutdown (int s,int how);
int socket (int af,int type,int protocol);
void sockinit (void);
int sockkick (int s);
int socklen (int s,int rtx);
struct proc *sockowner (int s,struct proc *newowner);
int usesock (int s);
int socketpair (int af,int type,int protocol,int sv[]);
int socketalive (int s);

/* In sockuser.c: */
int keywait (const char *prompt,int flush);
int recv (int s,char *buf,int len,int flags);
int recvchar (int s);
int recvfrom (int s,char *buf,int len,int flags,char *from,int *fromlen);
int nb_recvline (int s,unsigned char *buf,unsigned len);
int recvline (int s,unsigned char *buf,unsigned len);
int rrecvchar (int s);
int send (int s,char *buf,int len,int flags);
int sendto (int s,char *buf,int len,int flags,char *to,int tolen);
int seteol (int s,const char *seq);
int sockmode (int s,int mode);
void tflush (void);
/* declared in global.h
	int tprintf (const char *fmt,...);
 */
int tputc (unsigned char c);
int getblock (int s);
void traceprintf (FILE *fp, const char *fmt, ...)
#ifdef UNIX
#ifdef __GNUC__
    __attribute__ ((format (printf, 2, 3)))
#endif
#endif
    ;
int tcmdprintf (const char *fmt, ...)
#ifdef UNIX
#ifdef __GNUC__
    __attribute__ ((format (printf, 1, 2)))
#endif
    ;
int tfprintf (FILE *fp, const char *fmt, ...)
#ifdef __GNUC__
    __attribute__ ((format (printf, 2, 3)))
#endif
#endif
    ;
int usflush (int s);
int usprintf (int s,const char *fmt,...);
int usputc (int s,const unsigned char c);
int usputs (int s,const char *x);
int usputbuf (int s,const unsigned char *x, int len);
int usvprintf (int s,const char *fmt, va_list args);	/*lint !e49 !e601 !e10 !e49 */
int nullsocket (int s);

/* In file sockutil.c: */
char *psocket (void *p);
const char *sockerr (int s);
const char *sockstate (int s);

/* In mailbox.c: */
extern char Nosock[];

#endif	/* _SOCKET_H */
