#ifndef	_SMTP_H
#define	_SMTP_H

#define SMTPTRACE			/* enable tracing for smtp */
#define MAXSESSIONS	10		/* most connections allowed */
#define JOBNAME		13		/* max size of a job name with null */
#undef  LINELEN
#define	LINELEN		256
#define PLINELEN    256
#define RLINELEN	512
#define TLINELEN    1024
#undef  SLINELEN
#define SLINELEN    64
#define MBOXLEN		8		/* max size of a mail box name */

/* types of address used by smtp in an address list */
#define BADADDR		0
#define LOCAL		1
#define DOMAIN		2
#define NNTP_GATE	3

/* a list entry */
struct list {
	struct list *next;
	char *val;
	char *orig;
	char type;
};

/* Per-session control block  used by smtp server */
struct smtpsv {
	int s;			/* the socket for this connection */
	char *system;		/* Name of remote system */
	char *from;		/* sender address */
	char *sender;		/* actual original sender */
	struct list *to;	/* Linked list of recipients */
	char *bid;		/* BID if any */
	int dupbid;		/* indicates a duplicate bid */
#ifdef TRANSLATE
	int translated;
#endif
	FILE *data;		/* Temporary input file pointer */
};

/* used by smtpcli as a queue entry for a single message */
struct smtp_job {
	struct 	smtp_job *next;	/* pointer to next mail job for this system */
	char	jobname[9];	/* the prefix of the job file name */
#if 0
	long	len;		/* length of file */
#endif
	char	*from;		/* address of sender */
	struct list *to;	/* Linked list of recipients */
};

/* control structure used by an smtp client session */
struct smtpcli {
	int 	s;		/* connection socket */
	uint32	ipdest;		/* address of forwarding system */
	char	*destname;	/* domain address of forwarding system */
	char	*wname;		/* name of workfile */
	char	*tname;		/* name of data file */
	char	buf[LINELEN];	/* Output buffer */
#if 0
	char	cnt;		/* Length of input buffer */
#endif
	FILE	*tfile;
	struct	smtp_job *jobq;
	struct	list 	*errlog;	
	int lock;		/* In use */
};

/* smtp server routing mode */
#define	QUEUE	1

#define	NULLLIST	(struct list *)0
#define	NULLSMTPSV	(struct smtpsv *)0
#define	NULLSMTPCLI	(struct smtpcli *)0
#define NULLJOB		(struct smtp_job *)0

extern int Smtpmode;
#ifndef _FILES_H
#include "files.h"
#endif

/* In smtpserv.c: */
#ifndef _COMMANDS_H
char *ptime (time_t *t);
#endif
long get_msgid (int);
#ifndef _MAILUTIL_H
char *getname (char *cp);
#endif
int validate_address (const char *s);
int queuejob (FILE *dfile,char *host,struct list *to,const char *from);
struct list *addlist (struct list **head,const char *val,int type,const char *orig);
int mdaemon (FILE *data,const char *to,struct list *lp,int bounce);

/* In smtpcli.c: */
void smtptick (void *t);
#ifndef _MAILUTIL_H
int mlock (const char *thedir,char *id);
void rmlock (const char *thedir,char *id);
#endif
void del_list (struct list *lp);
uint32 mailroute (char *dest);
extern const char *Months[];

#endif	/* _SMTP_H */

