/* NETROM mailbox interface
 * Copyright 1991 Phil Karn, KA9Q
 *
 *  May '91 Bill Simpson
 *      move to separate file for compilation & linking
 */
#include "global.h"
#ifdef NETROM
#ifndef MSDOS
#include "ctype.h"
#endif
#include "commands.h"
#include "proc.h"
#include "netrom.h"
#include "session.h"
#include "mailbox.h"
#include "nr4mail.h"

#if !defined(_lint)
static char rcsid[] OPTIONAL = "$Id: nr4mail.c,v 1.13 1997/07/31 00:44:20 root Exp root $";
#endif

static int Nrsocket = -1;


int
nr4start (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
int s;

	if (Nrsocket != -1)
		return -1;

	ksignal (Curproc, 0);	/* Don't keep the parser waiting */
	server_disconnect_io ();
	chname (Curproc, "NETROM listener");
	Nrsocket = socket (AF_NETROM, SOCK_SEQPACKET, 0);
	/* bind() is done automatically */
	if (listen (Nrsocket, 1) == -1) {
		close_s (Nrsocket);
		Nrsocket = -1;
		return -1;
	}
	for (;;) {
		if ((s = accept (Nrsocket, NULLCHAR, NULLINT)) == -1)
			break;	/* Service is shutting down */
#ifdef MAILBOX
		/* Spawn a server */
		if (newproc ("pbbs", 2048, pbbs_incom, s, (void *) NR4_LINK, NULL, 0) == NULLPROC)
			close_s (s);
#else
		if (newproc ("TTYLINK Server", 2048, ttylhandle, s, (void *) NR4_LINK, NULL, 0) == NULLPROC)
			close_s (s);
#endif
	}
	close_s (Nrsocket);
	Nrsocket = -1;
	return 0;
}


int
nr40 (int argc OPTIONAL, char *argv[] OPTIONAL, void *p OPTIONAL)
{
	close_s (Nrsocket);
	Nrsocket = -1;
	return 0;
}

#endif /* NETROM */
