#ifndef	_FILES_H
#define	_FILES_H

#define	FTP_READ	1	/* Read files */
#define	FTP_CREATE	2	/* Create new files */
#define	FTP_WRITE	4	/* Overwrite or delete existing files */
#ifndef _MAILBOX_H
#define	AX25_CMD	8	/* AX.25 gateway operation allowed */
#define	TELNET_CMD	16	/* Telnet gateway operation allowed */
#define	NETROM_CMD	32	/* NET/ROM gateway operation allowed */
#define	SYSOP_CMD	64	/* Remote sysop access allowed */
#define	EXCLUDED_CMD	128	/* This user is banned from the BBS */
#endif
#define	PPP_ACCESS_PRIV	0x0100	/* Priv bit for PPP connection */
#define	PPP_PWD_LOOKUP	0x0200	/* Priv bit for peerID/pass lookup */
#define FILE_PATH_SIZE 256


/* External definitions for configuration-dependent file names set in
 * files.c
 */
extern const char *Alias;		/* the alias file */
extern const char *ANSIArea;		/* ANSI areas file */
extern const char *ANSILogin;		/* ANSI login file */
extern const char *AreaData;		/* Descriptions of message areas */
extern const char *AreaSlist;		/* List of message areas for sysops */
extern const char *CommandHelp;		/* Command Session Help file */
extern const char *ConfNews;		/* conference bridge news file */
extern const char *DomainFile;		/* Domain cache */
extern const char *EditorHelp;		/* Mini-Editor Help file */
extern const char *ETCdir;		/* the ETC directory */
extern const char *Fdbase;		/* Finger database file */
extern const char *FingerDir;		/* Finger info directory */
extern const char *FTPHelp;		/* FTP Help file */
extern const char *Ftpmotd;		/* FTP message of the day */
extern const char *Group;		/* the group file */
extern const char *Hostfile;		/* Remote FTP user and password */
extern const char *LOGdir;		/* log directory */
extern const char *Maillog;		/* mail log */
extern const char *Mailqdir;		/* Outgoing mail spool */
extern const char *Mailqueue;		/* Outgoing mail work files */
extern const char *Mailspool;		/* Incoming mail */
extern const char *MANdir;		/* Manual pages base directory */
extern const char *PBBSHelp;		/* PBBS Help file */
extern const char *MOTDfile;		/* PBBS MOTD file */
extern const char *MOTDsysfile;		/* PBBS MOTD file for SYSOPs */
extern const char *NEWUSERfile;		/* New PBBS User file */
extern const char *Onexit;		/* Cmds executed on exit */
extern const char *PublicDir;		/* public directory */
extern const char *Quotes;		/* List of quotes of the day */
extern const char *Rewritefile;		/* Address rewrite file */
extern const char *Routeqdir;		/* queue for router */
extern const char *SMILEYFile;		/* conf smiley file */
extern const char *Spool;		/* Spool directory */
extern const char *Startup;		/* Initialization file */
extern const char *Userfile;		/* Authorized FTP users and passwords */
extern const char *VersionFile;		/* Command Session version file */

#ifdef ASKHOME
extern const char *AskhomeFile;		/* Askhome prompt */
#endif

#ifdef BBSEXPORT
extern const char *EXPORTDir;		/* Export directory */
#endif

#ifdef BBSIMPORT
extern const char *IMPORTDir;		/* Import directory */
#endif

#ifdef BROWSER
extern const char *Cookiejar;		/* cookies received by local browser */
extern const char *IncomingURLs;	/* directory for files received by local browser */
extern const char *CheckedURLs;		/* files with checked URL data */
#endif

#ifdef CATALOG
extern const char *CATALOGfile;		/* String Catalog file */
#endif

#ifdef CONVERS
extern const char *ConfHlp;		/* Conference Help File */
extern const char *ConfInfo;		/* Conference user info */
extern const char *NetControlHlp;	/* Help file for Net Control functions */
#endif

#ifdef CRONTAB
extern const char *CRONTABFile;		/* Crontab file */
#endif

#ifdef DELEGATE
extern const char *DelegateFile;	/* delegation data file */
#endif

#ifdef ENCAP
extern const char *EncapRoutes;		/* Dynamic encap routes */
#endif

#ifdef EXPIRY
extern const char *Expirefile;		/* Message expiration control file */
#endif

#ifdef FIFOSERVER
extern const char *FIFO_IN;		/* FIFO input */
extern const char *FIFO_OUT;		/* FIFO output */
#endif

#ifdef GPS
extern const char *GPSfile;		/* All heard GPS position data */
#endif

#ifdef HOLDMODS
extern const char *UserHoldFile;	/* file w/user name to hold mail from */
extern const char *WordHoldFile;	/* file w/words to hold mail if found in */
#endif

#ifdef HTTP
extern const char *Cookiefile;		/* last cookie number assigned */
extern const char *Cookiedata;		/* cookies assigned */
extern const char *HTTPdir;		/* http root directory */
extern const char *HTTPheadfile;	/* http directory 'head' file */
extern const char *HTTPinclude;		/* http directory 'include' file */
extern const char *HTTPtailfile;	/* http directory 'tail' file */
#endif

#if defined(MAILBOX) || defined(DELEGATE) || defined(REQSVR) || defined(MAILFILTER)
extern const char *Helpdir;		/* Mailbox help file directory */
#endif

#ifdef MAILBOX
extern const char *Historyfile;		/* Message ID history file */
extern const char *Signature;		/* Mail signature file directory */
#endif

#ifdef MAILCMDS
extern const char *Arealist;		/* List of message areas */
#endif

#ifdef MAILFILTER
extern const char *FilterFile;
#endif

#ifdef MBFWD
extern const char *Forwardfile;		/* Mail forwarding file */
#endif

#ifdef NETROM
extern const char *Netromfile;		/* Netrom node save file */
#endif

#ifdef NODECALL
extern const char *NODEHelp;		/* NODE Help file */
extern const char *NODEInfo;		/* NODE Info file */
#endif

#if (defined(NNTP) || defined(NNTPS))
extern const char *NNTPdir;		/* News messages and NNTP data */
extern const char *NNTPaccess;
#endif

#ifdef NNTPS
extern const char *NNTPactive;
extern const char *NNTPforward;
extern const char *NNTPhistory;
extern const char *NEWS2Mail;
extern const char *NNTPhelp;
extern const char *NNTPinfo;
extern const char *NNTPpointer;
extern const char *NNTPpoll;
#endif

#if (defined(POP) || defined(POP2CLIENT) || defined(POP2SERVER) || defined(POP3CLIENT) || defined(POP3SERVER))
extern const char *Popusers;		/* POP user and password file */
#endif

#ifdef REJECT
extern const char *REJECTFile;		/* Message rejection file */
#endif

#ifdef ROUTESERVER
extern const char *RouteServer;		/* Enabled remote encap routes */
#endif

#ifdef STATS
extern const char *STATSDir;		/* Statistics directory */
#endif

#ifdef TUTOR
extern const char *Info;		/* Information Center directory */
extern const char *News;		/* News Center directory */
extern const char *Tutor;		/* Tutorial Server directory */
extern const char *UCmdsHelp;		/* BBS CMD help file */
extern const char *UserCmds;		/* BBS CMD directory */
#endif

#ifdef USERLOG
extern const char *UDefaults;		/* User preference file */
extern const char *UDefbak;		/* Backup of preference file */
#endif

#ifdef WPAGES
extern const char *WhitePages;		/* White Pages user log file */
extern const char *WhitePagesBBS;	/* White Pages BBS log file */
extern const char *WPUpdateFile;	/* White Pages update temp file */
#endif



#ifdef UNIX
/* Session manager defaults */
extern const char *Trace_sessmgr;	/* Session manager for Trace session */
extern const char *Command_sessmgr;	/* Session manager for Command session */
#endif

extern const char *rootdir;


void assign_filenames (const char *config,int verbose);
void initroot (char *root);
long userlogin (const char *name,char *pass,char **path,int len,int *pwdignore);
void rootdircat (char const **filename);
char *userlookup (const char *username,char **password,char **directory,
			long *permission,uint32 *ip_address);
int permcheck (char *path,long perms,int op,char *file);
void list_filenames (int create);

#endif	/* _FILES_H */

