/* application to convert JNOS (or TNOS prior to release 1.15) forward.bbs
   files to TNOS format
 */

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include "ctype.h"


#ifndef _lint
static char rcsid[] OPTIONAL = "$Id: cnvfwd.c,v 1.5 1996/06/22 18:20:37 root Exp root $";
#endif

#define NULLFILE	((FILE *)0)
#define NULLCHAR	((char *)0)
#define OUTSIDE_BBS	0
#define CONNECT_BBS	1
#define INSIDE_BBS	2
#define FWD_SCRIPT	3
#define FWD_AREAS	4


int
main (int argc, char *argv[])
{
FILE *in, *out;
char buffer[81];
int thestate = OUTSIDE_BBS;
char *searchstring = NULLCHAR;
char *cp;
int starttime = 0, endtime = 0, foundtime = 0;

	if (argc < 3)	{
		printf ("cnvfwd: Application to convert JNOS forward.bbs file to TNOS format\n");
		printf ("\nSyntax: cnvfwd oldfile newfile\n");
		exit (1);
	}

	if ((in = fopen (argv[1], "r")) == NULLFILE)	{
		printf ("cnvfwd: Can't open oldfile '%s': error #%d\n", argv[1], errno);
		exit (1);
	}
	if ((out = fopen (argv[2], "w")) == NULLFILE)	{
		printf ("cnvfwd: Can't open newfile '%s': error #%d\n", argv[2], errno);
		exit (1);
	}

	while (fgets (buffer, 80, in))	{
		switch (*buffer)	{
			case '-':	if (thestate == FWD_AREAS || thestate == FWD_SCRIPT)
						fputs ("}\n\n", out);
					thestate = OUTSIDE_BBS;
					fprintf (out, "%s\n", buffer);
					break;

			case '#':	fputs (buffer, out);
					break;

			case '!':	if (thestate > INSIDE_BBS)
						fputs ("}\n\n", out);
					thestate = INSIDE_BBS;
					fputs ("REVINCOMING = NO\n", out);
					break;

			case '=':	if (thestate > INSIDE_BBS)
						fputs ("}\n\n", out);
					thestate = INSIDE_BBS;
					fprintf (out, "SUBCHANNEL =%s%s", (buffer[1] == ' ') ? "" : " ", &buffer[1]);
					break;

			case '.':	if (thestate == FWD_AREAS)
						fputs ("}\n\n", out);
					if (thestate != FWD_SCRIPT)
						fputs ("\nSCRIPT = {\n", out);
					thestate = FWD_SCRIPT;
					cp = &buffer[1];
					if (*cp == ' ')
						cp++;
					fprintf (out, " SEND %s", cp);
					break;

			case '+':	if (thestate == FWD_AREAS)
						fputs ("}\n\n", out);
					if (thestate != FWD_SCRIPT)
						fputs ("\nSCRIPT = {\n", out);
					thestate = FWD_SCRIPT;
					if (searchstring)
						free(searchstring);
					cp = &buffer[1];
					if (*cp == ' ')
						cp++;
					searchstring = strdup(cp);
					break;

			case '@':	if (thestate == FWD_AREAS)
						fputs ("}\n\n", out);
					if (thestate != FWD_SCRIPT)
						fputs ("\nSCRIPT = {\n", out);
					thestate = FWD_SCRIPT;
					fprintf (out, " WAIT %d %s", atoi (&buffer[1]), searchstring);
					break;

			case '[':	if (thestate == FWD_AREAS)
						fputs ("}\n\n", out);
					if (thestate != FWD_SCRIPT)
						fputs ("\nSCRIPT = {\n", out);
					thestate = FWD_SCRIPT;
					fprintf (out, " SID %s", buffer);
					break;
			default:	if (thestate == OUTSIDE_BBS)	{
						cp = strpbrk (buffer, " \t\n");
						if (cp)
							*cp++ = 0;
						fprintf (out, "[%s]\n", buffer);
						if (cp && *cp && isdigit (*cp))	{
							starttime = (atoi (cp) / 100);
							endtime = (atoi (cp) % 100);
							foundtime = 1;
							cp += 4;
						} else	
							starttime = endtime = foundtime = 0;
						if (cp && strpbrk (cp, "pP"))
							fputs ("POLL = YES\n", out);
						thestate = CONNECT_BBS;
					} else	if (thestate == CONNECT_BBS)	{
						if (foundtime)
							fprintf (out, "\nif TIME = %02d00-%02d00\n ", starttime, endtime);
						fprintf (out, "CONNECT = %s", buffer);
						if (foundtime)
							fputs ("endif\n\n", out);
						thestate = INSIDE_BBS;
					} else	{
						if (thestate == FWD_SCRIPT)
							fputs ("}\n\n", out);
						if (thestate != FWD_AREAS)
							fputs ("\nAREAS = {\n", out);
						thestate = FWD_AREAS;
						fprintf (out, " %s", buffer);
					}
					break;
		}
	}
	fclose (in);
	fclose (out);
	printf ("cnvfwd: Process complete!\n");
	return 0;
}
