#include <stdio.h>
#include <string.h>

#ifndef _lint
static char rcsid[] OPTIONAL = "$Id: checkcat.c,v 1.6 1996/06/22 18:20:37 root Exp root $";
#endif


#define CATFILE		"/etc/catalog.cat"

#define NULLFILE	((FILE *)0)

int
main (void)
{
char buffer[256];
FILE *cat;
long datasize = 0;
int numstrings = 0;

	/* open the input catalog file */
	if ((cat = fopen (NOSDIR CATFILE, "rt")) == NULLFILE)	{
		printf ("checkcat: can't open '%s'\n", CATFILE);
		return (1);
	}

	/* read the identification record as the first one in the cat file */
	if (fread (buffer, 1, 256, cat))
		printf (buffer);

	/* loop while there is data left in the data file */
	while (fread (buffer, 1, 256, cat))	{
		datasize += (long) strlen(buffer);
		numstrings++;
	}

	fclose (cat);

	/* tell the user all is well */
	printf ("checkcat: %ld bytes of string data (%d lines) in catalog file!\n", datasize, numstrings);
	return 0;
}

