#!/bin/sh

USEELF=0
export USEELF

if [ -f make.inc ]
then
	mv -f make.inc make.inc.old
fi
touch make.inc

if [ -f system.h ]
then
	mv -f system.h system.h.old
fi


echo ""
echo Examining system in order to build you a default 'make.inc' file.
echo ""

# Place initial header into the 'system.h' file
cat >system.h <<EOF
#ifndef _SYSTEM_H
#define _SYSTEM_H

/*
 * Automatically generated C system config file: don't edit
 */

/*
 * TNOS system configuration
 */

/* clear all flags, initially */
#undef BROKE_SPRINTF
#undef BSD
#undef BSD_RANDOM
#undef HAVE_BINARY_LOCKFILES
#undef HAVE_NCURSES_H
#undef HAVE_NETINET_IF_ETHER_H
#undef HAVE_SYS_MOUNT_H
#undef HAVE_SYS_PARAM_H
#undef HAVE_SYS_STATFS_H
#undef HAVE_SYS_VFS_H
#undef HAVE_TM_ISDST
#undef HAVE_UNISTD_H
#undef IS_LITTLE_ENDIAN
#undef NO_CURSES_TMARG
#undef NO_GETTOD
#undef NO_SETENV
#undef NO_SETTOD
#undef NO_STRTOUL
#undef STACKBASE
#undef SYS_ERRLIST
#undef TNOS_BP
#undef TNOS_CRTSCTS
#undef TNOS_EBP
#undef TNOS_PC
#undef TNOS_SP
#undef USE_SETSTACK



/*
 *
 * Only those features applicable to this system are defined below
 *
 */


EOF


# First, a check for a ELF/AOUT capable system.....

if [ -d /usr/i[3456]86-linuxaout ]
then
	USEELF=1
fi

# Looking for GCC
echo "Checking configuration of the C compiler..."

CC=cc
export CC
if ( type gcc | cut -d ' ' -f 3 >/dev/null 2>&1)
then
	CC=gcc
	echo "Found GCC at `type gcc | cut -d ' ' -f 3`"
fi



# Now that we have made an initial LOOK at the system, lets see if reality
# agrees with our quick look.....

# First we will create a 'Hello World' C program, and try compiling it
# in different ways.....

rm -f hw.c

echo "#include <stdio.h>" >hw.c
echo "void main (void) {" >>hw.c
echo "printf (\"Hello World!\n\");" >>hw.c
echo "}" >>hw.c

echo Testing compiler options....
if $CC hw.c -o hw 2>/dev/null;
then
	echo Standard compiler options work
	if [ ${USEELF} = 1 ]
	then
		echo Your system LOOKS like it is set up for AOUT/ELF compiling
		USEELF=0
	fi
elif $CC -b i486-linuxaout hw.c -o hw  2>/dev/null;
then
	echo You seem to have an ELF compiler, using aout format
	if [ ${USEELF} = 0 ]
	then
		echo Resetting USEELF compiler options appropriately
		USEELF=1
	fi
else
	echo WARNING!!! Cannot determine the compiler options automatically.
	echo You will need to manually edit the make.inc file, and set
	echo the 'CC' line for your compiler.
fi

rm -f hw.c hw


# Setup the CC variable.....
echo Setting proper CC variable based on: USEELF=${USEELF}
if [ ${USEELF} = 1 ]
then
#	echo Seems to be an ELF/AOUT capable system - setting USEELF = 1
	echo USEELF = 1 >>make.inc
fi
echo CC = $CC >>make.inc


if [ "$CC" = "gcc" ]
then
	# Check if we can define OPTIONAL....
	GCCVERSION=`gcc --version`
	export GCCVERSION

	case $GCCVERSION in
		2.7.* )
#			echo GCC 2.7.0 or greater found - Setting OPTIONAL to eliminate warnings
			echo 'OPTIONAL = "-DOPTIONAL=__attribute__ ((unused))"' >>make.inc ;;
		2.6.* ) ;;
		2.5.* ) ;;
		* )
			echo There may be a problem with GCC as the version returned was "${GCCVERSION}"
	esac
fi


echo ""
echo "puts okay" >hw.tcl
if [ `tclsh hw.tcl | grep "okay" | wc -l` -ne 1 ]
then
	echo Cannot determine path for tclsh! This IS a problem!!!
else
	type tclsh >hw.temp
	cat >hw.tcl <<EOF
set line [exec cat hw.temp]

set path [lindex \$line [expr [llength \$line] - 1]]
if {[string first "(" \$path] != -1}	{
	set path [string range \$path 1 [expr [string length \$path] - 2]]
}

puts \$path
EOF
	echo Setting TCL = `tclsh hw.tcl`
	echo TCL = `tclsh hw.tcl` >>make.inc
	fi

rm -f hw.temp hw.tcl

echo ""
ncurses=0
export ncurses
# Check for ncurses directory....
if [ -d /usr/include/ncurses -o -f /usr/local/include/ncurses.h -o -f /usr/include/ncurses.h ]
then
	echo "/* System has NCURSES header files */" >>system.h
	echo "#define HAVE_NCURSES_H		1" >>system.h
	echo "" >>system.h
	ncurses=1
	echo The ncurses header files were found where they were expected....
	if [ -d /usr/include/ncurses -a -f /usr/include/ncurses/ncurses.h ]
	then
		echo ICURSES = -I/usr/include/ncurses
	fi
else
	echo "You either do not have NCURSES installed or have a recent version"
	echo "(it's hard to tell the difference)..."
	echo ""
	if [ -f /usr/include/curses.h ]
	then
		echo "Since a curses.h file was found, we'll assume a recent ncurses version"
		echo "(or that you have regular curses) and let the compiler include it instead..."
	else
		echo "Sorry, but NO header files for NCURSES (or curses) was found! This WILL need help!"
	fi
fi


# Now check for libncurses.a (or libcurses.a) existing
cat >hw.c <<EOF
#include <stdio.h>

void
main (void)
{
	printf ("Hello World!\n");
}
EOF

echo Testing for libncurses.a....
if $CC hw.c -o hw -lncurses 2>/dev/null;
then
	echo "Library libncurses.a found!"
else
	echo Testing for libcurses.a....
	if $CC hw.c -o hw -lcurses 2>/dev/null;
	then
		echo "Library libcurses.a found!"
		echo "Note: SOME curses will work, and some won't. Consider installing ncurses"
		echo ""
		echo LCURSES = -lcurses >>make.inc
	else
		echo
		echo "Neither libncurses.a nor libcurses.a was found!"
		echo "You need curses (or ncurses) installed"
		echo LCURSES = >>make.inc
	fi
fi
rm -f hw.c hw


cat >>system.h <<EOF
/* OS-specific flags */

EOF


# Now check to see if it is LITTLE/BIG ENDIAN
rm -f hw.state
cat >hw.c <<EOF
#include <stdio.h>

void
main (void) {
char buffer[10];
char *cp;
long *lp;
FILE *fp;

	cp = buffer;
	lp = (long *) cp;
	*lp = 0x01020304;
	if (*cp == 4 && cp[1] == 3 && cp[2] == 2 && cp[3] == 1)	{
		/* IS LITTLE ENDIAN */
		fp = fopen ("hw.state", "w");
		fclose (fp);
	}
}
EOF
	$CC hw.c -o hw 2>/dev/null
	./hw
	if [ -f hw.state ]
	then
		rm -f hw.state
		echo "System is Little-Endian..."
		cat >>system.h <<EOF
/* System is Little-Endian */
#define IS_LITTLE_ENDIAN	1
EOF
	fi


# Now set the OSTYPE to the proper value
OSTYPE=`uname`
export OSTYPE

case $OSTYPE in
	AIX )
		cat >>system.h <<EOF
#define HAVE_BINARY_LOCKFILES   1
#define STACKBASE               0x80000000LU
#define TNOS_PC(p)              (p->env[2])
#define TNOS_SP(p)              (p->env[3])
#define SYS_ERRLIST(x)		""

EOF
		;;
	BSD/OS )
		# Now, modify the PATCHES and SETSTACK to use the needed flags
		cat >>system.h <<EOF
#define USE_SETSTACK		1
#define HAVE_BINARY_LOCKFILES	1
#define STACKBASE		0x80000000LU
#define BSD_RANDOM		1
#define BSD			1

EOF
		echo "SETSTACK = setsp.o" >>make.inc
		OSTYPE=BSDI ;;
	SunOS )
		cat >>system.h <<EOF
#define HAVE_BINARY_LOCKFILES	1
#define STACKBASE		0x80000000LU
#define BSD			1
#include <setjmp.h>
#if _JBLEN == 9 || _JBLEN == 58
#define TNOS_PC(p)		(p->env[3])
#define TNOS_SP(p)		(p->env[2])
#elif _JBLEN == 12
#define TNOS_PC(p)		(p->env[2])
#define TNOS_SP(p)		(p->env[1])
#else
#error error: unknown jmp_buf size
#endif

EOF
		;;
	IRIX )
		cat >>system.h <<EOF
#define STACKBASE		0x80000000LU
#define TNOS_PC(p)		(p->env[JB_PC])
#define TNOS_SP(p)		(p->env[JB_SP])

EOF
		;;
	FreeBSD )
		cat >>system.h <<EOF
#define STACKBASE		0x80000000LU
#define USE_SETSTACK		1

EOF
		echo "SETSTACK = setsp.o" >>make.inc ;;
	Linux )
		cat >>system.h <<EOF
#define STACKBASE		0xC0000000LU
#define USE_SETSTACK		1

EOF
		echo "SETSTACK = setsp.o" >>make.inc ;;
	* ) 
		echo "*** Don't know how to handle the stack manipulation for ${OSTYPE}!"
		exit 1
		;;
esac
echo Setting OSTYPE = ${OSTYPE}
echo ""
echo OSTYPE = ${OSTYPE} >>make.inc



# Check for MSQL, and if not found, disable the appropriate flags
if [ ! -d /usr/local/Minerva/lib ]
then
	echo The MSQL package was NOT found, so it is being disabled....
	echo "*** You will want to say 'NO' when prompted for 'SQL Server support'"
	echo "*** in the configuration program...."
	echo LSQL = >>make.inc
	echo ISQL = >>make.inc
else
	echo The MSQL package WAS found, so it is being left enabled....
	echo "*** You can say 'YES' when prompted for 'SQL Server support'"
	echo "*** in the configuration program (if desired)...."
fi


#
# Search for certain header files
#
echo ""
echo "Searching for several header files..."


# Searching for unistd.h header file

	cat >hw.c <<EOF
#include <stdio.h>
#include <unistd.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <unistd.h> header file */
#define HAVE_UNISTD_H		1

EOF
	fi


# Searching for sys/statfs.h header file...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/types.h>
#include <sys/statfs.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <sys/statfs.h> header file */
#define HAVE_SYS_STATFS_H	1

EOF
	fi

# Searching for sys/param.h header file...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <sys/param.h> header file */
#define HAVE_SYS_PARAM_H	1

EOF
	fi

# Searching for sys/mount.h header file...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/types.h>
#include <sys/mount.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <sys/mount.h> header file */
#define HAVE_SYS_MOUNT_H	1

EOF
	fi


# Searching for sys/vfs.h header file...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/types.h>
#include <sys/vfs.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <sys/vfs.h> header file */
#define HAVE_SYS_VFS_H		1

EOF
	fi


# Searching for netinet/if_ether.h header file...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/types.h>
#include <netinet/if_ether.h>

void main (void) {
	printf ("Hello World!\n");
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System has the <netinet/if_ether.h> header file */
#define HAVE_NETINET_IF_ETHER_H		1

EOF
	fi


#
# Search for certain functions
#
echo "Searching for several library functions..."

# Searching for setenv()...

	cat >hw.c <<EOF
#include <stdio.h>

void main (void) {
	setenv ("label", "value", 1);
}
EOF

	if $CC hw.c -o hw 2>/dev/null;
	then
		:
	else
		cat >>system.h <<EOF
/* System doesn't have the setenv() function */
#define NO_SETENV		1

EOF
	fi




# Searching for strtoul()...

	cat >hw.c <<EOF
#include <stdio.h>
#include <stdlib.h>

void main (int argc, char *argv[]) {
long result;

	result = strtoul (argv[1], (char **)0, 0);
}
EOF

	if $CC hw.c -o hw 2>/dev/null;
	then
		:
	else
		cat >>system.h <<EOF
/* System doesn't have the strtoul() function */
#define NO_STRTOUL		1

EOF
	fi


# Searching for gettimeofday()...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

void main (int argc, char *argv[]) {
struct timezone tz;
struct timeval tv;

        (void) gettimeofday (&tv, &tz);
}
EOF

	if $CC hw.c -o hw 2>/dev/null;
	then
		:
	else
		cat >>system.h <<EOF
/* System doesn't have the gettimeofday() function */
#define NO_GETTOD		1

EOF
	fi


# Searching for settimeofday()...

	cat >hw.c <<EOF
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>

void main (int argc, char *argv[]) {
struct timezone tz;
struct timeval tv;

        (void) settimeofday (&tv, NULL);
}
EOF

	if $CC hw.c -o hw 2>/dev/null;
	then
		:
	else
		cat >>system.h <<EOF
/* System doesn't have the settimeofday() function */
#define NO_SETTOD		1

EOF
	fi


# Testing sprintf() to see if it is broken...

	rm -f hw.state
	cat >hw.c <<EOF
#include <stdio.h>

void main (void) {
char buffer[100];
FILE *fp;

	if (sprintf (buffer, "This is a %s\n", "test") != 15)	{
		fp = fopen ("hw.state", "w");
		fclose (fp);
	}
}
EOF

	$CC hw.c -o hw 2>/dev/null
	./hw
	if [ -f hw.state ]
	then
		rm -f hw.state
		cat >>system.h <<EOF
/* System has a broken sprintf() function */
#define BROKEN_SPRINTF		1

EOF
	fi


#
# Search for certain constant values
#
echo "Searching for certain constant values that differ on several systems..."

# Determining the value for termios RTSCTS...

	rm -f hw.state
	cat >hw.c <<EOF
#include <stdio.h>
#include <termios.h>

#ifndef CRTSCTS
#ifdef CNEW_RTSCTS
#define CRTSCTS	     CNEW_RTSCTS
#else
#ifdef CCTS_OFLOW
#define CRTSCTS      CCTS_OFLOW
#else
#define CRTSCTS      0x80000000
#endif
#endif
#endif

void main (void) {
FILE *fp;

	fp = fopen ("hw.state", "w");
	fprintf (fp, "0x%08lxUL", CRTSCTS);
	fclose (fp);
}
EOF

	if $CC hw.c -o hw 2>/dev/null;
	then
		./hw
		if [ -f hw.state ]
		then
			ans=`cat hw.state`
			rm -f hw.state
		fi
	else
		echo "*** can't determine RTSCTS constant ***"
		echo "*** using default of 0x80000000, though this *IS* a problem ***"
		ans=0x80000000UL
	fi
	export ans
	cat >>system.h <<EOF
/* Value of termios RTSCTS constant */
#define TNOS_CRTSCTS		$ans

EOF



#
# Search for certain structure fields files
#
echo "Searching for certain structure fields that differ on several systems..."


# Determining how to handle timezones...

	cat >hw.c <<EOF
#include <stdio.h>
#include <time.h>

void main (void) {
struct tm t;
char *cp;

	t.tm_isdst = 1;
	cp = tzname[0];
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		cat >>system.h <<EOF
/* System's tm structure has the tm_isdst member  */
#define HAVE_TM_ISDST		1

EOF
	else
		cat >hw.c <<EOF
#include <stdio.h>
#include <time.h>

void main (void) {
struct tm t;
char *cp;

	cp = t.tm_zone;
}
EOF

		if $CC -c hw.c 2>/dev/null;
		then
			:
		else
			echo "*** CANNOT handle timezones! ***"
		fi
	fi


# Determining how to handle curses WINDOW->_tmarg...

	cat >hw.c <<EOF
#include <stdio.h>
#include <time.h>
EOF
	if [ ${ncurses} = 1 ]
	then
		echo "#include <ncurses.h>" >>hw.c
	else
		echo "#include <curses.h>" >>hw.c
	fi
	cat >>hw.c <<EOF

void main (void) {
WINDOW w;

	w._tmarg = 1;
}
EOF

	if $CC -c hw.c 2>/dev/null;
	then
		:
	else
		cat >>system.h <<EOF
/* System's curses WINDOW structure has no _tmarg member */
#define NO_CURSES_TMARG		1

EOF
	fi



rm -f hw.c hw hw.o



# Check the directory for installation....
NOSDIR=/nos
response=n
export NOSDIR response
echo ""
echo The default directory to install TNOS in is /nos.
echo ""
echo 'Do you wish to change this? (*n/y)'
read response
if [ -n "${response}" -a ".${response}" = ".y" ]
then
	echo ""
	echo Enter new path for installation:
	read NOSDIR
	echo Setting NOSDIR = ${NOSDIR}
	echo NOSDIR = ${NOSDIR} >>make.inc
fi



# Disable automatic c2man MAN page generation
echo C2MAN_AUTO = true >>make.inc


cat >>system.h <<EOF

#endif	/* _SYSTEM_H */

EOF


# The next section restores original file, if no changes
# This prevents unnecessary makes due to only system.h changing
if [ -f system.h.old ]
then
	if [ `diff system.h system.h.old | wc -l` -eq 0 ]
	then
		mv -f system.h.old system.h
		echo ""
		echo "System settings haven't changed - restoring previous file"
	fi
fi


# All done, tell the user, and exit non-zero, to make the initial 'make' fail.
# This will force the user to restart, now reading the 'make.inc' file created.
echo ""
echo This is the best that can be done, for now, hopefully it is all that
echo is needed!
echo ""
echo You will need to re-execute your make command for these setting to take
echo "effect. Exiting Makefile (with Error 1) to force you to start again ;-)...."

exit 1

