/*
 * mkiss.c
 * Fake out AX.25 code into supporting dual port TNCS by routing serial
 * port data to/from two pseudo ttys.
 *
 * Version 1.0
 *
 * N0BEL
 * Kevin Uhlir
 * kevinu@flochart.com
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>
#include <ctype.h>

#define	TRUE		1
#define	FALSE		0


struct speed_struct
{
	int     user_speed;
	speed_t termios_speed;
}
speed_table[] =
{
	{300,		B300},
	{600,		B600},
	{1200,		B1200},
	{2400,		B2400},
	{4800,		B4800},
	{9600,		B9600},
	{19200,		B19200},
	{38400,		B38400},
	{-1,		B0}
};


int setspeed(int fd, int speed)
{
	struct termios term;
	struct speed_struct *s;

	s = speed_table;
	if (speed > 0) {
		for (s = speed_table; s->user_speed != -1; s++)
			if (s->user_speed == speed)
				break;

		if (s->user_speed == -1)
		{
			fprintf(stderr, "Invalid speed %d\n", speed);
			return(FALSE);
		}
	}
	
	if (tcgetattr(fd, &term) == -1)
	{
		perror("tcgetattr");
		return(FALSE);
	}

	if (speed > 0) {	
		cfsetispeed(&term, s->termios_speed);
		cfsetospeed(&term, s->termios_speed);
	}

	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 2;
	term.c_iflag = 0;
	term.c_oflag = 0;
	term.c_lflag = 0;
#ifdef CIBAUD
	term.c_cflag = (term.c_cflag & (CBAUD | CIBAUD)) | CREAD | CS8;
#else
	term.c_cflag = (term.c_cflag & CBAUD) | CREAD | CS8;
#endif
#ifdef CRTSCTS
	term.c_cflag |= CRTSCTS;
#endif
	
	if (tcsetattr(fd, TCSANOW, &term) == -1)
	{
		perror("tcsetattr");
		return(FALSE);
	}
	
	return(TRUE);
}

#define SIZE 4096

int main(int argc, char *argv[])
{
	int  fd;
	int  fd0;
	int  fd1;
	int  fdc;
	int  fd_state;
	int  fd0_state;
	int  fd1_state;
	int  size;
	unsigned char ibuf[SIZE];
	unsigned char obuf[SIZE];
	unsigned char *icp, *ocp;
	fd_set readfd;
	int verbose = 0;

	int  speed = 0;

	if (argc > 2) {
		if (strcmp(argv[1],"-v") == 0) {
			verbose++;
			argv++;
			argc--;
		}
	}	
	if(argc == 6)
	{
		if(strcmp(argv[1],"-s")==0)
		{
			if(sscanf(argv[2],"%d",&speed)!=1)
			{
				fprintf(stderr,"%s: Invalid speed '%s'\n",argv[0],argv[2]);
				exit(1);
			}
			argv+=2;
			argc-=2;
		}	
	}
	
	if (argc != 4)
	{
		fprintf(stderr,"%s [-s <speed>] <ttyinterface> <pty0> <pty1>.\n", argv[0]);
		return(1);
	}
	
	if ((fd = open(argv[1], O_RDWR | O_NDELAY)) == -1)
	{
		perror(argv[1]);
		return(1);
	}

	if (!setspeed(fd, speed))
		return(1);

	if ((fd0 = open(argv[2], O_RDWR )) == -1)
	{
		perror(argv[2]);
		return(1);
	}
	if ((fd1 = open(argv[3], O_RDWR )) == -1)
	{
		perror(argv[3]);
		return(1);
	}

	signal(SIGHUP, SIG_IGN);

	fd_state = 1;
	fd0_state = 1;
	fd1_state = 1;	
	fdc = fd0;
	while (1) {
		FD_ZERO(&readfd);
		FD_SET(fd,&readfd);
		FD_SET(fd0,&readfd);
		FD_SET(fd1,&readfd);
		select(FD_SETSIZE,&readfd,0,0,0);
		if (FD_ISSET(fd,&readfd)) {
			size = read(fd,ibuf,SIZE);
			if (size < 0) {
				perror("fd");
				break;
			}
			for (icp = ibuf, ocp = obuf; size > 0; size--, icp++) {
				if (fd_state == 2) {
					*ocp++ = 0xc0;
					if (*icp & 0xf0) {
						fdc = fd1;
					} else {
						fdc = fd0;
					}
					*icp = *icp & 0x0f;
					fd_state = 0;
				} else if (*icp == 0xc0 && fd_state == 1) {
					fd_state = 2;
				} else if (*icp == 0xc0) {
						fd_state = 1;
				}
				if (fd_state == 2) {
					write(fdc,obuf,ocp-obuf);
					if (verbose) printf("wrote %d to %d\n",ocp-obuf,fdc);
					ocp = obuf;
					continue;
				}
				*ocp++ = *icp;
			}
			write(fdc,obuf,ocp-obuf);
			if (verbose) printf("wrote %d to %d\n",ocp-obuf,fdc);
		}
		if (FD_ISSET(fd0,&readfd)) {
			size = read(fd0,ibuf,SIZE);
			if (size < 0) {
				perror("fd0");
				break;
			}
			for (icp = ibuf, ocp = obuf; size > 0; size--, icp++) {
				if (fd_state == 2) {
					*icp = *icp & 0x0f;
					fd_state = 0;
				} else if (*icp == 0xc0 && fd_state == 1) {
					fd_state = 2;
				} else if (*icp == 0xc0) {
						fd_state = 1;
				}
				*ocp++ = *icp;
			}
			write(fd,obuf,ocp-obuf);
			if (verbose) printf("wrote %d to %d\n",ocp-obuf,fd);
		}
		if (FD_ISSET(fd1,&readfd)) {
			size = read(fd1,ibuf,SIZE);
			if (size < 0) {
				perror("fd1");
				break;
			}
			for (icp = ibuf, ocp = obuf; size > 0; size--, icp++) {
				if (fd_state == 2) {
					*icp = (*icp & 0x0f) | 0x10;
					fd_state = 0;
				} else if (*icp == 0xc0 && fd_state == 1) {
					fd_state = 2;
				} else if (*icp == 0xc0) {
						fd_state = 1;
				}
				*ocp++ = *icp;
			}
			write(fd,obuf,ocp-obuf);
			if (verbose) printf("wrote %d to %d\n",ocp-obuf,fd);
		}

	}
		
	/* NOT REACHED */
	return(0);
}
